/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.org.objectweb.asm.util;

import com.contrastsecurity.thirdparty.org.objectweb.asm.Attribute;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Handle;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Label;
import com.contrastsecurity.thirdparty.org.objectweb.asm.Type;
import com.contrastsecurity.thirdparty.org.objectweb.asm.TypePath;
import com.contrastsecurity.thirdparty.org.objectweb.asm.TypeReference;
import com.contrastsecurity.thirdparty.org.objectweb.asm.signature.SignatureReader;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.Printer;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.TextifierSupport;
import com.contrastsecurity.thirdparty.org.objectweb.asm.util.TraceSignatureVisitor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Textifier
extends Printer {
    private static final String USAGE = "Prints a disassembled view of the given class.\nUsage: Textifier [-nodebug] <fully qualified class name or class file name>";
    public static final int INTERNAL_NAME = 0;
    public static final int FIELD_DESCRIPTOR = 1;
    public static final int FIELD_SIGNATURE = 2;
    public static final int METHOD_DESCRIPTOR = 3;
    public static final int METHOD_SIGNATURE = 4;
    public static final int CLASS_SIGNATURE = 5;
    public static final int HANDLE_DESCRIPTOR = 9;
    private static final String CLASS_SUFFIX = ".class";
    private static final String DEPRECATED = "// DEPRECATED\n";
    private static final String RECORD = "// RECORD\n";
    private static final String INVISIBLE = " // invisible\n";
    private static final List<String> FRAME_TYPES = Collections.unmodifiableList(Arrays.asList("T", "I", "F", "D", "J", "N", "U"));
    protected String tab = "  ";
    protected String tab2 = "    ";
    protected String tab3 = "      ";
    protected String ltab = "   ";
    protected Map<Label, String> labelNames;
    private int access;
    private int numAnnotationValues;

    public Textifier() {
        this(589824);
        if (this.getClass() != Textifier.class) {
            throw new IllegalStateException();
        }
    }

    protected Textifier(int n2) {
        super(n2);
    }

    public static void main(String[] stringArray) throws IOException {
        Textifier.main(stringArray, new PrintWriter(System.out, true), new PrintWriter(System.err, true));
    }

    static void main(String[] stringArray, PrintWriter printWriter, PrintWriter printWriter2) throws IOException {
        Textifier.main(stringArray, USAGE, new Textifier(), printWriter, printWriter2);
    }

    public void visit(int n2, int n3, String string, String string2, String string3, String[] stringArray) {
        if ((n3 & 0x8000) != 0) {
            return;
        }
        this.access = n3;
        int n4 = n2 & 0xFFFF;
        int n5 = n2 >>> 16;
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("// class version ").append(n4).append('.').append(n5).append(" (").append(n2).append(")\n");
        if ((n3 & 0x20000) != 0) {
            this.stringBuilder.append(DEPRECATED);
        }
        if ((n3 & 0x10000) != 0) {
            this.stringBuilder.append(RECORD);
        }
        this.appendRawAccess(n3);
        this.appendDescriptor(5, string2);
        if (string2 != null) {
            this.appendJavaDeclaration(string, string2);
        }
        this.appendAccess(n3 & 0xFFFF7FDF);
        if ((n3 & 0x2000) != 0) {
            this.stringBuilder.append("@interface ");
        } else if ((n3 & 0x200) != 0) {
            this.stringBuilder.append("interface ");
        } else if ((n3 & 0x4000) == 0) {
            this.stringBuilder.append("class ");
        }
        this.appendDescriptor(0, string);
        if (string3 != null && !"java/lang/Object".equals(string3)) {
            this.stringBuilder.append(" extends ");
            this.appendDescriptor(0, string3);
        }
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(" implements ");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.appendDescriptor(0, stringArray[i2]);
                if (i2 == stringArray.length - 1) continue;
                this.stringBuilder.append(' ');
            }
        }
        this.stringBuilder.append(" {\n\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitSource(String string, String string2) {
        this.stringBuilder.setLength(0);
        if (string != null) {
            this.stringBuilder.append(this.tab).append("// compiled from: ").append(string).append('\n');
        }
        if (string2 != null) {
            this.stringBuilder.append(this.tab).append("// debug info: ").append(string2).append('\n');
        }
        if (this.stringBuilder.length() > 0) {
            this.text.add(this.stringBuilder.toString());
        }
    }

    public Printer visitModule(String string, int n2, String string2) {
        this.stringBuilder.setLength(0);
        if ((n2 & 0x20) != 0) {
            this.stringBuilder.append("open ");
        }
        this.stringBuilder.append("module ").append(string).append(" { ").append(string2 == null ? "" : "// " + string2).append("\n\n");
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public void visitNestHost(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("NESTHOST ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitOuterClass(String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("OUTERCLASS ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append(' ');
        if (string2 != null) {
            this.stringBuilder.append(string2).append(' ');
        }
        this.appendDescriptor(3, string3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Textifier visitClassAnnotation(String string, boolean bl) {
        this.text.add("\n");
        return this.visitAnnotation(string, bl);
    }

    public Printer visitClassTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        this.text.add("\n");
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public void visitClassAttribute(Attribute attribute) {
        this.text.add("\n");
        this.visitAttribute(attribute);
    }

    public void visitNestMember(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("NESTMEMBER ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitPermittedSubclass(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("PERMITTEDSUBCLASS ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInnerClass(String string, String string2, String string3, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(n2 & 0xFFFFFFDF);
        this.stringBuilder.append(this.tab);
        this.appendAccess(n2);
        this.stringBuilder.append("INNERCLASS ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, string2);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, string3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitRecordComponent(String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("RECORDCOMPONENT ");
        if (string3 != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(2, string3);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(string, string3);
        }
        this.stringBuilder.append(this.tab);
        this.appendDescriptor(1, string2);
        this.stringBuilder.append(' ').append(string);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public Textifier visitField(int n2, String string, String string2, String string3, Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append('\n');
        if ((n2 & 0x20000) != 0) {
            this.stringBuilder.append(this.tab).append(DEPRECATED);
        }
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(n2);
        if (string3 != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(2, string3);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(string, string3);
        }
        this.stringBuilder.append(this.tab);
        this.appendAccess(n2);
        this.appendDescriptor(1, string2);
        this.stringBuilder.append(' ').append(string);
        if (object != null) {
            this.stringBuilder.append(" = ");
            if (object instanceof String) {
                this.stringBuilder.append('\"').append(object).append('\"');
            } else {
                this.stringBuilder.append(object);
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public Textifier visitMethod(int n2, String string, String string2, String string3, String[] stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append('\n');
        if ((n2 & 0x20000) != 0) {
            this.stringBuilder.append(this.tab).append(DEPRECATED);
        }
        this.stringBuilder.append(this.tab);
        this.appendRawAccess(n2);
        if (string3 != null) {
            this.stringBuilder.append(this.tab);
            this.appendDescriptor(4, string3);
            this.stringBuilder.append(this.tab);
            this.appendJavaDeclaration(string, string3);
        }
        this.stringBuilder.append(this.tab);
        this.appendAccess(n2 & 0xFFFFFF3F);
        if ((n2 & 0x100) != 0) {
            this.stringBuilder.append("native ");
        }
        if ((n2 & 0x80) != 0) {
            this.stringBuilder.append("varargs ");
        }
        if ((n2 & 0x40) != 0) {
            this.stringBuilder.append("bridge ");
        }
        if ((this.access & 0x200) != 0 && (n2 & 0x408) == 0) {
            this.stringBuilder.append("default ");
        }
        this.stringBuilder.append(string);
        this.appendDescriptor(3, string2);
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(" throws ");
            for (String string4 : stringArray) {
                this.appendDescriptor(0, string4);
                this.stringBuilder.append(' ');
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(null);
    }

    public void visitClassEnd() {
        this.text.add("}\n");
    }

    public void visitMainClass(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("  // main class ").append(string).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitPackage(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append("  // package ").append(string).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitRequire(String string, int n2, String string2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("requires ");
        if ((n2 & 0x20) != 0) {
            this.stringBuilder.append("transitive ");
        }
        if ((n2 & 0x40) != 0) {
            this.stringBuilder.append("static ");
        }
        this.stringBuilder.append(string).append(';');
        this.appendRawAccess(n2);
        if (string2 != null) {
            this.stringBuilder.append("  // version ").append(string2).append('\n');
        }
        this.text.add(this.stringBuilder.toString());
    }

    public void visitExport(String string, int n2, String ... stringArray) {
        this.visitExportOrOpen("exports ", string, n2, stringArray);
    }

    public void visitOpen(String string, int n2, String ... stringArray) {
        this.visitExportOrOpen("opens ", string, n2, stringArray);
    }

    private void visitExportOrOpen(String string, String string2, int n2, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append(string);
        this.stringBuilder.append(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.stringBuilder.append(" to");
        } else {
            this.stringBuilder.append(';');
        }
        this.appendRawAccess(n2);
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.stringBuilder.append(this.tab2).append(stringArray[i2]);
                this.stringBuilder.append(i2 != stringArray.length - 1 ? ",\n" : ";\n");
            }
        }
        this.text.add(this.stringBuilder.toString());
    }

    public void visitUse(String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("uses ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append(";\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitProvide(String string, String ... stringArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("provides ");
        this.appendDescriptor(0, string);
        this.stringBuilder.append(" with\n");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.stringBuilder.append(this.tab2);
            this.appendDescriptor(0, stringArray[i2]);
            this.stringBuilder.append(i2 != stringArray.length - 1 ? ",\n" : ";\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    public void visitModuleEnd() {
    }

    public void visit(String string, Object object) {
        this.visitAnnotationValue(string);
        if (object instanceof String) {
            this.visitString((String)object);
        } else if (object instanceof Type) {
            this.visitType((Type)object);
        } else if (object instanceof Byte) {
            this.visitByte((Byte)object);
        } else if (object instanceof Boolean) {
            this.visitBoolean((Boolean)object);
        } else if (object instanceof Short) {
            this.visitShort((Short)object);
        } else if (object instanceof Character) {
            this.visitChar(((Character)object).charValue());
        } else if (object instanceof Integer) {
            this.visitInt((Integer)object);
        } else if (object instanceof Float) {
            this.visitFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.visitLong((Long)object);
        } else if (object instanceof Double) {
            this.visitDouble((Double)object);
        } else if (object.getClass().isArray()) {
            this.stringBuilder.append('{');
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    this.maybeAppendComma(i2);
                    this.visitByte(byArray[i2]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int i3 = 0; i3 < blArray.length; ++i3) {
                    this.maybeAppendComma(i3);
                    this.visitBoolean(blArray[i3]);
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i4 = 0; i4 < sArray.length; ++i4) {
                    this.maybeAppendComma(i4);
                    this.visitShort(sArray[i4]);
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int i5 = 0; i5 < cArray.length; ++i5) {
                    this.maybeAppendComma(i5);
                    this.visitChar(cArray[i5]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i6 = 0; i6 < nArray.length; ++i6) {
                    this.maybeAppendComma(i6);
                    this.visitInt(nArray[i6]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int i7 = 0; i7 < lArray.length; ++i7) {
                    this.maybeAppendComma(i7);
                    this.visitLong(lArray[i7]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int i8 = 0; i8 < fArray.length; ++i8) {
                    this.maybeAppendComma(i8);
                    this.visitFloat(fArray[i8]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int i9 = 0; i9 < dArray.length; ++i9) {
                    this.maybeAppendComma(i9);
                    this.visitDouble(dArray[i9]);
                }
            }
            this.stringBuilder.append('}');
        }
        this.text.add(this.stringBuilder.toString());
    }

    private void visitInt(int n2) {
        this.stringBuilder.append(n2);
    }

    private void visitLong(long l2) {
        this.stringBuilder.append(l2).append('L');
    }

    private void visitFloat(float f2) {
        this.stringBuilder.append(f2).append('F');
    }

    private void visitDouble(double d2) {
        this.stringBuilder.append(d2).append('D');
    }

    private void visitChar(char c2) {
        this.stringBuilder.append("(char)").append((int)c2);
    }

    private void visitShort(short s2) {
        this.stringBuilder.append("(short)").append(s2);
    }

    private void visitByte(byte by) {
        this.stringBuilder.append("(byte)").append(by);
    }

    private void visitBoolean(boolean bl) {
        this.stringBuilder.append(bl);
    }

    private void visitString(String string) {
        Textifier.appendString(this.stringBuilder, string);
    }

    private void visitType(Type type) {
        this.stringBuilder.append(type.getClassName()).append(CLASS_SUFFIX);
    }

    public void visitEnum(String string, String string2, String string3) {
        this.visitAnnotationValue(string);
        this.appendDescriptor(1, string2);
        this.stringBuilder.append('.').append(string3);
        this.text.add(this.stringBuilder.toString());
    }

    public Textifier visitAnnotation(String string, String string2) {
        this.visitAnnotationValue(string);
        this.stringBuilder.append('@');
        this.appendDescriptor(1, string2);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(")");
    }

    public Textifier visitArray(String string) {
        this.visitAnnotationValue(string);
        this.stringBuilder.append('{');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier("}");
    }

    public void visitAnnotationEnd() {
    }

    private void visitAnnotationValue(String string) {
        this.stringBuilder.setLength(0);
        this.maybeAppendComma(this.numAnnotationValues++);
        if (string != null) {
            this.stringBuilder.append(string).append('=');
        }
    }

    public Textifier visitRecordComponentAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    public Printer visitRecordComponentTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public void visitRecordComponentAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitRecordComponentEnd() {
    }

    public Textifier visitFieldAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    public Printer visitFieldTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public void visitFieldAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitFieldEnd() {
    }

    public void visitParameter(String string, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("// parameter ");
        this.appendAccess(n2);
        this.stringBuilder.append(' ').append(string == null ? "<no name>" : string).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Textifier visitAnnotationDefault() {
        this.text.add(this.tab2 + "default=");
        return this.addNewTextifier("\n");
    }

    public Textifier visitMethodAnnotation(String string, boolean bl) {
        return this.visitAnnotation(string, bl);
    }

    public Printer visitMethodTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public Textifier visitAnnotableParameterCount(int n2, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("// annotable parameter count: ");
        this.stringBuilder.append(n2);
        this.stringBuilder.append(bl ? " (visible)\n" : " (invisible)\n");
        this.text.add(this.stringBuilder.toString());
        return this;
    }

    public Textifier visitParameterAnnotation(int n2, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append('@');
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(bl ? ") // parameter " : ") // invisible, parameter ").append(n2).append('\n');
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitMethodAttribute(Attribute attribute) {
        this.visitAttribute(attribute);
    }

    public void visitCode() {
    }

    public void visitFrame(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.stringBuilder.append("FRAME ");
        switch (n2) {
            case -1: 
            case 0: {
                this.stringBuilder.append("FULL [");
                this.appendFrameTypes(n3, objectArray);
                this.stringBuilder.append("] [");
                this.appendFrameTypes(n4, objectArray2);
                this.stringBuilder.append(']');
                break;
            }
            case 1: {
                this.stringBuilder.append("APPEND [");
                this.appendFrameTypes(n3, objectArray);
                this.stringBuilder.append(']');
                break;
            }
            case 2: {
                this.stringBuilder.append("CHOP ").append(n3);
                break;
            }
            case 3: {
                this.stringBuilder.append("SAME");
                break;
            }
            case 4: {
                this.stringBuilder.append("SAME1 ");
                this.appendFrameTypes(1, objectArray2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInsn(int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n2]).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitIntInsn(int n2, int n3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n2]).append(' ').append(n2 == 188 ? TYPES[n3] : Integer.toString(n3)).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitVarInsn(int n2, int n3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n2]).append(' ').append(n3).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitTypeInsn(int n2, String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n2]).append(' ');
        this.appendDescriptor(0, string);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n2]).append(' ');
        this.appendDescriptor(0, string);
        this.stringBuilder.append('.').append(string2).append(" : ");
        this.appendDescriptor(1, string3);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n2]).append(' ');
        this.appendDescriptor(0, string);
        this.stringBuilder.append('.').append(string2).append(' ');
        this.appendDescriptor(3, string3);
        if (bl) {
            this.stringBuilder.append(" (itf)");
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("INVOKEDYNAMIC").append(' ');
        this.stringBuilder.append(string);
        this.appendDescriptor(3, string2);
        this.stringBuilder.append(" [");
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3);
        this.appendHandle(handle);
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3).append("// arguments:");
        if (objectArray.length == 0) {
            this.stringBuilder.append(" none");
        } else {
            this.stringBuilder.append('\n');
            for (Object object : objectArray) {
                this.stringBuilder.append(this.tab3);
                if (object instanceof String) {
                    Printer.appendString(this.stringBuilder, (String)object);
                } else if (object instanceof Type) {
                    Type type = (Type)object;
                    if (type.getSort() == 11) {
                        this.appendDescriptor(3, type.getDescriptor());
                    } else {
                        this.visitType(type);
                    }
                } else if (object instanceof Handle) {
                    this.appendHandle((Handle)object);
                } else {
                    this.stringBuilder.append(object);
                }
                this.stringBuilder.append(", \n");
            }
            this.stringBuilder.setLength(this.stringBuilder.length() - 3);
        }
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab2).append("]\n");
        this.text.add(this.stringBuilder.toString());
    }

    public void visitJumpInsn(int n2, Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append(OPCODES[n2]).append(' ');
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLabel(Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.ltab);
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLdcInsn(Object object) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LDC ");
        if (object instanceof String) {
            Printer.appendString(this.stringBuilder, (String)object);
        } else if (object instanceof Type) {
            this.stringBuilder.append(((Type)object).getDescriptor()).append(CLASS_SUFFIX);
        } else {
            this.stringBuilder.append(object);
        }
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitIincInsn(int n2, int n3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("IINC ").append(n2).append(' ').append(n3).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label ... labelArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TABLESWITCH\n");
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.stringBuilder.append(this.tab3).append(n2 + i2).append(": ");
            this.appendLabel(labelArray[i2]);
            this.stringBuilder.append('\n');
        }
        this.stringBuilder.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOOKUPSWITCH\n");
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.stringBuilder.append(this.tab3).append(nArray[i2]).append(": ");
            this.appendLabel(labelArray[i2]);
            this.stringBuilder.append('\n');
        }
        this.stringBuilder.append(this.tab3).append("default: ");
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MULTIANEWARRAY ");
        this.appendDescriptor(1, string);
        this.stringBuilder.append(' ').append(n2).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitInsnAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        return this.visitTypeAnnotation(n2, typePath, string, bl);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TRYCATCHBLOCK ");
        this.appendLabel(label);
        this.stringBuilder.append(' ');
        this.appendLabel(label2);
        this.stringBuilder.append(' ');
        this.appendLabel(label3);
        this.stringBuilder.append(' ');
        this.appendDescriptor(0, string);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitTryCatchAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("TRYCATCHBLOCK @");
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(n2);
        this.stringBuilder.append(", ").append(typePath);
        this.stringBuilder.append(bl ? "\n" : INVISIBLE);
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n2) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOCALVARIABLE ").append(string).append(' ');
        this.appendDescriptor(1, string2);
        this.stringBuilder.append(' ');
        this.appendLabel(label);
        this.stringBuilder.append(' ');
        this.appendLabel(label2);
        this.stringBuilder.append(' ').append(n2).append('\n');
        if (string3 != null) {
            this.stringBuilder.append(this.tab2);
            this.appendDescriptor(2, string3);
            this.stringBuilder.append(this.tab2);
            this.appendJavaDeclaration(string, string3);
        }
        this.text.add(this.stringBuilder.toString());
    }

    public Printer visitLocalVariableAnnotation(int n2, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LOCALVARIABLE @");
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(n2);
        this.stringBuilder.append(", ").append(typePath);
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.stringBuilder.append(" [ ");
            this.appendLabel(labelArray[i2]);
            this.stringBuilder.append(" - ");
            this.appendLabel(labelArray2[i2]);
            this.stringBuilder.append(" - ").append(nArray[i2]).append(" ]");
        }
        this.stringBuilder.append(bl ? "\n" : INVISIBLE);
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitLineNumber(int n2, Label label) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("LINENUMBER ").append(n2).append(' ');
        this.appendLabel(label);
        this.stringBuilder.append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMaxs(int n2, int n3) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MAXSTACK = ").append(n2).append('\n');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab2).append("MAXLOCALS = ").append(n3).append('\n');
        this.text.add(this.stringBuilder.toString());
    }

    public void visitMethodEnd() {
    }

    public Textifier visitAnnotation(String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append('@');
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        return this.addNewTextifier(bl ? ")\n" : ") // invisible\n");
    }

    public Textifier visitTypeAnnotation(int n2, TypePath typePath, String string, boolean bl) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append('@');
        this.appendDescriptor(1, string);
        this.stringBuilder.append('(');
        this.text.add(this.stringBuilder.toString());
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(") : ");
        this.appendTypeReference(n2);
        this.stringBuilder.append(", ").append(typePath);
        this.stringBuilder.append(bl ? "\n" : INVISIBLE);
        return this.addNewTextifier(this.stringBuilder.toString());
    }

    public void visitAttribute(Attribute attribute) {
        this.stringBuilder.setLength(0);
        this.stringBuilder.append(this.tab).append("ATTRIBUTE ");
        this.appendDescriptor(-1, attribute.type);
        if (attribute instanceof TextifierSupport) {
            if (this.labelNames == null) {
                this.labelNames = new HashMap<Label, String>();
            }
            ((TextifierSupport)((Object)attribute)).textify(this.stringBuilder, this.labelNames);
        } else {
            this.stringBuilder.append(" : unknown\n");
        }
        this.text.add(this.stringBuilder.toString());
    }

    private void appendAccess(int n2) {
        if ((n2 & 1) != 0) {
            this.stringBuilder.append("public ");
        }
        if ((n2 & 2) != 0) {
            this.stringBuilder.append("private ");
        }
        if ((n2 & 4) != 0) {
            this.stringBuilder.append("protected ");
        }
        if ((n2 & 0x10) != 0) {
            this.stringBuilder.append("final ");
        }
        if ((n2 & 8) != 0) {
            this.stringBuilder.append("static ");
        }
        if ((n2 & 0x20) != 0) {
            this.stringBuilder.append("synchronized ");
        }
        if ((n2 & 0x40) != 0) {
            this.stringBuilder.append("volatile ");
        }
        if ((n2 & 0x80) != 0) {
            this.stringBuilder.append("transient ");
        }
        if ((n2 & 0x400) != 0) {
            this.stringBuilder.append("abstract ");
        }
        if ((n2 & 0x800) != 0) {
            this.stringBuilder.append("strictfp ");
        }
        if ((n2 & 0x1000) != 0) {
            this.stringBuilder.append("synthetic ");
        }
        if ((n2 & 0x8000) != 0) {
            this.stringBuilder.append("mandated ");
        }
        if ((n2 & 0x4000) != 0) {
            this.stringBuilder.append("enum ");
        }
    }

    private void appendRawAccess(int n2) {
        this.stringBuilder.append("// access flags 0x").append(Integer.toHexString(n2).toUpperCase()).append('\n');
    }

    protected void appendDescriptor(int n2, String string) {
        if (n2 == 5 || n2 == 2 || n2 == 4) {
            if (string != null) {
                this.stringBuilder.append("// signature ").append(string).append('\n');
            }
        } else {
            this.stringBuilder.append(string);
        }
    }

    private void appendJavaDeclaration(String string, String string2) {
        TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(this.access);
        new SignatureReader(string2).accept(traceSignatureVisitor);
        this.stringBuilder.append("// declaration: ");
        if (traceSignatureVisitor.getReturnType() != null) {
            this.stringBuilder.append(traceSignatureVisitor.getReturnType());
            this.stringBuilder.append(' ');
        }
        this.stringBuilder.append(string);
        this.stringBuilder.append(traceSignatureVisitor.getDeclaration());
        if (traceSignatureVisitor.getExceptions() != null) {
            this.stringBuilder.append(" throws ").append(traceSignatureVisitor.getExceptions());
        }
        this.stringBuilder.append('\n');
    }

    protected void appendLabel(Label label) {
        String string;
        if (this.labelNames == null) {
            this.labelNames = new HashMap<Label, String>();
        }
        if ((string = this.labelNames.get(label)) == null) {
            string = "L" + this.labelNames.size();
            this.labelNames.put(label, string);
        }
        this.stringBuilder.append(string);
    }

    protected void appendHandle(Handle handle) {
        int n2 = handle.getTag();
        this.stringBuilder.append("// handle kind 0x").append(Integer.toHexString(n2)).append(" : ");
        boolean bl = false;
        switch (n2) {
            case 1: {
                this.stringBuilder.append("GETFIELD");
                break;
            }
            case 2: {
                this.stringBuilder.append("GETSTATIC");
                break;
            }
            case 3: {
                this.stringBuilder.append("PUTFIELD");
                break;
            }
            case 4: {
                this.stringBuilder.append("PUTSTATIC");
                break;
            }
            case 9: {
                this.stringBuilder.append("INVOKEINTERFACE");
                bl = true;
                break;
            }
            case 7: {
                this.stringBuilder.append("INVOKESPECIAL");
                bl = true;
                break;
            }
            case 6: {
                this.stringBuilder.append("INVOKESTATIC");
                bl = true;
                break;
            }
            case 5: {
                this.stringBuilder.append("INVOKEVIRTUAL");
                bl = true;
                break;
            }
            case 8: {
                this.stringBuilder.append("NEWINVOKESPECIAL");
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.stringBuilder.append('\n');
        this.stringBuilder.append(this.tab3);
        this.appendDescriptor(0, handle.getOwner());
        this.stringBuilder.append('.');
        this.stringBuilder.append(handle.getName());
        if (!bl) {
            this.stringBuilder.append('(');
        }
        this.appendDescriptor(9, handle.getDesc());
        if (!bl) {
            this.stringBuilder.append(')');
        }
        if (handle.isInterface()) {
            this.stringBuilder.append(" itf");
        }
    }

    private void maybeAppendComma(int n2) {
        if (n2 > 0) {
            this.stringBuilder.append(", ");
        }
    }

    private void appendTypeReference(int n2) {
        TypeReference typeReference = new TypeReference(n2);
        switch (typeReference.getSort()) {
            case 0: {
                this.stringBuilder.append("CLASS_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                break;
            }
            case 1: {
                this.stringBuilder.append("METHOD_TYPE_PARAMETER ").append(typeReference.getTypeParameterIndex());
                break;
            }
            case 16: {
                this.stringBuilder.append("CLASS_EXTENDS ").append(typeReference.getSuperTypeIndex());
                break;
            }
            case 17: {
                this.stringBuilder.append("CLASS_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                break;
            }
            case 18: {
                this.stringBuilder.append("METHOD_TYPE_PARAMETER_BOUND ").append(typeReference.getTypeParameterIndex()).append(", ").append(typeReference.getTypeParameterBoundIndex());
                break;
            }
            case 19: {
                this.stringBuilder.append("FIELD");
                break;
            }
            case 20: {
                this.stringBuilder.append("METHOD_RETURN");
                break;
            }
            case 21: {
                this.stringBuilder.append("METHOD_RECEIVER");
                break;
            }
            case 22: {
                this.stringBuilder.append("METHOD_FORMAL_PARAMETER ").append(typeReference.getFormalParameterIndex());
                break;
            }
            case 23: {
                this.stringBuilder.append("THROWS ").append(typeReference.getExceptionIndex());
                break;
            }
            case 64: {
                this.stringBuilder.append("LOCAL_VARIABLE");
                break;
            }
            case 65: {
                this.stringBuilder.append("RESOURCE_VARIABLE");
                break;
            }
            case 66: {
                this.stringBuilder.append("EXCEPTION_PARAMETER ").append(typeReference.getTryCatchBlockIndex());
                break;
            }
            case 67: {
                this.stringBuilder.append("INSTANCEOF");
                break;
            }
            case 68: {
                this.stringBuilder.append("NEW");
                break;
            }
            case 69: {
                this.stringBuilder.append("CONSTRUCTOR_REFERENCE");
                break;
            }
            case 70: {
                this.stringBuilder.append("METHOD_REFERENCE");
                break;
            }
            case 71: {
                this.stringBuilder.append("CAST ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 72: {
                this.stringBuilder.append("CONSTRUCTOR_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 73: {
                this.stringBuilder.append("METHOD_INVOCATION_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 74: {
                this.stringBuilder.append("CONSTRUCTOR_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            case 75: {
                this.stringBuilder.append("METHOD_REFERENCE_TYPE_ARGUMENT ").append(typeReference.getTypeArgumentIndex());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void appendFrameTypes(int n2, Object[] objectArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                this.stringBuilder.append(' ');
            }
            if (objectArray[i2] instanceof String) {
                String string = (String)objectArray[i2];
                if (string.charAt(0) == '[') {
                    this.appendDescriptor(1, string);
                    continue;
                }
                this.appendDescriptor(0, string);
                continue;
            }
            if (objectArray[i2] instanceof Integer) {
                this.stringBuilder.append(FRAME_TYPES.get((Integer)objectArray[i2]));
                continue;
            }
            this.appendLabel((Label)objectArray[i2]);
        }
    }

    private Textifier addNewTextifier(String string) {
        Textifier textifier = this.createTextifier();
        this.text.add(textifier.getText());
        if (string != null) {
            this.text.add(string);
        }
        return textifier;
    }

    protected Textifier createTextifier() {
        return new Textifier(this.api);
    }
}

