/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.dcp;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.dcp.AbstractDCPRequest;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class MutationMessage
extends AbstractDCPRequest {
    private final String key;
    private final ByteBuf content;
    private final int expiration;
    private final int flags;
    private final int lockTime;
    private final long cas;

    public MutationMessage(short partition, String key, ByteBuf content, int expiration, int flags, int lockTime, long cas, String bucket) {
        this(partition, key, content, expiration, flags, lockTime, cas, bucket, null);
    }

    public MutationMessage(short partition, String key, ByteBuf content, int expiration, int flags, int lockTime, long cas, String bucket, String password) {
        super(bucket, password);
        this.partition(partition);
        this.key = key;
        this.content = content;
        this.expiration = expiration;
        this.flags = flags;
        this.lockTime = lockTime;
        this.cas = cas;
    }

    public String key() {
        return this.key;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int expiration() {
        return this.expiration;
    }

    public int lockTime() {
        return this.lockTime;
    }

    public int flags() {
        return this.flags;
    }

    public long cas() {
        return this.cas;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MutationMessage{");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", content=").append(this.content);
        sb.append(", expiration=").append(this.expiration);
        sb.append(", flags=").append(this.flags);
        sb.append(", lockTime=").append(this.lockTime);
        sb.append(", cas=").append(this.cas);
        sb.append('}');
        return sb.toString();
    }
}

