/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.time;

import com.couchbase.client.core.time.Delay;
import java.util.concurrent.TimeUnit;

public class ExponentialDelay
extends Delay {
    private final long lower;
    private final long upper;
    private final double growBy;

    ExponentialDelay(TimeUnit unit, long upper, long lower, double growBy) {
        super(unit);
        this.lower = lower;
        this.upper = upper;
        this.growBy = growBy;
    }

    @Override
    public long calculate(long attempt) {
        long calc = Math.round((double)(1 << (int)(attempt - 1L)) * this.growBy);
        if (calc < this.lower) {
            return this.lower;
        }
        if (calc > this.upper) {
            return this.upper;
        }
        return calc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ExponentialDelay{");
        sb.append("growBy ").append(this.growBy);
        sb.append(" " + (Object)((Object)this.unit()));
        sb.append("; lower=").append(this.lower);
        sb.append(", upper=").append(this.upper);
        sb.append('}');
        return sb.toString();
    }
}

