/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.kv.KeyValueAuthHandler;
import com.couchbase.client.core.endpoint.kv.KeyValueErrorMapHandler;
import com.couchbase.client.core.endpoint.kv.KeyValueFeatureHandler;
import com.couchbase.client.core.endpoint.kv.KeyValueHandler;
import com.couchbase.client.core.endpoint.kv.KeyValueSelectBucketHandler;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheClientCodec;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheObjectAggregator;
import com.couchbase.client.deps.io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public class KeyValueEndpoint
extends AbstractEndpoint {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueEndpoint.class);

    @Deprecated
    public KeyValueEndpoint(String hostname, String bucket, String password, int port, CoreContext ctx) {
        this(hostname, bucket, bucket, password, port, ctx);
    }

    public KeyValueEndpoint(String hostname, String bucket, String username, String password, int port, CoreContext ctx) {
        super(hostname, bucket, username, password, port, ctx, false, ctx.environment().kvIoPool() == null ? ctx.environment().ioPool() : ctx.environment().kvIoPool(), true);
    }

    @Override
    protected void customEndpointHandlers(ChannelPipeline pipeline) {
        if (this.environment().keepAliveInterval() > 0L) {
            pipeline.addLast(new IdleStateHandler(this.environment().keepAliveInterval(), 0L, 0L, TimeUnit.MILLISECONDS));
        }
        boolean authBeforeHello = Boolean.parseBoolean(System.getProperty("com.couchbase.authBeforeHello", "false"));
        pipeline.addLast(new BinaryMemcacheClientCodec()).addLast(new BinaryMemcacheObjectAggregator(Integer.MAX_VALUE));
        if (authBeforeHello) {
            LOGGER.info("Manually enforced authentication before \"HELLO\" for backwards compatibility.");
            if (!this.environment().certAuthEnabled()) {
                pipeline.addLast(new KeyValueAuthHandler(this.username(), this.password(), this.environment().forceSaslPlain()));
            }
            pipeline.addLast(new KeyValueFeatureHandler(this.context())).addLast(new KeyValueErrorMapHandler());
        } else {
            pipeline.addLast(new KeyValueFeatureHandler(this.context())).addLast(new KeyValueErrorMapHandler());
            if (!this.environment().certAuthEnabled()) {
                pipeline.addLast(new KeyValueAuthHandler(this.username(), this.password(), this.environment().forceSaslPlain()));
            }
        }
        pipeline.addLast(new KeyValueSelectBucketHandler(this.bucket())).addLast(new KeyValueHandler(this, this.responseBuffer(), false, true));
    }
}

