/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.view;

import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.view.ViewRequest;
import io.opentracing.Span;
import io.opentracing.tag.Tags;

public class ViewQueryRequest
extends AbstractCouchbaseRequest
implements ViewRequest {
    private final String design;
    private final String view;
    private final String query;
    private final String keysJson;
    private final boolean spatial;
    private final boolean development;

    public ViewQueryRequest(String design, String view, boolean development, String query, String keys, String bucket, String password) {
        this(design, view, development, false, query, keys, bucket, bucket, password);
    }

    public ViewQueryRequest(String design, String view, boolean development, String query, String keys, String bucket, String username, String password) {
        this(design, view, development, false, query, keys, bucket, username, password);
    }

    public ViewQueryRequest(String design, String view, boolean development, boolean spatial, String query, String keys, String bucket, String password) {
        this(design, view, development, spatial, query, keys, bucket, bucket, password);
    }

    public ViewQueryRequest(String design, String view, boolean development, boolean spatial, String query, String keys, String bucket, String username, String password) {
        super(bucket, username, password);
        this.design = design;
        this.view = view;
        this.query = query;
        this.keysJson = keys;
        this.development = development;
        this.spatial = spatial;
    }

    @Override
    protected void afterSpanSet(Span span) {
        span.setTag(Tags.PEER_SERVICE.getKey(), "view");
    }

    public String design() {
        return this.design;
    }

    public String view() {
        return this.view;
    }

    public String query() {
        return this.query;
    }

    public String keys() {
        return this.keysJson;
    }

    public boolean development() {
        return this.development;
    }

    public boolean spatial() {
        return this.spatial;
    }
}

