/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.tracing;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.tracing.ThresholdLogSpanContext;
import com.couchbase.client.core.tracing.ThresholdLogTracer;
import io.opentracing.Span;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ThresholdLogSpan
implements Span,
Comparable<ThresholdLogSpan> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ThresholdLogSpan.class);
    private final ThresholdLogTracer tracer;
    private final Map<String, Object> tags;
    private final ThresholdLogSpanContext context;
    private final long startTimeMicroseconds;
    private long endTimeMicroseconds;
    private String operationName;
    private boolean finished;
    private volatile CouchbaseRequest request;

    ThresholdLogSpan(ThresholdLogTracer tracer, ThresholdLogSpanContext context, String operationName, Map<String, Object> tags, long startTimeMicroseconds) {
        this.context = context;
        this.tracer = tracer;
        this.operationName = operationName;
        this.tags = tags;
        this.startTimeMicroseconds = startTimeMicroseconds;
        this.finished = false;
    }

    public ThresholdLogSpanContext context() {
        return this.context;
    }

    public synchronized ThresholdLogSpan setTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public synchronized ThresholdLogSpan setTag(String key, boolean value) {
        this.tags.put(key, value);
        return this;
    }

    public synchronized ThresholdLogSpan setTag(String key, Number value) {
        this.tags.put(key, value);
        return this;
    }

    public ThresholdLogSpan log(Map<String, ?> fields) {
        return this;
    }

    public ThresholdLogSpan log(String event) {
        return this;
    }

    public ThresholdLogSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        return this;
    }

    public ThresholdLogSpan log(long timestampMicroseconds, String event) {
        return this;
    }

    public ThresholdLogSpan setBaggageItem(String key, String value) {
        this.context.baggageItem(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.context.baggageItem(key);
    }

    public synchronized ThresholdLogSpan setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    @Override
    public int compareTo(ThresholdLogSpan o) {
        return Long.valueOf(this.durationMicros()).compareTo(o.durationMicros());
    }

    public void finish() {
        this.finish(TimeUnit.NANOSECONDS.toMicros(System.nanoTime()));
    }

    public synchronized long durationMicros() {
        return this.endTimeMicroseconds - this.startTimeMicroseconds;
    }

    public synchronized String operationName() {
        return this.operationName;
    }

    public Map<String, Object> tags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public synchronized Object tag(String key) {
        return this.tags.get(key);
    }

    public CouchbaseRequest request() {
        return this.request;
    }

    public void request(CouchbaseRequest request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(long finishMicros) {
        ThresholdLogSpan thresholdLogSpan = this;
        synchronized (thresholdLogSpan) {
            if (this.finished) {
                return;
            }
            this.endTimeMicroseconds = finishMicros;
            this.finished = true;
        }
        this.tracer.reportSpan(this);
    }

    public String toString() {
        return "ThresholdLogSpan{, tags=" + this.tags + ", context=" + this.context + ", startTimeMicroseconds=" + this.startTimeMicroseconds + ", endTimeMicroseconds=" + this.endTimeMicroseconds + ", operationName='" + this.operationName + '\'' + ", finished=" + this.finished + '}';
    }
}

