/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.handler.codec.memcache.binary;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.DecoderResult;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.AbstractMemcacheObjectDecoder;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.DefaultLastMemcacheContent;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.DefaultMemcacheContent;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.LastMemcacheContent;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.MemcacheContent;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;
import java.util.List;

public abstract class AbstractBinaryMemcacheDecoder<M extends BinaryMemcacheMessage>
extends AbstractMemcacheObjectDecoder {
    public static final int DEFAULT_MAX_CHUNK_SIZE = 8192;
    private final int chunkSize;
    private M currentMessage;
    private int alreadyReadChunkSize;
    private State state = State.READ_HEADER;

    protected AbstractBinaryMemcacheDecoder() {
        this(8192);
    }

    protected AbstractBinaryMemcacheDecoder(int chunkSize) {
        if (chunkSize < 0) {
            throw new IllegalArgumentException("chunkSize must be a positive integer: " + chunkSize);
        }
        this.chunkSize = chunkSize;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        switch (this.state) {
            case READ_HEADER: {
                try {
                    if (in.readableBytes() < 24) {
                        return;
                    }
                    this.resetDecoder();
                    this.currentMessage = this.decodeHeader(in);
                    this.state = State.READ_FRAMING;
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(e));
                    return;
                }
            }
            case READ_FRAMING: {
                try {
                    byte framingLength = this.currentMessage.getFramingExtrasLength();
                    if (framingLength > 0) {
                        if (in.readableBytes() < framingLength) {
                            return;
                        }
                        this.currentMessage.setFramingExtras(ByteBufUtil.readBytes(ctx.alloc(), in, framingLength));
                    }
                    this.state = State.READ_EXTRAS;
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(e));
                    return;
                }
            }
            case READ_EXTRAS: {
                try {
                    byte extrasLength = this.currentMessage.getExtrasLength();
                    if (extrasLength > 0) {
                        if (in.readableBytes() < extrasLength) {
                            return;
                        }
                        this.currentMessage.setExtras(ByteBufUtil.readBytes(ctx.alloc(), in, extrasLength));
                    }
                    this.state = State.READ_KEY;
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(e));
                    return;
                }
            }
            case READ_KEY: {
                try {
                    short keyLength = this.currentMessage.getKeyLength();
                    if (keyLength > 0) {
                        if (in.readableBytes() < keyLength) {
                            return;
                        }
                        byte[] key = new byte[keyLength];
                        in.readBytes(key);
                        this.currentMessage.setKey(key);
                    }
                    out.add(this.currentMessage);
                    this.state = State.READ_CONTENT;
                }
                catch (Exception e) {
                    out.add(this.invalidMessage(e));
                    return;
                }
            }
            case READ_CONTENT: {
                try {
                    int valueLength = this.currentMessage.getTotalBodyLength() - this.currentMessage.getKeyLength() - this.currentMessage.getExtrasLength() - this.currentMessage.getFramingExtrasLength();
                    int toRead = in.readableBytes();
                    if (valueLength > 0) {
                        int remainingLength;
                        if (toRead == 0) {
                            return;
                        }
                        if (toRead > this.chunkSize) {
                            toRead = this.chunkSize;
                        }
                        if (toRead > (remainingLength = valueLength - this.alreadyReadChunkSize)) {
                            toRead = remainingLength;
                        }
                        ByteBuf chunkBuffer = ByteBufUtil.readBytes(ctx.alloc(), in, toRead);
                        DefaultMemcacheContent chunk = (this.alreadyReadChunkSize += toRead) >= valueLength ? new DefaultLastMemcacheContent(chunkBuffer) : new DefaultMemcacheContent(chunkBuffer);
                        out.add(chunk);
                        if (this.alreadyReadChunkSize < valueLength) {
                            return;
                        }
                    } else {
                        out.add(LastMemcacheContent.EMPTY_LAST_CONTENT);
                    }
                    this.state = State.READ_HEADER;
                    return;
                }
                catch (Exception e) {
                    out.add(this.invalidChunk(e));
                    return;
                }
            }
            case BAD_MESSAGE: {
                in.skipBytes(this.actualReadableBytes());
                return;
            }
        }
        throw new Error("Unknown state reached: " + (Object)((Object)this.state));
    }

    private M invalidMessage(Exception cause) {
        this.state = State.BAD_MESSAGE;
        M message = this.buildInvalidMessage();
        message.setDecoderResult(DecoderResult.failure(cause));
        return message;
    }

    private MemcacheContent invalidChunk(Exception cause) {
        this.state = State.BAD_MESSAGE;
        DefaultLastMemcacheContent chunk = new DefaultLastMemcacheContent(Unpooled.EMPTY_BUFFER);
        chunk.setDecoderResult(DecoderResult.failure(cause));
        return chunk;
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        if (this.currentMessage != null && this.currentMessage.getExtras() != null && this.currentMessage.getExtras().refCnt() > 0) {
            this.currentMessage.getExtras().release();
        }
        if (this.currentMessage != null && this.currentMessage.getFramingExtras() != null && this.currentMessage.getFramingExtras().refCnt() > 0) {
            this.currentMessage.getFramingExtras().release();
        }
        this.resetDecoder();
    }

    protected void resetDecoder() {
        this.currentMessage = null;
        this.alreadyReadChunkSize = 0;
    }

    protected abstract M decodeHeader(ByteBuf var1);

    protected abstract M buildInvalidMessage();

    static enum State {
        READ_HEADER,
        READ_FRAMING,
        READ_EXTRAS,
        READ_KEY,
        READ_CONTENT,
        BAD_MESSAGE;

    }
}

