/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.core;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.SeedNode;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CoreCreatedEvent
extends AbstractEvent {
    private final CoreEnvironment environment;

    public CoreCreatedEvent(CoreContext context, CoreEnvironment environment, Set<SeedNode> seedNodes) {
        super(Event.Severity.INFO, Event.Category.CORE, Duration.ZERO, CoreCreatedEvent.attachSeedNodes(context, seedNodes));
        this.environment = environment;
    }

    private static Context attachSeedNodes(CoreContext context, final Set<SeedNode> seedNodes) {
        return new CoreContext(context.core(), context.id(), context.environment(), context.authenticator()){

            @Override
            public void injectExportableParams(Map<String, Object> input) {
                super.injectExportableParams(input);
                input.put("seedNodes", seedNodes.stream().map(seedNode -> {
                    HashMap<String, String> mapped = new HashMap<String, String>();
                    mapped.put("address", seedNode.address());
                    seedNode.kvPort().ifPresent(p -> mapped.put("kvPort", (String)p));
                    seedNode.clusterManagerPort().ifPresent(p -> mapped.put("mgmtPort", (String)p));
                    return mapped;
                }).collect(Collectors.toSet()));
            }
        };
    }

    @Override
    public String description() {
        return this.environment.exportAsString(Context.ExportFormat.JSON);
    }
}

