/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.refresher;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.config.ConfigurationProvider;
import com.couchbase.client.core.config.GlobalConfig;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.config.ProposedGlobalConfigContext;
import com.couchbase.client.core.config.refresher.KeyValueBucketRefresher;
import com.couchbase.client.core.msg.kv.CarrierGlobalConfigRequest;
import com.couchbase.client.core.retry.FailFastRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

public class GlobalRefresher {
    private final ConfigurationProvider provider;
    private final Core core;
    private final long configPollIntervalNanos;
    private final Duration configRequestTimeout;
    private volatile boolean started;
    private final Disposable pollRegistration;
    private final AtomicLong nodeOffset = new AtomicLong(0L);

    public GlobalRefresher(ConfigurationProvider provider, Core core) {
        this.provider = provider;
        this.core = core;
        this.configPollIntervalNanos = core.context().environment().ioConfig().configPollInterval().toNanos();
        this.configRequestTimeout = KeyValueBucketRefresher.clampConfigRequestTimeout(this.configPollIntervalNanos);
        this.started = false;
        this.pollRegistration = Flux.interval((Duration)KeyValueBucketRefresher.POLLER_INTERVAL, (Scheduler)core.context().environment().scheduler()).filter(v -> this.started).flatMap(ign -> this.attemptUpdateGlobalConfig(this.filterEligibleNodes())).subscribe(provider::proposeGlobalConfig);
    }

    private Flux<ProposedGlobalConfigContext> attemptUpdateGlobalConfig(Flux<PortInfo> nodes) {
        return nodes.flatMap(nodeInfo -> {
            CoreContext ctx = this.core.context();
            CarrierGlobalConfigRequest request = new CarrierGlobalConfigRequest(this.configRequestTimeout, ctx, (RetryStrategy)FailFastRetryStrategy.INSTANCE, nodeInfo.identifier());
            this.core.send(request);
            return Reactor.wrap(request, request.response(), true).filter(response -> response.status().success()).map(response -> new ProposedGlobalConfigContext(new String(response.content(), StandardCharsets.UTF_8), nodeInfo.hostname())).onErrorResume(t -> Mono.empty());
        });
    }

    private Flux<PortInfo> filterEligibleNodes() {
        return Flux.defer(() -> {
            GlobalConfig config = this.provider.config().globalConfig();
            if (config == null) {
                return Flux.empty();
            }
            ArrayList<PortInfo> nodes = new ArrayList<PortInfo>(config.portInfos());
            this.shiftNodeList(nodes);
            return Flux.fromIterable(nodes).filter(n -> n.ports().containsKey((Object)ServiceType.KV) || n.sslPorts().containsKey((Object)ServiceType.KV)).take(3L);
        });
    }

    private <T> void shiftNodeList(List<T> nodeList) {
        int shiftBy = (int)(this.nodeOffset.getAndIncrement() % (long)nodeList.size());
        for (int i = 0; i < shiftBy; ++i) {
            T element = nodeList.remove(0);
            nodeList.add(element);
        }
    }

    public Mono<Void> start() {
        return Mono.defer(() -> {
            this.started = true;
            return Mono.empty();
        });
    }

    public Mono<Void> stop() {
        return Mono.defer(() -> {
            this.started = false;
            return Mono.empty();
        });
    }

    public Mono<Void> shutdown() {
        return this.stop().then(Mono.defer(() -> {
            if (!this.pollRegistration.isDisposed()) {
                this.pollRegistration.dispose();
            }
            return Mono.empty();
        }));
    }
}

