/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.jctools.queues;

import com.couchbase.client.core.deps.org.jctools.queues.MpUnboundedXaddChunk;
import com.couchbase.client.core.deps.org.jctools.util.UnsafeLongArrayAccess;
import java.util.Arrays;

final class MpmcUnboundedXaddChunk<E>
extends MpUnboundedXaddChunk<MpmcUnboundedXaddChunk<E>, E> {
    private final long[] sequence;

    MpmcUnboundedXaddChunk(long index, MpmcUnboundedXaddChunk<E> prev, int size, boolean pooled) {
        super(index, prev, size, pooled);
        if (pooled) {
            this.sequence = UnsafeLongArrayAccess.allocateLongArray(size);
            Arrays.fill(this.sequence, -1L);
        } else {
            this.sequence = null;
        }
    }

    void soSequence(int index, long e) {
        assert (this.isPooled());
        UnsafeLongArrayAccess.soLongElement(this.sequence, UnsafeLongArrayAccess.calcLongElementOffset(index), e);
    }

    long lvSequence(int index) {
        assert (this.isPooled());
        return UnsafeLongArrayAccess.lvLongElement(this.sequence, UnsafeLongArrayAccess.calcLongElementOffset(index));
    }

    void spinForSequence(int index, long e) {
        assert (this.isPooled());
        long[] sequence = this.sequence;
        long offset = UnsafeLongArrayAccess.calcLongElementOffset(index);
        while (UnsafeLongArrayAccess.lvLongElement(sequence, offset) != e) {
        }
    }
}

