/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error.context;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.msg.RequestContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Stability.Uncommitted
public class AnalyticsErrorContext
extends ErrorContext {
    private final RequestContext requestContext;
    private final List<ErrorCodeAndMessage> errors;

    public AnalyticsErrorContext(RequestContext requestContext, List<ErrorCodeAndMessage> errors) {
        super(null);
        this.errors = errors;
        this.requestContext = requestContext;
    }

    public RequestContext requestContext() {
        return this.requestContext;
    }

    public List<ErrorCodeAndMessage> errors() {
        return this.errors;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        if (this.requestContext != null) {
            this.requestContext.injectExportableParams(input);
        }
        ArrayList errorList = new ArrayList(this.errors.size());
        for (ErrorCodeAndMessage error : this.errors) {
            TreeMap<String, Object> err = new TreeMap<String, Object>();
            err.put("code", error.code());
            err.put("message", error.message());
            if (error.context() != null && !error.context().isEmpty()) {
                err.put("additional", error.context());
            }
            errorList.add(err);
        }
        input.put("errors", errorList);
    }
}

