/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io;

import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.util.UnsignedLEB128;
import java.util.concurrent.ConcurrentHashMap;

public class CollectionMap {
    private final ConcurrentHashMap<CollectionIdentifier, byte[]> inner = new ConcurrentHashMap();
    private static final byte[] DEFAULT_ID = UnsignedLEB128.encode(0L);

    public byte[] get(CollectionIdentifier key) {
        if (key.isDefault()) {
            return DEFAULT_ID;
        }
        return this.inner.get(key);
    }

    public void put(CollectionIdentifier key, byte[] value) {
        this.inner.put(key, value);
    }

    public boolean hasBucketMap(String bucket) {
        for (CollectionIdentifier identifier : this.inner.keySet()) {
            if (!bucket.equals(identifier.bucket())) continue;
            return true;
        }
        return false;
    }
}

