/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry.reactor;

import com.couchbase.client.core.retry.reactor.Backoff;
import com.couchbase.client.core.retry.reactor.BackoffDelay;
import com.couchbase.client.core.retry.reactor.IterationContext;
import com.couchbase.client.core.retry.reactor.Jitter;
import com.couchbase.client.core.scheduler.SchedulerClock;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.annotation.Nullable;

public abstract class AbstractRetry<T, S>
implements Function<Flux<S>, Publisher<Long>> {
    static final BackoffDelay RETRY_EXHAUSTED = new BackoffDelay(Duration.ofSeconds(-1L)){

        @Override
        public String toString() {
            return "{EXHAUSTED}";
        }
    };
    final long maxIterations;
    final Duration timeout;
    final Backoff backoff;
    final Jitter jitter;
    @Nullable
    final Scheduler backoffScheduler;
    final SchedulerClock clock;
    final T applicationContext;

    AbstractRetry(long maxIterations, Duration timeout, Backoff backoff, Jitter jitter, @Nullable Scheduler backoffScheduler, T applicationContext) {
        this.maxIterations = maxIterations;
        this.timeout = timeout;
        this.backoff = backoff;
        this.jitter = jitter;
        this.backoffScheduler = backoffScheduler;
        this.clock = SchedulerClock.of(backoffScheduler == null ? Schedulers.parallel() : backoffScheduler);
        this.applicationContext = applicationContext;
    }

    Instant calculateTimeout() {
        return this.timeout != null ? Instant.now(this.clock).plus(this.timeout) : Instant.MAX;
    }

    BackoffDelay calculateBackoff(IterationContext<T> retryContext, Instant timeoutInstant) {
        if (retryContext.iteration() > this.maxIterations) {
            return RETRY_EXHAUSTED;
        }
        BackoffDelay nextBackoff = (BackoffDelay)this.backoff.apply(retryContext);
        Duration minBackoff = nextBackoff.min;
        Duration maxBackoff = nextBackoff.max;
        Duration backoff = nextBackoff.delay;
        if (maxBackoff != null) {
            Duration duration = backoff = backoff.compareTo(maxBackoff) < 0 ? backoff : maxBackoff;
        }
        if (minBackoff != null) {
            backoff = backoff.compareTo(minBackoff) > 0 ? backoff : minBackoff;
        }
        BackoffDelay sanitizedBackoff = new BackoffDelay(minBackoff, maxBackoff, backoff);
        Duration jitteredBackoff = (Duration)this.jitter.apply(sanitizedBackoff);
        if (Instant.now(this.clock).plus(jitteredBackoff).isAfter(timeoutInstant)) {
            return RETRY_EXHAUSTED;
        }
        return new BackoffDelay(minBackoff, maxBackoff, jitteredBackoff);
    }

    Publisher<Long> retryMono(Duration delay) {
        if (delay == Duration.ZERO) {
            return Mono.just((Object)0L);
        }
        if (this.backoffScheduler == null) {
            return Mono.delay((Duration)delay);
        }
        return Mono.delay((Duration)delay, (Scheduler)this.backoffScheduler);
    }
}

