/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.spark.japi;

import com.couchbase.client.java.document.Document;
import com.couchbase.spark.DocumentRDDFunctions;
import com.couchbase.spark.StoreMode;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import scala.reflect.ClassTag;

public class CouchbaseDocumentRDD<T extends Document<?>>
extends JavaRDD<T> {
    private final JavaRDD<T> source;

    protected CouchbaseDocumentRDD(JavaRDD<T> javaRDD) {
        super(javaRDD.rdd(), javaRDD.classTag());
        this.source = javaRDD;
    }

    public static <T extends Document<?>> CouchbaseDocumentRDD<T> couchbaseDocumentRDD(RDD<T> rDD) {
        return CouchbaseDocumentRDD.couchbaseDocumentRDD(rDD.toJavaRDD());
    }

    public static <T extends Document<?>> CouchbaseDocumentRDD<T> couchbaseDocumentRDD(JavaRDD<T> javaRDD) {
        return new CouchbaseDocumentRDD<T>(javaRDD);
    }

    public void saveToCouchbase() {
        this.saveToCouchbase(StoreMode.UPSERT, null);
    }

    public void saveToCouchbase(StoreMode storeMode) {
        this.saveToCouchbase(storeMode, null);
    }

    public void saveToCouchbase(String string) {
        this.saveToCouchbase(StoreMode.UPSERT, string);
    }

    public void saveToCouchbase(StoreMode storeMode, String string) {
        new DocumentRDDFunctions(this.source.rdd()).saveToCouchbase(string, storeMode);
    }

    public RDD<T> rdd() {
        return this.source.rdd();
    }

    public ClassTag<T> classTag() {
        return this.source.classTag();
    }
}

