/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.spark.japi;

import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.spark.RDDFunctions;
import com.couchbase.spark.japi.SparkUtil;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import scala.Predef;
import scala.reflect.ClassTag;

public class CouchbaseRDD<T>
extends JavaRDD<T> {
    private final JavaRDD<T> source;

    private CouchbaseRDD(JavaRDD<T> javaRDD, ClassTag<T> classTag) {
        super(javaRDD.rdd(), classTag);
        this.source = javaRDD;
    }

    public static <T> CouchbaseRDD<T> couchbaseRDD(RDD<T> rDD) {
        return CouchbaseRDD.couchbaseRDD(rDD.toJavaRDD());
    }

    public static <T> CouchbaseRDD<T> couchbaseRDD(JavaRDD<T> javaRDD) {
        return new CouchbaseRDD<T>(javaRDD, javaRDD.classTag());
    }

    public JavaRDD<JsonDocument> couchbaseGet() {
        return this.couchbaseGet(null, JsonDocument.class);
    }

    public JavaRDD<JsonDocument> couchbaseGet(String string) {
        return this.couchbaseGet(string, JsonDocument.class);
    }

    public <D extends Document> JavaRDD<D> couchbaseGet(Class<D> clazz) {
        return this.couchbaseGet(null, clazz);
    }

    public <D extends Document> JavaRDD<D> couchbaseGet(String string, Class<D> clazz) {
        return new RDDFunctions(this.source.rdd()).couchbaseGet(string, SparkUtil.classTag(clazz), LCLIdentity.INSTANCE).toJavaRDD();
    }

    public RDD<T> rdd() {
        return this.source.rdd();
    }

    public ClassTag<T> classTag() {
        return this.source.classTag();
    }

    private static class LCLIdentity
    extends Predef.$less$colon$less {
        public static LCLIdentity INSTANCE = new LCLIdentity();

        private LCLIdentity() {
        }

        public Object apply(Object object) {
            return object;
        }
    }
}

