/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.spark.japi;

import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.spark.japi.SparkUtil;
import com.couchbase.spark.rdd.CouchbaseQueryRow;
import com.couchbase.spark.rdd.CouchbaseSpatialViewRow;
import com.couchbase.spark.rdd.CouchbaseViewRow;
import com.couchbase.spark.rdd.KeyValueRDD;
import com.couchbase.spark.rdd.QueryRDD;
import com.couchbase.spark.rdd.SpatialViewRDD;
import com.couchbase.spark.rdd.ViewRDD;
import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;

public class CouchbaseSparkContext {
    private final SparkContext sc;

    protected CouchbaseSparkContext(SparkContext sparkContext) {
        this.sc = sparkContext;
    }

    public static CouchbaseSparkContext couchbaseContext(SparkContext sparkContext) {
        return new CouchbaseSparkContext(sparkContext);
    }

    public static CouchbaseSparkContext couchbaseContext(JavaSparkContext javaSparkContext) {
        return new CouchbaseSparkContext(javaSparkContext.sc());
    }

    public JavaRDD<JsonDocument> couchbaseGet(List<String> list, String string) {
        return this.couchbaseGet(list, string, JsonDocument.class);
    }

    public JavaRDD<JsonDocument> couchbaseGet(List<String> list) {
        return this.couchbaseGet(list, null, JsonDocument.class);
    }

    public <D extends Document> JavaRDD<D> couchbaseGet(List<String> list, Class<D> clazz) {
        return this.couchbaseGet(list, null, clazz);
    }

    public <D extends Document> JavaRDD<D> couchbaseGet(List<String> list, String string, Class<D> clazz) {
        return new KeyValueRDD<D>(this.sc, SparkUtil.listToSeq(list), string, SparkUtil.classTag(clazz)).toJavaRDD();
    }

    public JavaRDD<CouchbaseViewRow> couchbaseView(ViewQuery viewQuery) {
        return this.couchbaseView(viewQuery, null);
    }

    public JavaRDD<CouchbaseViewRow> couchbaseView(ViewQuery viewQuery, String string) {
        return new ViewRDD(this.sc, viewQuery, string).toJavaRDD();
    }

    public JavaRDD<CouchbaseSpatialViewRow> couchbaseSpatialView(SpatialViewQuery spatialViewQuery) {
        return this.couchbaseSpatialView(spatialViewQuery, null);
    }

    public JavaRDD<CouchbaseSpatialViewRow> couchbaseSpatialView(SpatialViewQuery spatialViewQuery, String string) {
        return new SpatialViewRDD(this.sc, spatialViewQuery, string).toJavaRDD();
    }

    public JavaRDD<CouchbaseQueryRow> couchbaseQuery(N1qlQuery n1qlQuery) {
        return this.couchbaseQuery(n1qlQuery, null);
    }

    public JavaRDD<CouchbaseQueryRow> couchbaseQuery(N1qlQuery n1qlQuery, String string) {
        return new QueryRDD(this.sc, n1qlQuery, string).toJavaRDD();
    }
}

