/*
 * Decompiled with CFR 0.152.
 */
package com.coveo.saml;

import com.coveo.saml.BrowserUtils;
import com.coveo.saml.SamlException;
import com.coveo.saml.SamlLogoutResponse;
import com.coveo.saml.SamlResponse;
import com.coveo.saml.ValidatorUtils;
import com.coveo.saml.XMLHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.impl.XSAnyImpl;
import org.opensaml.core.xml.schema.impl.XSStringImpl;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusMessage;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml.saml2.core.impl.StatusMessageBuilder;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.encryption.support.InlineEncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.ChainingKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.CollectionKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.impl.SignatureBuilder;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlClient {
    private static final Logger logger = LoggerFactory.getLogger(SamlClient.class);
    private static final String HTTP_REQ_SAML_PARAM = "SAMLRequest";
    private static final String HTTP_RESP_SAML_PARAM = "SAMLResponse";
    private static boolean initializedOpenSaml = false;
    private BasicParserPool domParser;
    private String relyingPartyIdentifier;
    private String assertionConsumerServiceUrl;
    private String identityProviderUrl;
    private String responseIssuer;
    private List<Credential> credentials;
    private Instant now;
    private long notBeforeSkew = 0L;
    private SamlIdpBinding samlBinding;
    private BasicX509Credential spCredential;
    private List<Credential> additionalSpCredentials = new ArrayList<Credential>();

    public String getIdentityProviderUrl() {
        return this.identityProviderUrl;
    }

    public void setInstantNow(Instant now) {
        this.now = now;
    }

    public void setNotBeforeSkew(long notBeforeSkew) {
        if (notBeforeSkew < 0L) {
            throw new IllegalArgumentException("Skew must be non-negative");
        }
        this.notBeforeSkew = notBeforeSkew;
    }

    public SamlClient(String relyingPartyIdentifier, String assertionConsumerServiceUrl, String identityProviderUrl, String responseIssuer, List<X509Certificate> certificates, SamlIdpBinding samlBinding) throws SamlException {
        SamlClient.ensureOpenSamlIsInitialized();
        if (relyingPartyIdentifier == null) {
            throw new IllegalArgumentException("relyingPartyIdentifier");
        }
        if (identityProviderUrl == null) {
            throw new IllegalArgumentException("identityProviderUrl");
        }
        if (responseIssuer == null) {
            throw new IllegalArgumentException("responseIssuer");
        }
        if (certificates == null || certificates.isEmpty()) {
            throw new IllegalArgumentException("certificates");
        }
        this.relyingPartyIdentifier = relyingPartyIdentifier;
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        this.identityProviderUrl = identityProviderUrl;
        this.responseIssuer = responseIssuer;
        this.credentials = certificates.stream().map(SamlClient::getCredential).collect(Collectors.toList());
        this.samlBinding = samlBinding;
        this.domParser = SamlClient.createDOMParser();
    }

    public SamlClient(String relyingPartyIdentifier, String assertionConsumerServiceUrl, String identityProviderUrl, String responseIssuer, List<X509Certificate> certificates) throws SamlException {
        this(relyingPartyIdentifier, assertionConsumerServiceUrl, identityProviderUrl, responseIssuer, certificates, SamlIdpBinding.POST);
    }

    public SamlClient(String relyingPartyIdentifier, String assertionConsumerServiceUrl, String identityProviderUrl, String responseIssuer, X509Certificate certificate) throws SamlException {
        this(relyingPartyIdentifier, assertionConsumerServiceUrl, identityProviderUrl, responseIssuer, Collections.singletonList(certificate), SamlIdpBinding.POST);
    }

    public SamlResponse decodeAndValidateSamlResponse(String encodedResponse, String method) throws SamlException {
        Response response = (Response)this.parseResponse(encodedResponse, method);
        try {
            this.decodeEncryptedAssertion(response);
        }
        catch (DecryptionException e) {
            throw new SamlException("Cannot decrypt the assertion", e);
        }
        ValidatorUtils.validate(response, this.responseIssuer, this.credentials, this.now, this.notBeforeSkew);
        Assertion assertion = (Assertion)response.getAssertions().get(0);
        return new SamlResponse(assertion);
    }

    public void redirectToIdentityProvider(HttpServletResponse response, String relayState) throws IOException, SamlException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(HTTP_REQ_SAML_PARAM, this.getSamlRequest());
        if (relayState != null) {
            values.put("RelayState", relayState);
        }
        BrowserUtils.postUsingBrowser(this.identityProviderUrl, response, values);
    }

    public SamlResponse processPostFromIdentityProvider(HttpServletRequest request) throws SamlException {
        String encodedResponse = request.getParameter(HTTP_RESP_SAML_PARAM);
        return this.decodeAndValidateSamlResponse(encodedResponse, request.getMethod());
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata) throws SamlException {
        return SamlClient.fromMetadata(relyingPartyIdentifier, assertionConsumerServiceUrl, metadata, SamlIdpBinding.POST);
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata, SamlIdpBinding samlBinding) throws SamlException {
        return SamlClient.fromMetadata(relyingPartyIdentifier, assertionConsumerServiceUrl, metadata, samlBinding, null);
    }

    public static SamlClient fromMetadata(String relyingPartyIdentifier, String assertionConsumerServiceUrl, Reader metadata, SamlIdpBinding samlBinding, List<X509Certificate> certificates) throws SamlException {
        SamlClient.ensureOpenSamlIsInitialized();
        DOMMetadataResolver metadataResolver = SamlClient.createMetadataResolver(SamlClient.skipBom(metadata));
        EntityDescriptor entityDescriptor = SamlClient.getEntityDescriptor(metadataResolver);
        IDPSSODescriptor idpSsoDescriptor = SamlClient.getIDPSSODescriptor(entityDescriptor);
        SingleSignOnService idpBinding = null;
        if (idpSsoDescriptor.getSingleSignOnServices() != null && !idpSsoDescriptor.getSingleSignOnServices().isEmpty()) {
            idpBinding = SamlClient.getIdpBinding(idpSsoDescriptor, samlBinding);
        }
        List<X509Certificate> x509Certificates = SamlClient.getCertificates(idpSsoDescriptor);
        boolean isOkta = entityDescriptor.getEntityID().contains(".okta.com");
        if (relyingPartyIdentifier == null) {
            if (isOkta) {
                relyingPartyIdentifier = entityDescriptor.getEntityID();
            } else {
                throw new IllegalArgumentException("relyingPartyIdentifier");
            }
        }
        if (idpBinding != null && assertionConsumerServiceUrl == null && isOkta) {
            assertionConsumerServiceUrl = idpBinding.getLocation();
        }
        if (certificates != null) {
            x509Certificates.addAll(certificates);
        }
        String identityProviderUrl = idpBinding != null ? idpBinding.getLocation() : assertionConsumerServiceUrl;
        String responseIssuer = entityDescriptor.getEntityID();
        return new SamlClient(relyingPartyIdentifier, assertionConsumerServiceUrl, identityProviderUrl, responseIssuer, x509Certificates, samlBinding);
    }

    private static InputStream skipBom(Reader metadata) throws SamlException {
        try {
            InputStream metadataInputStream = IOUtils.toInputStream((String)IOUtils.toString((Reader)metadata), (Charset)StandardCharsets.UTF_8);
            return new BOMInputStream(metadataInputStream, false);
        }
        catch (IOException e) {
            throw new SamlException("Couldn't read metadata", e);
        }
    }

    private static Reader decodeAndInflate(String encodedResponse, String method) {
        ByteArrayInputStream afterB64Decode = new ByteArrayInputStream(Base64.decodeBase64((String)encodedResponse));
        if ("GET".equals(method)) {
            InflaterInputStream afterInflate = new InflaterInputStream(afterB64Decode, new Inflater(true));
            return new InputStreamReader((InputStream)afterInflate, StandardCharsets.UTF_8);
        }
        return new InputStreamReader((InputStream)afterB64Decode, StandardCharsets.UTF_8);
    }

    private static synchronized void ensureOpenSamlIsInitialized() throws SamlException {
        if (!initializedOpenSaml) {
            try {
                InitializationService.initialize();
                initializedOpenSaml = true;
            }
            catch (Throwable ex) {
                throw new SamlException("Error while initializing the Open SAML library", ex);
            }
        }
    }

    private static BasicParserPool createDOMParser() throws SamlException {
        BasicParserPool basicParserPool = new BasicParserPool();
        try {
            basicParserPool.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new SamlException("Failed to create an XML parser");
        }
        return basicParserPool;
    }

    private static DOMMetadataResolver createMetadataResolver(InputStream metadata) throws SamlException {
        try {
            BasicParserPool parser = SamlClient.createDOMParser();
            Document metadataDocument = parser.parse(metadata);
            DOMMetadataResolver resolver = new DOMMetadataResolver(metadataDocument.getDocumentElement());
            resolver.setId("componentId");
            resolver.initialize();
            return resolver;
        }
        catch (ComponentInitializationException | XMLParserException ex) {
            throw new SamlException("Cannot load identity provider metadata", ex);
        }
    }

    private static EntityDescriptor getEntityDescriptor(DOMMetadataResolver metadata) throws SamlException {
        ArrayList entityDescriptors = new ArrayList();
        metadata.forEach(entityDescriptors::add);
        if (entityDescriptors.size() != 1) {
            throw new SamlException("Bad entity descriptor count: " + entityDescriptors.size());
        }
        return (EntityDescriptor)entityDescriptors.get(0);
    }

    private static IDPSSODescriptor getIDPSSODescriptor(EntityDescriptor entityDescriptor) throws SamlException {
        IDPSSODescriptor idpssoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        if (idpssoDescriptor == null) {
            throw new SamlException("Cannot retrieve IDP SSO descriptor");
        }
        return idpssoDescriptor;
    }

    private static SingleSignOnService getIdpBinding(IDPSSODescriptor idpSsoDescriptor, SamlIdpBinding samlBinding) throws SamlException {
        return idpSsoDescriptor.getSingleSignOnServices().stream().filter(x -> x.getBinding().equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-" + samlBinding.toString())).findAny().orElseThrow(() -> new SamlException("Cannot find HTTP-POST SSO binding in metadata"));
    }

    private static List<X509Certificate> getCertificates(IDPSSODescriptor idpSsoDescriptor) throws SamlException {
        List<X509Certificate> certificates;
        try {
            certificates = idpSsoDescriptor.getKeyDescriptors().stream().filter(x -> x.getUse() == UsageType.SIGNING).flatMap(SamlClient::getDatasWithCertificates).map(SamlClient::getFirstCertificate).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new SamlException("Exception in getCertificates", e);
        }
        return certificates;
    }

    private static Stream<X509Data> getDatasWithCertificates(KeyDescriptor descriptor) {
        return descriptor.getKeyInfo().getX509Datas().stream().filter(d -> d.getX509Certificates().size() > 0);
    }

    private static X509Certificate getFirstCertificate(X509Data data) {
        try {
            org.opensaml.xmlsec.signature.X509Certificate cert = data.getX509Certificates().stream().findFirst().orElse(null);
            if (cert != null) {
                return KeyInfoSupport.getCertificate((org.opensaml.xmlsec.signature.X509Certificate)cert);
            }
        }
        catch (CertificateException e) {
            logger.error("Exception in getFirstCertificate", (Throwable)e);
        }
        return null;
    }

    private static Credential getCredential(X509Certificate certificate) {
        BasicX509Credential credential = new BasicX509Credential(certificate);
        credential.setCRLs(Collections.emptyList());
        return credential;
    }

    public SamlLogoutResponse decodeAndValidateSamlLogoutResponse(String encodedResponse, String method) throws SamlException {
        LogoutResponse logoutResponse = (LogoutResponse)this.parseResponse(encodedResponse, method);
        ValidatorUtils.validate(logoutResponse, this.responseIssuer, this.credentials);
        return new SamlLogoutResponse(logoutResponse.getStatus());
    }

    public void decodeAndValidateSamlLogoutRequest(String encodedRequest, String nameID, String method) throws SamlException {
        LogoutRequest logoutRequest = (LogoutRequest)this.parseResponse(encodedRequest, method);
        ValidatorUtils.validate(logoutRequest, this.responseIssuer, this.credentials, nameID);
    }

    public void setSPKeys(String publicKey, String privateKey) throws SamlException {
        this.spCredential = this.generateBasicX509Credential(publicKey, privateKey);
    }

    private BasicX509Credential generateBasicX509Credential(String publicKey, String privateKey) throws SamlException {
        if (publicKey == null || privateKey == null) {
            throw new SamlException("No credentials provided");
        }
        PrivateKey pk = this.loadPrivateKey(privateKey);
        X509Certificate cert = this.loadCertificate(publicKey);
        return new BasicX509Credential(cert, pk);
    }

    public void setSPKeys(X509Certificate certificate, PrivateKey privateKey) throws SamlException {
        if (certificate == null || privateKey == null) {
            throw new SamlException("No credentials provided");
        }
        this.spCredential = new BasicX509Credential(certificate, privateKey);
    }

    public void addAdditionalSPKey(String publicKey, String privateKey) throws SamlException {
        this.additionalSpCredentials.add((Credential)this.generateBasicX509Credential(publicKey, privateKey));
    }

    public void addAdditionalSPKey(X509Certificate certificate, PrivateKey privateKey) throws SamlException {
        this.additionalSpCredentials.add((Credential)new BasicX509Credential(certificate, privateKey));
    }

    public void clearAdditionalSPKeys() throws SamlException {
        this.additionalSpCredentials = new ArrayList<Credential>();
    }

    public static Map<String, String> getAttributes(SamlResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (response == null) {
            return map;
        }
        List attributeStatements = response.getAssertion().getAttributeStatements();
        if (attributeStatements == null) {
            return map;
        }
        for (AttributeStatement statement : attributeStatements) {
            for (Attribute attribute : statement.getAttributes()) {
                XMLObject xmlObject = (XMLObject)attribute.getAttributeValues().get(0);
                if (xmlObject instanceof XSStringImpl) {
                    map.put(attribute.getName(), ((XSStringImpl)xmlObject).getValue());
                    continue;
                }
                map.put(attribute.getName(), ((XSAnyImpl)xmlObject).getTextContent());
            }
        }
        return map;
    }

    private RequestAbstractType getBasicSamlRequest(QName defaultElementName) {
        RequestAbstractType request = (RequestAbstractType)SamlClient.buildSamlObject(defaultElementName);
        request.setID("z" + UUID.randomUUID().toString());
        request.setVersion(SAMLVersion.VERSION_20);
        request.setIssueInstant(Instant.now());
        Issuer issuer = (Issuer)SamlClient.buildSamlObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.relyingPartyIdentifier);
        request.setIssuer(issuer);
        return request;
    }

    private String marshallAndEncodeSamlObject(RequestAbstractType request) throws SamlException {
        StringWriter stringWriter;
        try {
            stringWriter = this.marshallXmlObject((XMLObject)request);
        }
        catch (MarshallingException e) {
            throw new SamlException("Error while marshalling SAML request to XML", e);
        }
        logger.trace("Issuing SAML request: " + stringWriter.toString());
        return Base64.encodeBase64String((byte[])stringWriter.toString().getBytes(StandardCharsets.UTF_8));
    }

    public String getSamlRequest() throws SamlException {
        AuthnRequest request = (AuthnRequest)this.getBasicSamlRequest(AuthnRequest.DEFAULT_ELEMENT_NAME);
        request.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-" + this.samlBinding.toString());
        request.setDestination(this.identityProviderUrl);
        request.setAssertionConsumerServiceURL(this.assertionConsumerServiceUrl);
        NameIDPolicy nameIDPolicy = (NameIDPolicy)SamlClient.buildSamlObject(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIDPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        request.setNameIDPolicy(nameIDPolicy);
        this.signSAMLObject((SignableSAMLObject)request);
        return this.marshallAndEncodeSamlObject((RequestAbstractType)request);
    }

    public String getLogoutRequest(String nameId) throws SamlException {
        LogoutRequest request = (LogoutRequest)this.getBasicSamlRequest(LogoutRequest.DEFAULT_ELEMENT_NAME);
        NameID nid = (NameID)SamlClient.buildSamlObject(NameID.DEFAULT_ELEMENT_NAME);
        nid.setValue(nameId);
        request.setNameID(nid);
        this.signSAMLObject((SignableSAMLObject)request);
        return this.marshallAndEncodeSamlObject((RequestAbstractType)request);
    }

    public String getSamlLogoutResponse(String status) throws SamlException {
        return this.getSamlLogoutResponse(status, null);
    }

    public String getSamlLogoutResponse(String status, String statMsg) throws SamlException {
        StringWriter stringWriter;
        LogoutResponse response = (LogoutResponse)SamlClient.buildSamlObject(LogoutResponse.DEFAULT_ELEMENT_NAME);
        response.setID("z" + UUID.randomUUID().toString());
        response.setVersion(SAMLVersion.VERSION_20);
        response.setIssueInstant(Instant.now());
        Issuer issuer = (Issuer)SamlClient.buildSamlObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(this.relyingPartyIdentifier);
        response.setIssuer(issuer);
        Status stat = (Status)SamlClient.buildSamlObject(Status.DEFAULT_ELEMENT_NAME);
        StatusCode statCode = new StatusCodeBuilder().buildObject();
        statCode.setValue(status);
        stat.setStatusCode(statCode);
        if (statMsg != null) {
            StatusMessage statMessage = new StatusMessageBuilder().buildObject();
            statMessage.setValue(statMsg);
            stat.setStatusMessage(statMessage);
        }
        response.setStatus(stat);
        this.signSAMLObject((SignableSAMLObject)response);
        try {
            stringWriter = this.marshallXmlObject((XMLObject)response);
        }
        catch (MarshallingException ex) {
            throw new SamlException("Error while marshalling SAML request to XML", ex);
        }
        logger.trace("Issuing SAML Logout request: " + stringWriter.toString());
        return Base64.encodeBase64String((byte[])stringWriter.toString().getBytes(StandardCharsets.UTF_8));
    }

    public void processLogoutRequestPostFromIdentityProvider(HttpServletRequest request, String nameID) throws SamlException {
        String encodedResponse = request.getParameter(HTTP_REQ_SAML_PARAM);
        this.decodeAndValidateSamlLogoutRequest(encodedResponse, nameID, request.getMethod());
    }

    public SamlLogoutResponse processPostLogoutResponseFromIdentityProvider(HttpServletRequest request) throws SamlException {
        String encodedResponse = request.getParameter(HTTP_RESP_SAML_PARAM);
        return this.decodeAndValidateSamlLogoutResponse(encodedResponse, request.getMethod());
    }

    public void redirectToIdentityProvider(HttpServletResponse response, String relayState, String nameId) throws IOException, SamlException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(HTTP_REQ_SAML_PARAM, this.getLogoutRequest(nameId));
        if (relayState != null) {
            values.put("RelayState", relayState);
        }
        BrowserUtils.postUsingBrowser(this.identityProviderUrl, response, values);
    }

    public void redirectToIdentityProviderLogout(HttpServletResponse response, String statusCode, String statMsg) throws IOException, SamlException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(HTTP_RESP_SAML_PARAM, this.getSamlLogoutResponse(statusCode, statMsg));
        BrowserUtils.postUsingBrowser(this.identityProviderUrl, response, values);
    }

    private static XMLObject buildSamlObject(QName qname) {
        return XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(qname).buildObject(qname);
    }

    private void decodeEncryptedAssertion(Response response) throws DecryptionException {
        if (response.getEncryptedAssertions().size() == 0) {
            return;
        }
        for (EncryptedAssertion encryptedAssertion : response.getEncryptedAssertions()) {
            ArrayList<Object> resolverChain = new ArrayList<Object>();
            if (this.spCredential != null) {
                resolverChain.add(new StaticKeyInfoCredentialResolver((Credential)this.spCredential));
            }
            if (!this.additionalSpCredentials.isEmpty()) {
                resolverChain.add(new CollectionKeyInfoCredentialResolver(this.additionalSpCredentials));
            }
            Decrypter decrypter = new Decrypter(null, (KeyInfoCredentialResolver)new ChainingKeyInfoCredentialResolver(resolverChain), (EncryptedKeyResolver)new InlineEncryptedKeyResolver());
            decrypter.setRootInNewDocument(true);
            Assertion decryptedAssertion = decrypter.decrypt(encryptedAssertion);
            response.getAssertions().add(decryptedAssertion);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private X509Certificate loadCertificate(String filename) throws SamlException {
        try (FileInputStream fis = new FileInputStream(filename);){
            X509Certificate x509Certificate;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                x509Certificate = (X509Certificate)cf.generateCertificate(bis);
            }
            return x509Certificate;
        }
        catch (FileNotFoundException e) {
            throw new SamlException("Public key file doesn't exist", e);
        }
        catch (Exception e) {
            throw new SamlException("Couldn't load public key", e);
        }
    }

    private PrivateKey loadPrivateKey(String filename) throws SamlException {
        PrivateKey privateKey;
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        try {
            byte[] buf = new byte[(int)raf.length()];
            raf.readFully(buf);
            PKCS8EncodedKeySpec kspec = new PKCS8EncodedKeySpec(buf);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            privateKey = kf.generatePrivate(kspec);
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new SamlException("Private key file doesn't exist", e);
            }
            catch (Exception e) {
                throw new SamlException("Couldn't load private key", e);
            }
        }
        raf.close();
        return privateKey;
    }

    private StringWriter marshallXmlObject(XMLObject object) throws MarshallingException {
        StringWriter stringWriter = new StringWriter();
        Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(object);
        Element dom = marshaller.marshall(object);
        XMLHelper.writeNode(dom, stringWriter);
        return stringWriter;
    }

    private SAMLObject parseResponse(String encodedResponse, String method) throws SamlException {
        logger.trace("Validating SAML response " + encodedResponse);
        try {
            Document responseDocument = this.domParser.parse(SamlClient.decodeAndInflate(encodedResponse, method));
            return (SAMLObject)XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(responseDocument.getDocumentElement()).unmarshall(responseDocument.getDocumentElement());
        }
        catch (XMLParserException | UnmarshallingException ex) {
            throw new SamlException("Cannot decode xml encoded response", ex);
        }
    }

    private void signSAMLObject(SignableSAMLObject samlObject) throws SamlException {
        if (this.spCredential != null) {
            try {
                SignatureBuilder signer = new SignatureBuilder();
                Signature signature = (Signature)signer.buildObject(Signature.DEFAULT_ELEMENT_NAME);
                signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                signature.setKeyInfo(new X509KeyInfoGeneratorFactory().newInstance().generate((Credential)this.spCredential));
                signature.setSigningCredential((Credential)this.spCredential);
                samlObject.setSignature(signature);
                SignatureSigningParameters signingParameters = new SignatureSigningParameters();
                signingParameters.setSigningCredential((Credential)this.spCredential);
                signingParameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                signingParameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
                signingParameters.setKeyInfoGenerator(new X509KeyInfoGeneratorFactory().newInstance());
                SignatureSupport.signObject((SignableXMLObject)samlObject, (SignatureSigningParameters)signingParameters);
            }
            catch (MarshallingException | SecurityException | SignatureException e) {
                throw new SamlException("Failed to sign request", e);
            }
        }
    }

    public static enum SamlIdpBinding {
        POST,
        Redirect;

    }
}

