/*
 * Decompiled with CFR 0.152.
 */
package com.damnhandy.uri.template;

import com.damnhandy.uri.template.UriTransient;
import com.damnhandy.uri.template.VarExploder;
import com.damnhandy.uri.template.VarName;
import com.damnhandy.uri.template.impl.VariableExpansionException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultVarExploder
implements VarExploder {
    private Object source;
    private Map<String, Object> pairs = new LinkedHashMap<String, Object>();

    public DefaultVarExploder(Object source) {
        this.setSource(source);
    }

    @Override
    public Map<String, Object> getNameValuePairs() {
        return this.pairs;
    }

    public void setSource(Object source) {
        this.source = source;
        this.initValues();
    }

    private void initValues() {
        BeanInfo beanInfo;
        Class<?> c = this.source.getClass();
        if (c.isAnnotation() || c.isArray() || c.isEnum() || c.isPrimitive()) {
            throw new IllegalArgumentException("The value must an object");
        }
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new VariableExpansionException(e);
        }
        for (PropertyDescriptor p : beanInfo.getPropertyDescriptors()) {
            Method readMethod = p.getReadMethod();
            if (readMethod.isAnnotationPresent(UriTransient.class) || p.getName().equals("class")) continue;
            Object value = this.getValue(readMethod);
            String name = p.getName();
            if (readMethod.isAnnotationPresent(VarName.class)) {
                name = readMethod.getAnnotation(VarName.class).value();
            }
            if (value == null) continue;
            this.pairs.put(name, value);
        }
        this.scanFields(c);
    }

    private void scanFields(Class<?> c) {
        if (!c.isInterface()) {
            Field[] fields;
            for (Field field : fields = c.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!this.pairs.containsKey(fieldName)) continue;
                if (field.isAnnotationPresent(UriTransient.class)) {
                    this.pairs.remove(fieldName);
                    continue;
                }
                if (!field.isAnnotationPresent(VarName.class)) continue;
                String name = field.getAnnotation(VarName.class).value();
                this.pairs.put(name, this.pairs.get(fieldName));
                this.pairs.remove(fieldName);
            }
        }
        if (!c.getSuperclass().equals(Object.class)) {
            this.scanFields(c.getSuperclass());
        }
    }

    private Object getValue(Method method) {
        try {
            if (method == null) {
                return null;
            }
            return method.invoke(this.source, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new VariableExpansionException(e);
        }
        catch (IllegalAccessException e) {
            throw new VariableExpansionException(e);
        }
        catch (InvocationTargetException e) {
            throw new VariableExpansionException(e);
        }
    }

    @Override
    public Collection<Object> getValues() {
        Collection<Object> c = this.pairs.values();
        return c;
    }
}

