/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client;

import java.util.logging.Level;
import java.util.logging.Logger;

public class RetryConfig {
    public boolean enableRetry;
    public int backOffMultiplier;
    public int backOffBase;
    public int maxRetries;
    private static final Logger log = Logger.getLogger(RetryConfig.class.getName());

    public RetryConfig(boolean enableRetry, int backOffMultiplier, int backOffBase, int maxRetries) {
        if (backOffBase < 2) {
            throw new IllegalArgumentException("backOffBase cannot be smaller than 2");
        }
        this.enableRetry = enableRetry;
        this.backOffMultiplier = backOffMultiplier;
        this.backOffBase = backOffBase;
        this.maxRetries = maxRetries;
    }

    public boolean isEnableRetry() {
        return this.enableRetry;
    }

    public int getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public int getBackOffBase() {
        return this.backOffBase;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setEnableRetry(boolean enableRetry) {
        this.enableRetry = enableRetry;
    }

    public void setBackOffMultiplier(int backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public void setBackOffBase(int backOffBase) {
        this.backOffBase = backOffBase;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void sleepInterval(int sleepInterval) {
        try {
            Thread.sleep(sleepInterval * 1000);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.log(Level.FINE, "Retry sleep interrupted", e);
        }
    }
}

