/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v1.model.WebhooksIntegration;
import com.datadog.api.client.v1.model.WebhooksIntegrationCustomVariable;
import com.datadog.api.client.v1.model.WebhooksIntegrationCustomVariableResponse;
import com.datadog.api.client.v1.model.WebhooksIntegrationCustomVariableUpdateRequest;
import com.datadog.api.client.v1.model.WebhooksIntegrationUpdateRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class WebhooksIntegrationApi {
    private ApiClient apiClient;

    public WebhooksIntegrationApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public WebhooksIntegrationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public WebhooksIntegration createWebhooksIntegration(WebhooksIntegration body) throws ApiException {
        return this.createWebhooksIntegrationWithHttpInfo(body).getData();
    }

    public CompletableFuture<WebhooksIntegration> createWebhooksIntegrationAsync(WebhooksIntegration body) {
        return this.createWebhooksIntegrationWithHttpInfoAsync(body).thenApply(response -> (WebhooksIntegration)response.getData());
    }

    public ApiResponse<WebhooksIntegration> createWebhooksIntegrationWithHttpInfo(WebhooksIntegration body) throws ApiException {
        WebhooksIntegration localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWebhooksIntegration");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.createWebhooksIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegration>(){});
    }

    public CompletableFuture<ApiResponse<WebhooksIntegration>> createWebhooksIntegrationWithHttpInfoAsync(WebhooksIntegration body) {
        Invocation.Builder builder;
        WebhooksIntegration localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<WebhooksIntegration>> result = new CompletableFuture<ApiResponse<WebhooksIntegration>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createWebhooksIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.createWebhooksIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WebhooksIntegration>> result = new CompletableFuture<ApiResponse<WebhooksIntegration>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegration>(){});
    }

    public WebhooksIntegrationCustomVariableResponse createWebhooksIntegrationCustomVariable(WebhooksIntegrationCustomVariable body) throws ApiException {
        return this.createWebhooksIntegrationCustomVariableWithHttpInfo(body).getData();
    }

    public CompletableFuture<WebhooksIntegrationCustomVariableResponse> createWebhooksIntegrationCustomVariableAsync(WebhooksIntegrationCustomVariable body) {
        return this.createWebhooksIntegrationCustomVariableWithHttpInfoAsync(body).thenApply(response -> (WebhooksIntegrationCustomVariableResponse)response.getData());
    }

    public ApiResponse<WebhooksIntegrationCustomVariableResponse> createWebhooksIntegrationCustomVariableWithHttpInfo(WebhooksIntegrationCustomVariable body) throws ApiException {
        WebhooksIntegrationCustomVariable localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createWebhooksIntegrationCustomVariable");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.createWebhooksIntegrationCustomVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegrationCustomVariableResponse>(){});
    }

    public CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> createWebhooksIntegrationCustomVariableWithHttpInfoAsync(WebhooksIntegrationCustomVariable body) {
        Invocation.Builder builder;
        WebhooksIntegrationCustomVariable localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> result = new CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createWebhooksIntegrationCustomVariable"));
            return result;
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.createWebhooksIntegrationCustomVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> result = new CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegrationCustomVariableResponse>(){});
    }

    public void deleteWebhooksIntegration(String webhookName) throws ApiException {
        this.deleteWebhooksIntegrationWithHttpInfo(webhookName);
    }

    public CompletableFuture<Void> deleteWebhooksIntegrationAsync(String webhookName) {
        return this.deleteWebhooksIntegrationWithHttpInfoAsync(webhookName).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteWebhooksIntegrationWithHttpInfo(String webhookName) throws ApiException {
        Object localVarPostBody = null;
        if (webhookName == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookName' when calling deleteWebhooksIntegration");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.deleteWebhooksIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteWebhooksIntegrationWithHttpInfoAsync(String webhookName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (webhookName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'webhookName' when calling deleteWebhooksIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.deleteWebhooksIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteWebhooksIntegrationCustomVariable(String customVariableName) throws ApiException {
        this.deleteWebhooksIntegrationCustomVariableWithHttpInfo(customVariableName);
    }

    public CompletableFuture<Void> deleteWebhooksIntegrationCustomVariableAsync(String customVariableName) {
        return this.deleteWebhooksIntegrationCustomVariableWithHttpInfoAsync(customVariableName).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteWebhooksIntegrationCustomVariableWithHttpInfo(String customVariableName) throws ApiException {
        Object localVarPostBody = null;
        if (customVariableName == null) {
            throw new ApiException(400, "Missing the required parameter 'customVariableName' when calling deleteWebhooksIntegrationCustomVariable");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.deleteWebhooksIntegrationCustomVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteWebhooksIntegrationCustomVariableWithHttpInfoAsync(String customVariableName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (customVariableName == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customVariableName' when calling deleteWebhooksIntegrationCustomVariable"));
            return result;
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.deleteWebhooksIntegrationCustomVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public WebhooksIntegration getWebhooksIntegration(String webhookName) throws ApiException {
        return this.getWebhooksIntegrationWithHttpInfo(webhookName).getData();
    }

    public CompletableFuture<WebhooksIntegration> getWebhooksIntegrationAsync(String webhookName) {
        return this.getWebhooksIntegrationWithHttpInfoAsync(webhookName).thenApply(response -> (WebhooksIntegration)response.getData());
    }

    public ApiResponse<WebhooksIntegration> getWebhooksIntegrationWithHttpInfo(String webhookName) throws ApiException {
        Object localVarPostBody = null;
        if (webhookName == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookName' when calling getWebhooksIntegration");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.getWebhooksIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegration>(){});
    }

    public CompletableFuture<ApiResponse<WebhooksIntegration>> getWebhooksIntegrationWithHttpInfoAsync(String webhookName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (webhookName == null) {
            CompletableFuture<ApiResponse<WebhooksIntegration>> result = new CompletableFuture<ApiResponse<WebhooksIntegration>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'webhookName' when calling getWebhooksIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.getWebhooksIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WebhooksIntegration>> result = new CompletableFuture<ApiResponse<WebhooksIntegration>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegration>(){});
    }

    public WebhooksIntegrationCustomVariableResponse getWebhooksIntegrationCustomVariable(String customVariableName) throws ApiException {
        return this.getWebhooksIntegrationCustomVariableWithHttpInfo(customVariableName).getData();
    }

    public CompletableFuture<WebhooksIntegrationCustomVariableResponse> getWebhooksIntegrationCustomVariableAsync(String customVariableName) {
        return this.getWebhooksIntegrationCustomVariableWithHttpInfoAsync(customVariableName).thenApply(response -> (WebhooksIntegrationCustomVariableResponse)response.getData());
    }

    public ApiResponse<WebhooksIntegrationCustomVariableResponse> getWebhooksIntegrationCustomVariableWithHttpInfo(String customVariableName) throws ApiException {
        Object localVarPostBody = null;
        if (customVariableName == null) {
            throw new ApiException(400, "Missing the required parameter 'customVariableName' when calling getWebhooksIntegrationCustomVariable");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.getWebhooksIntegrationCustomVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegrationCustomVariableResponse>(){});
    }

    public CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> getWebhooksIntegrationCustomVariableWithHttpInfoAsync(String customVariableName) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (customVariableName == null) {
            CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> result = new CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customVariableName' when calling getWebhooksIntegrationCustomVariable"));
            return result;
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.getWebhooksIntegrationCustomVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> result = new CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegrationCustomVariableResponse>(){});
    }

    public WebhooksIntegration updateWebhooksIntegration(String webhookName, WebhooksIntegrationUpdateRequest body) throws ApiException {
        return this.updateWebhooksIntegrationWithHttpInfo(webhookName, body).getData();
    }

    public CompletableFuture<WebhooksIntegration> updateWebhooksIntegrationAsync(String webhookName, WebhooksIntegrationUpdateRequest body) {
        return this.updateWebhooksIntegrationWithHttpInfoAsync(webhookName, body).thenApply(response -> (WebhooksIntegration)response.getData());
    }

    public ApiResponse<WebhooksIntegration> updateWebhooksIntegrationWithHttpInfo(String webhookName, WebhooksIntegrationUpdateRequest body) throws ApiException {
        WebhooksIntegrationUpdateRequest localVarPostBody = body;
        if (webhookName == null) {
            throw new ApiException(400, "Missing the required parameter 'webhookName' when calling updateWebhooksIntegration");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateWebhooksIntegration");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.updateWebhooksIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegration>(){});
    }

    public CompletableFuture<ApiResponse<WebhooksIntegration>> updateWebhooksIntegrationWithHttpInfoAsync(String webhookName, WebhooksIntegrationUpdateRequest body) {
        Invocation.Builder builder;
        WebhooksIntegrationUpdateRequest localVarPostBody = body;
        if (webhookName == null) {
            CompletableFuture<ApiResponse<WebhooksIntegration>> result = new CompletableFuture<ApiResponse<WebhooksIntegration>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'webhookName' when calling updateWebhooksIntegration"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<WebhooksIntegration>> result = new CompletableFuture<ApiResponse<WebhooksIntegration>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateWebhooksIntegration"));
            return result;
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/webhooks/{webhook_name}".replaceAll("\\{webhook_name\\}", this.apiClient.escapeString(webhookName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.updateWebhooksIntegration", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WebhooksIntegration>> result = new CompletableFuture<ApiResponse<WebhooksIntegration>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegration>(){});
    }

    public WebhooksIntegrationCustomVariableResponse updateWebhooksIntegrationCustomVariable(String customVariableName, WebhooksIntegrationCustomVariableUpdateRequest body) throws ApiException {
        return this.updateWebhooksIntegrationCustomVariableWithHttpInfo(customVariableName, body).getData();
    }

    public CompletableFuture<WebhooksIntegrationCustomVariableResponse> updateWebhooksIntegrationCustomVariableAsync(String customVariableName, WebhooksIntegrationCustomVariableUpdateRequest body) {
        return this.updateWebhooksIntegrationCustomVariableWithHttpInfoAsync(customVariableName, body).thenApply(response -> (WebhooksIntegrationCustomVariableResponse)response.getData());
    }

    public ApiResponse<WebhooksIntegrationCustomVariableResponse> updateWebhooksIntegrationCustomVariableWithHttpInfo(String customVariableName, WebhooksIntegrationCustomVariableUpdateRequest body) throws ApiException {
        WebhooksIntegrationCustomVariableUpdateRequest localVarPostBody = body;
        if (customVariableName == null) {
            throw new ApiException(400, "Missing the required parameter 'customVariableName' when calling updateWebhooksIntegrationCustomVariable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateWebhooksIntegrationCustomVariable");
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.updateWebhooksIntegrationCustomVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegrationCustomVariableResponse>(){});
    }

    public CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> updateWebhooksIntegrationCustomVariableWithHttpInfoAsync(String customVariableName, WebhooksIntegrationCustomVariableUpdateRequest body) {
        Invocation.Builder builder;
        WebhooksIntegrationCustomVariableUpdateRequest localVarPostBody = body;
        if (customVariableName == null) {
            CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> result = new CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'customVariableName' when calling updateWebhooksIntegrationCustomVariable"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> result = new CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateWebhooksIntegrationCustomVariable"));
            return result;
        }
        String localVarPath = "/api/v1/integration/webhooks/configuration/custom-variables/{custom_variable_name}".replaceAll("\\{custom_variable_name\\}", this.apiClient.escapeString(customVariableName.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v1.WebhooksIntegrationApi.updateWebhooksIntegrationCustomVariable", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>> result = new CompletableFuture<ApiResponse<WebhooksIntegrationCustomVariableResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<WebhooksIntegrationCustomVariableResponse>(){});
    }
}

