/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateOpenAPIResponse;
import com.datadog.api.client.v2.model.ListAPIsResponse;
import com.datadog.api.client.v2.model.UpdateOpenAPIResponse;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class ApiManagementApi {
    private ApiClient apiClient;

    public ApiManagementApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public ApiManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public CreateOpenAPIResponse createOpenAPI() throws ApiException {
        return this.createOpenAPIWithHttpInfo(new CreateOpenAPIOptionalParameters()).getData();
    }

    public CompletableFuture<CreateOpenAPIResponse> createOpenAPIAsync() {
        return this.createOpenAPIWithHttpInfoAsync(new CreateOpenAPIOptionalParameters()).thenApply(response -> (CreateOpenAPIResponse)response.getData());
    }

    public CreateOpenAPIResponse createOpenAPI(CreateOpenAPIOptionalParameters parameters) throws ApiException {
        return this.createOpenAPIWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<CreateOpenAPIResponse> createOpenAPIAsync(CreateOpenAPIOptionalParameters parameters) {
        return this.createOpenAPIWithHttpInfoAsync(parameters).thenApply(response -> (CreateOpenAPIResponse)response.getData());
    }

    public ApiResponse<CreateOpenAPIResponse> createOpenAPIWithHttpInfo(CreateOpenAPIOptionalParameters parameters) throws ApiException {
        String operationId = "createOpenAPI";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        File openapiSpecFile = parameters.openapiSpecFile;
        String localVarPath = "/api/v2/apicatalog/openapi";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (openapiSpecFile != null) {
            localVarFormParams.put("openapi_spec_file", openapiSpecFile);
        }
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApiManagementApi.createOpenAPI", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"multipart/form-data"}, localVarPostBody, localVarFormParams, false, new GenericType<CreateOpenAPIResponse>(){});
    }

    public CompletableFuture<ApiResponse<CreateOpenAPIResponse>> createOpenAPIWithHttpInfoAsync(CreateOpenAPIOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "createOpenAPI";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<CreateOpenAPIResponse>> result = new CompletableFuture<ApiResponse<CreateOpenAPIResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        File openapiSpecFile = parameters.openapiSpecFile;
        String localVarPath = "/api/v2/apicatalog/openapi";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (openapiSpecFile != null) {
            localVarFormParams.put("openapi_spec_file", openapiSpecFile);
        }
        try {
            builder = this.apiClient.createBuilder("v2.ApiManagementApi.createOpenAPI", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<CreateOpenAPIResponse>> result = new CompletableFuture<ApiResponse<CreateOpenAPIResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"multipart/form-data"}, localVarPostBody, localVarFormParams, false, new GenericType<CreateOpenAPIResponse>(){});
    }

    public void deleteOpenAPI(UUID id) throws ApiException {
        this.deleteOpenAPIWithHttpInfo(id);
    }

    public CompletableFuture<Void> deleteOpenAPIAsync(UUID id) {
        return this.deleteOpenAPIWithHttpInfoAsync(id).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteOpenAPIWithHttpInfo(UUID id) throws ApiException {
        String operationId = "deleteOpenAPI";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteOpenAPI");
        }
        String localVarPath = "/api/v2/apicatalog/api/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApiManagementApi.deleteOpenAPI", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteOpenAPIWithHttpInfoAsync(UUID id) {
        Invocation.Builder builder;
        String operationId = "deleteOpenAPI";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling deleteOpenAPI"));
            return result;
        }
        String localVarPath = "/api/v2/apicatalog/api/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApiManagementApi.deleteOpenAPI", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public File getOpenAPI(UUID id) throws ApiException {
        return this.getOpenAPIWithHttpInfo(id).getData();
    }

    public CompletableFuture<File> getOpenAPIAsync(UUID id) {
        return this.getOpenAPIWithHttpInfoAsync(id).thenApply(response -> (File)response.getData());
    }

    public ApiResponse<File> getOpenAPIWithHttpInfo(UUID id) throws ApiException {
        String operationId = "getOpenAPI";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getOpenAPI");
        }
        String localVarPath = "/api/v2/apicatalog/api/{id}/openapi".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApiManagementApi.getOpenAPI", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"multipart/form-data", "application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<File>(){});
    }

    public CompletableFuture<ApiResponse<File>> getOpenAPIWithHttpInfoAsync(UUID id) {
        Invocation.Builder builder;
        String operationId = "getOpenAPI";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<File>> result = new CompletableFuture<ApiResponse<File>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<File>> result = new CompletableFuture<ApiResponse<File>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling getOpenAPI"));
            return result;
        }
        String localVarPath = "/api/v2/apicatalog/api/{id}/openapi".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.ApiManagementApi.getOpenAPI", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"multipart/form-data", "application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<File>> result = new CompletableFuture<ApiResponse<File>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<File>(){});
    }

    public ListAPIsResponse listAPIs() throws ApiException {
        return this.listAPIsWithHttpInfo(new ListAPIsOptionalParameters()).getData();
    }

    public CompletableFuture<ListAPIsResponse> listAPIsAsync() {
        return this.listAPIsWithHttpInfoAsync(new ListAPIsOptionalParameters()).thenApply(response -> (ListAPIsResponse)response.getData());
    }

    public ListAPIsResponse listAPIs(ListAPIsOptionalParameters parameters) throws ApiException {
        return this.listAPIsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<ListAPIsResponse> listAPIsAsync(ListAPIsOptionalParameters parameters) {
        return this.listAPIsWithHttpInfoAsync(parameters).thenApply(response -> (ListAPIsResponse)response.getData());
    }

    public ApiResponse<ListAPIsResponse> listAPIsWithHttpInfo(ListAPIsOptionalParameters parameters) throws ApiException {
        String operationId = "listAPIs";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String query = parameters.query;
        Long pageLimit = parameters.pageLimit;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/apicatalog/api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApiManagementApi.listAPIs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAPIsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListAPIsResponse>> listAPIsWithHttpInfoAsync(ListAPIsOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "listAPIs";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<ListAPIsResponse>> result = new CompletableFuture<ApiResponse<ListAPIsResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        String query = parameters.query;
        Long pageLimit = parameters.pageLimit;
        Long pageOffset = parameters.pageOffset;
        String localVarPath = "/api/v2/apicatalog/api";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "query", query));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[limit]", pageLimit));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[offset]", pageOffset));
        try {
            builder = this.apiClient.createBuilder("v2.ApiManagementApi.listAPIs", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListAPIsResponse>> result = new CompletableFuture<ApiResponse<ListAPIsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListAPIsResponse>(){});
    }

    public UpdateOpenAPIResponse updateOpenAPI(UUID id) throws ApiException {
        return this.updateOpenAPIWithHttpInfo(id, new UpdateOpenAPIOptionalParameters()).getData();
    }

    public CompletableFuture<UpdateOpenAPIResponse> updateOpenAPIAsync(UUID id) {
        return this.updateOpenAPIWithHttpInfoAsync(id, new UpdateOpenAPIOptionalParameters()).thenApply(response -> (UpdateOpenAPIResponse)response.getData());
    }

    public UpdateOpenAPIResponse updateOpenAPI(UUID id, UpdateOpenAPIOptionalParameters parameters) throws ApiException {
        return this.updateOpenAPIWithHttpInfo(id, parameters).getData();
    }

    public CompletableFuture<UpdateOpenAPIResponse> updateOpenAPIAsync(UUID id, UpdateOpenAPIOptionalParameters parameters) {
        return this.updateOpenAPIWithHttpInfoAsync(id, parameters).thenApply(response -> (UpdateOpenAPIResponse)response.getData());
    }

    public ApiResponse<UpdateOpenAPIResponse> updateOpenAPIWithHttpInfo(UUID id, UpdateOpenAPIOptionalParameters parameters) throws ApiException {
        String operationId = "updateOpenAPI";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            throw new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId));
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateOpenAPI");
        }
        File openapiSpecFile = parameters.openapiSpecFile;
        String localVarPath = "/api/v2/apicatalog/api/{id}/openapi".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (openapiSpecFile != null) {
            localVarFormParams.put("openapi_spec_file", openapiSpecFile);
        }
        Invocation.Builder builder = this.apiClient.createBuilder("v2.ApiManagementApi.updateOpenAPI", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"multipart/form-data"}, localVarPostBody, localVarFormParams, false, new GenericType<UpdateOpenAPIResponse>(){});
    }

    public CompletableFuture<ApiResponse<UpdateOpenAPIResponse>> updateOpenAPIWithHttpInfoAsync(UUID id, UpdateOpenAPIOptionalParameters parameters) {
        Invocation.Builder builder;
        String operationId = "updateOpenAPI";
        if (!this.apiClient.isUnstableOperationEnabled("v2." + operationId)) {
            CompletableFuture<ApiResponse<UpdateOpenAPIResponse>> result = new CompletableFuture<ApiResponse<UpdateOpenAPIResponse>>();
            result.completeExceptionally(new ApiException(0, String.format("Unstable operation '%s' is disabled", operationId)));
            return result;
        }
        this.apiClient.getLogger().warning(String.format("Using unstable operation '%s'", operationId));
        Object localVarPostBody = null;
        if (id == null) {
            CompletableFuture<ApiResponse<UpdateOpenAPIResponse>> result = new CompletableFuture<ApiResponse<UpdateOpenAPIResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'id' when calling updateOpenAPI"));
            return result;
        }
        File openapiSpecFile = parameters.openapiSpecFile;
        String localVarPath = "/api/v2/apicatalog/api/{id}/openapi".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (openapiSpecFile != null) {
            localVarFormParams.put("openapi_spec_file", openapiSpecFile);
        }
        try {
            builder = this.apiClient.createBuilder("v2.ApiManagementApi.updateOpenAPI", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<UpdateOpenAPIResponse>> result = new CompletableFuture<ApiResponse<UpdateOpenAPIResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"multipart/form-data"}, localVarPostBody, localVarFormParams, false, new GenericType<UpdateOpenAPIResponse>(){});
    }

    public static class UpdateOpenAPIOptionalParameters {
        private File openapiSpecFile;

        public UpdateOpenAPIOptionalParameters openapiSpecFile(File openapiSpecFile) {
            this.openapiSpecFile = openapiSpecFile;
            return this;
        }
    }

    public static class ListAPIsOptionalParameters {
        private String query;
        private Long pageLimit;
        private Long pageOffset;

        public ListAPIsOptionalParameters query(String query) {
            this.query = query;
            return this;
        }

        public ListAPIsOptionalParameters pageLimit(Long pageLimit) {
            this.pageLimit = pageLimit;
            return this;
        }

        public ListAPIsOptionalParameters pageOffset(Long pageOffset) {
            this.pageOffset = pageOffset;
            return this;
        }
    }

    public static class CreateOpenAPIOptionalParameters {
        private File openapiSpecFile;

        public CreateOpenAPIOptionalParameters openapiSpecFile(File openapiSpecFile) {
            this.openapiSpecFile = openapiSpecFile;
            return this;
        }
    }
}

