/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.AuthNMappingCreateRequest;
import com.datadog.api.client.v2.model.AuthNMappingResponse;
import com.datadog.api.client.v2.model.AuthNMappingUpdateRequest;
import com.datadog.api.client.v2.model.AuthNMappingsResponse;
import com.datadog.api.client.v2.model.AuthNMappingsSort;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class AuthNMappingsApi {
    private ApiClient apiClient;

    public AuthNMappingsApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public AuthNMappingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AuthNMappingResponse createAuthNMapping(AuthNMappingCreateRequest body) throws ApiException {
        return this.createAuthNMappingWithHttpInfo(body).getData();
    }

    public CompletableFuture<AuthNMappingResponse> createAuthNMappingAsync(AuthNMappingCreateRequest body) {
        return this.createAuthNMappingWithHttpInfoAsync(body).thenApply(response -> (AuthNMappingResponse)response.getData());
    }

    public ApiResponse<AuthNMappingResponse> createAuthNMappingWithHttpInfo(AuthNMappingCreateRequest body) throws ApiException {
        AuthNMappingCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createAuthNMapping");
        }
        String localVarPath = "/api/v2/authn_mappings";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.createAuthNMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuthNMappingResponse>(){});
    }

    public CompletableFuture<ApiResponse<AuthNMappingResponse>> createAuthNMappingWithHttpInfoAsync(AuthNMappingCreateRequest body) {
        Invocation.Builder builder;
        AuthNMappingCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<AuthNMappingResponse>> result = new CompletableFuture<ApiResponse<AuthNMappingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createAuthNMapping"));
            return result;
        }
        String localVarPath = "/api/v2/authn_mappings";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.createAuthNMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AuthNMappingResponse>> result = new CompletableFuture<ApiResponse<AuthNMappingResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuthNMappingResponse>(){});
    }

    public void deleteAuthNMapping(String authnMappingId) throws ApiException {
        this.deleteAuthNMappingWithHttpInfo(authnMappingId);
    }

    public CompletableFuture<Void> deleteAuthNMappingAsync(String authnMappingId) {
        return this.deleteAuthNMappingWithHttpInfoAsync(authnMappingId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteAuthNMappingWithHttpInfo(String authnMappingId) throws ApiException {
        Object localVarPostBody = null;
        if (authnMappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'authnMappingId' when calling deleteAuthNMapping");
        }
        String localVarPath = "/api/v2/authn_mappings/{authn_mapping_id}".replaceAll("\\{authn_mapping_id\\}", this.apiClient.escapeString(authnMappingId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.deleteAuthNMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteAuthNMappingWithHttpInfoAsync(String authnMappingId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (authnMappingId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'authnMappingId' when calling deleteAuthNMapping"));
            return result;
        }
        String localVarPath = "/api/v2/authn_mappings/{authn_mapping_id}".replaceAll("\\{authn_mapping_id\\}", this.apiClient.escapeString(authnMappingId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.deleteAuthNMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public AuthNMappingResponse getAuthNMapping(String authnMappingId) throws ApiException {
        return this.getAuthNMappingWithHttpInfo(authnMappingId).getData();
    }

    public CompletableFuture<AuthNMappingResponse> getAuthNMappingAsync(String authnMappingId) {
        return this.getAuthNMappingWithHttpInfoAsync(authnMappingId).thenApply(response -> (AuthNMappingResponse)response.getData());
    }

    public ApiResponse<AuthNMappingResponse> getAuthNMappingWithHttpInfo(String authnMappingId) throws ApiException {
        Object localVarPostBody = null;
        if (authnMappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'authnMappingId' when calling getAuthNMapping");
        }
        String localVarPath = "/api/v2/authn_mappings/{authn_mapping_id}".replaceAll("\\{authn_mapping_id\\}", this.apiClient.escapeString(authnMappingId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.getAuthNMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuthNMappingResponse>(){});
    }

    public CompletableFuture<ApiResponse<AuthNMappingResponse>> getAuthNMappingWithHttpInfoAsync(String authnMappingId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (authnMappingId == null) {
            CompletableFuture<ApiResponse<AuthNMappingResponse>> result = new CompletableFuture<ApiResponse<AuthNMappingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'authnMappingId' when calling getAuthNMapping"));
            return result;
        }
        String localVarPath = "/api/v2/authn_mappings/{authn_mapping_id}".replaceAll("\\{authn_mapping_id\\}", this.apiClient.escapeString(authnMappingId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.getAuthNMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AuthNMappingResponse>> result = new CompletableFuture<ApiResponse<AuthNMappingResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuthNMappingResponse>(){});
    }

    public AuthNMappingsResponse listAuthNMappings() throws ApiException {
        return this.listAuthNMappingsWithHttpInfo(new ListAuthNMappingsOptionalParameters()).getData();
    }

    public CompletableFuture<AuthNMappingsResponse> listAuthNMappingsAsync() {
        return this.listAuthNMappingsWithHttpInfoAsync(new ListAuthNMappingsOptionalParameters()).thenApply(response -> (AuthNMappingsResponse)response.getData());
    }

    public AuthNMappingsResponse listAuthNMappings(ListAuthNMappingsOptionalParameters parameters) throws ApiException {
        return this.listAuthNMappingsWithHttpInfo(parameters).getData();
    }

    public CompletableFuture<AuthNMappingsResponse> listAuthNMappingsAsync(ListAuthNMappingsOptionalParameters parameters) {
        return this.listAuthNMappingsWithHttpInfoAsync(parameters).thenApply(response -> (AuthNMappingsResponse)response.getData());
    }

    public ApiResponse<AuthNMappingsResponse> listAuthNMappingsWithHttpInfo(ListAuthNMappingsOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        AuthNMappingsSort sort = parameters.sort;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/authn_mappings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.listAuthNMappings", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuthNMappingsResponse>(){});
    }

    public CompletableFuture<ApiResponse<AuthNMappingsResponse>> listAuthNMappingsWithHttpInfoAsync(ListAuthNMappingsOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        Long pageSize = parameters.pageSize;
        Long pageNumber = parameters.pageNumber;
        AuthNMappingsSort sort = parameters.sort;
        String filter = parameters.filter;
        String localVarPath = "/api/v2/authn_mappings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[size]", pageSize));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "page[number]", pageNumber));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "sort", sort));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter", filter));
        try {
            builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.listAuthNMappings", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AuthNMappingsResponse>> result = new CompletableFuture<ApiResponse<AuthNMappingsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuthNMappingsResponse>(){});
    }

    public AuthNMappingResponse updateAuthNMapping(String authnMappingId, AuthNMappingUpdateRequest body) throws ApiException {
        return this.updateAuthNMappingWithHttpInfo(authnMappingId, body).getData();
    }

    public CompletableFuture<AuthNMappingResponse> updateAuthNMappingAsync(String authnMappingId, AuthNMappingUpdateRequest body) {
        return this.updateAuthNMappingWithHttpInfoAsync(authnMappingId, body).thenApply(response -> (AuthNMappingResponse)response.getData());
    }

    public ApiResponse<AuthNMappingResponse> updateAuthNMappingWithHttpInfo(String authnMappingId, AuthNMappingUpdateRequest body) throws ApiException {
        AuthNMappingUpdateRequest localVarPostBody = body;
        if (authnMappingId == null) {
            throw new ApiException(400, "Missing the required parameter 'authnMappingId' when calling updateAuthNMapping");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateAuthNMapping");
        }
        String localVarPath = "/api/v2/authn_mappings/{authn_mapping_id}".replaceAll("\\{authn_mapping_id\\}", this.apiClient.escapeString(authnMappingId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.updateAuthNMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        return this.apiClient.invokeAPI("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuthNMappingResponse>(){});
    }

    public CompletableFuture<ApiResponse<AuthNMappingResponse>> updateAuthNMappingWithHttpInfoAsync(String authnMappingId, AuthNMappingUpdateRequest body) {
        Invocation.Builder builder;
        AuthNMappingUpdateRequest localVarPostBody = body;
        if (authnMappingId == null) {
            CompletableFuture<ApiResponse<AuthNMappingResponse>> result = new CompletableFuture<ApiResponse<AuthNMappingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'authnMappingId' when calling updateAuthNMapping"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<AuthNMappingResponse>> result = new CompletableFuture<ApiResponse<AuthNMappingResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateAuthNMapping"));
            return result;
        }
        String localVarPath = "/api/v2/authn_mappings/{authn_mapping_id}".replaceAll("\\{authn_mapping_id\\}", this.apiClient.escapeString(authnMappingId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.AuthNMappingsApi.updateAuthNMapping", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"AuthZ", "apiKeyAuth", "appKeyAuth"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<AuthNMappingResponse>> result = new CompletableFuture<ApiResponse<AuthNMappingResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PATCH", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<AuthNMappingResponse>(){});
    }

    public static class ListAuthNMappingsOptionalParameters {
        private Long pageSize;
        private Long pageNumber;
        private AuthNMappingsSort sort;
        private String filter;

        public ListAuthNMappingsOptionalParameters pageSize(Long pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public ListAuthNMappingsOptionalParameters pageNumber(Long pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }

        public ListAuthNMappingsOptionalParameters sort(AuthNMappingsSort sort) {
            this.sort = sort;
            return this;
        }

        public ListAuthNMappingsOptionalParameters filter(String filter) {
            this.filter = filter;
            return this;
        }
    }
}

