/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.PowerpackGroupWidget;
import com.datadog.api.client.v2.model.PowerpackTemplateVariable;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "group_widget", "name", "tags", "template_variables"})
public class PowerpackAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_GROUP_WIDGET = "group_widget";
    private PowerpackGroupWidget groupWidget;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private List<String> tags = null;
    public static final String JSON_PROPERTY_TEMPLATE_VARIABLES = "template_variables";
    private List<PowerpackTemplateVariable> templateVariables = null;
    private Map<String, Object> additionalProperties;

    public PowerpackAttributes() {
    }

    @JsonCreator
    public PowerpackAttributes(@JsonProperty(required=true, value="group_widget") PowerpackGroupWidget groupWidget, @JsonProperty(required=true, value="name") String name) {
        this.groupWidget = groupWidget;
        this.unparsed |= groupWidget.unparsed;
        this.name = name;
    }

    public PowerpackAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public PowerpackAttributes groupWidget(PowerpackGroupWidget groupWidget) {
        this.groupWidget = groupWidget;
        this.unparsed |= groupWidget.unparsed;
        return this;
    }

    @JsonProperty(value="group_widget")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PowerpackGroupWidget getGroupWidget() {
        return this.groupWidget;
    }

    public void setGroupWidget(PowerpackGroupWidget groupWidget) {
        this.groupWidget = groupWidget;
    }

    public PowerpackAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PowerpackAttributes tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public PowerpackAttributes addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public PowerpackAttributes templateVariables(List<PowerpackTemplateVariable> templateVariables) {
        this.templateVariables = templateVariables;
        for (PowerpackTemplateVariable item : templateVariables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public PowerpackAttributes addTemplateVariablesItem(PowerpackTemplateVariable templateVariablesItem) {
        if (this.templateVariables == null) {
            this.templateVariables = new ArrayList<PowerpackTemplateVariable>();
        }
        this.templateVariables.add(templateVariablesItem);
        this.unparsed |= templateVariablesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="template_variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PowerpackTemplateVariable> getTemplateVariables() {
        return this.templateVariables;
    }

    public void setTemplateVariables(List<PowerpackTemplateVariable> templateVariables) {
        this.templateVariables = templateVariables;
    }

    @JsonAnySetter
    public PowerpackAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PowerpackAttributes powerpackAttributes = (PowerpackAttributes)o;
        return Objects.equals(this.description, powerpackAttributes.description) && Objects.equals(this.groupWidget, powerpackAttributes.groupWidget) && Objects.equals(this.name, powerpackAttributes.name) && Objects.equals(this.tags, powerpackAttributes.tags) && Objects.equals(this.templateVariables, powerpackAttributes.templateVariables) && Objects.equals(this.additionalProperties, powerpackAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.groupWidget, this.name, this.tags, this.templateVariables, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PowerpackAttributes {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    groupWidget: ").append(this.toIndentedString(this.groupWidget)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    templateVariables: ").append(this.toIndentedString(this.templateVariables)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

