/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.cache;

import datadog.trace.bootstrap.instrumentation.api.Function;
import datadog.trace.bootstrap.instrumentation.cache.DDCache;

final class FixedSizeCache<K, V>
implements DDCache<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    private final int mask;
    private final Node<K, V>[] elements;

    public FixedSizeCache(int capacity) {
        int n;
        if (capacity <= 0) {
            throw new IllegalArgumentException("Cache capacity must be > 0");
        }
        if (capacity > 0x40000000) {
            capacity = 0x40000000;
        }
        n = (n = -1 >>> Integer.numberOfLeadingZeros(capacity - 1)) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
        Node[] lmnts = new Node[n];
        this.elements = lmnts;
        this.mask = n - 1;
    }

    @Override
    public V computeIfAbsent(K key, Function<K, ? extends V> creator) {
        Object value;
        if (key == null) {
            return null;
        }
        int h = key.hashCode();
        int firstPos = h & this.mask;
        int i = 1;
        while (true) {
            int pos;
            Node<K, V> current;
            if ((current = this.elements[pos = h & this.mask]) == null) {
                value = this.createAndStoreValue(key, creator, pos);
                break;
            }
            if (key.equals(((Node)current).key)) {
                value = ((Node)current).value;
                break;
            }
            if (i == 3) {
                value = this.createAndStoreValue(key, creator, firstPos);
                break;
            }
            h = this.rehash(h);
            ++i;
        }
        return value;
    }

    private V createAndStoreValue(K key, Function<K, ? extends V> creator, int pos) {
        V value = creator.apply(key);
        Node node = new Node(key, value);
        this.elements[pos] = node;
        return value;
    }

    private int rehash(int v) {
        int h = v * -1640532531;
        h = Integer.reverseBytes(h);
        return h * -1640532531;
    }

    private static final class Node<K, V> {
        private final K key;
        private final V value;

        private Node(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

