/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.cache;

import java.util.concurrent.atomic.AtomicReferenceArray;

public final class RadixTreeBoxCache {
    public static final RadixTreeBoxCache HTTP_STATUSES = new RadixTreeBoxCache(16, 32, 200, 201, 301, 307, 400, 401, 403, 404, 500, 502, 503);
    public static final RadixTreeBoxCache PORTS = new RadixTreeBoxCache(256, 256, 80, 443, 8080);
    private final int level1;
    private final int level2;
    private final int shift;
    private final int mask;
    private final AtomicReferenceArray<Integer[]> tree;

    RadixTreeBoxCache(int level1, int level2, int ... commonValues) {
        assert (Integer.bitCount(level1) == 1 && Integer.bitCount(level2) == 1 && level1 > 0 && level2 > 0);
        this.tree = new AtomicReferenceArray(level1);
        this.level1 = level1;
        this.level2 = level2;
        this.mask = level2 - 1;
        this.shift = Integer.bitCount(this.mask);
        for (int commonValue : commonValues) {
            this.box(commonValue);
        }
    }

    public Integer box(int primitive) {
        int prefix = primitive >>> this.shift;
        if (prefix >= this.level1) {
            return primitive;
        }
        return this.boxIfNecessary(prefix, primitive);
    }

    private Integer boxIfNecessary(int prefix, int primitive) {
        int suffix;
        Integer boxed;
        Integer[] page = this.tree.get(prefix);
        if (null == page && !this.tree.compareAndSet(prefix, null, page = new Integer[this.level2])) {
            page = this.tree.get(prefix);
        }
        if ((boxed = page[suffix = primitive & this.mask]) == null) {
            boxed = page[suffix] = Integer.valueOf(primitive);
        }
        return boxed;
    }
}

