/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.cache.RadixTreeBoxCache;
import datadog.trace.bootstrap.instrumentation.decorator.ClientDecorator;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class HttpClientDecorator<REQUEST, RESPONSE>
extends ClientDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpClientDecorator.class);

    protected abstract String method(REQUEST var1);

    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    protected abstract int status(RESPONSE var1);

    @Override
    protected String spanType() {
        return "http";
    }

    @Override
    protected String service() {
        return null;
    }

    public AgentSpan onRequest(AgentSpan span, REQUEST request) {
        assert (span != null);
        if (request != null) {
            span.setTag("http.method", this.method(request));
            try {
                URI url = this.url(request);
                if (url != null) {
                    String path;
                    StringBuilder urlNoParams = new StringBuilder();
                    if (url.getScheme() != null) {
                        urlNoParams.append(url.getScheme());
                        urlNoParams.append("://");
                    }
                    if (url.getHost() != null) {
                        urlNoParams.append(url.getHost());
                        span.setTag("peer.hostname", url.getHost());
                        if (Config.get().isHttpClientSplitByDomain()) {
                            span.setTag("service.name", url.getHost());
                        }
                        if (url.getPort() > 0) {
                            span.setTag("peer.port", url.getPort());
                            if (url.getPort() != 80 && url.getPort() != 443) {
                                urlNoParams.append(":");
                                urlNoParams.append(url.getPort());
                            }
                        }
                    }
                    if ((path = url.getPath()).isEmpty()) {
                        urlNoParams.append("/");
                    } else {
                        urlNoParams.append(path);
                    }
                    span.setTag("http.url", urlNoParams.toString());
                    if (Config.get().isHttpClientTagQueryString()) {
                        span.setTag("http.query.string", url.getQuery());
                        span.setTag("http.fragment.string", url.getFragment());
                    }
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
        }
        return span;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        int status;
        assert (span != null);
        if (response != null && (status = this.status(response)) != 0) {
            span.setTag("http.status_code", RadixTreeBoxCache.HTTP_STATUSES.box(status));
        }
        return span;
    }
}

