/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.decorator.BaseDecorator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class TestDecorator
extends BaseDecorator {
    private static final Logger log = LoggerFactory.getLogger(TestDecorator.class);
    public static final String TEST_PASS = "pass";
    public static final String TEST_FAIL = "fail";
    public static final String TEST_SKIP = "skip";
    public static final String JENKINS = "JENKINS_URL";
    static final String JENKINS_PROVIDER_NAME = "jenkins";
    static final String JENKINS_PIPELINE_ID = "BUILD_TAG";
    static final String JENKINS_PIPELINE_NUMBER = "BUILD_NUMBER";
    static final String JENKINS_PIPELINE_URL = "BUILD_URL";
    static final String JENKINS_JOB_URL = "JOB_URL";
    static final String JENKINS_WORKSPACE_PATH = "WORKSPACE";
    static final String JENKINS_GIT_REPOSITORY_URL = "GIT_URL";
    static final String JENKINS_GIT_COMMIT = "GIT_COMMIT";
    static final String JENKINS_GIT_BRANCH = "GIT_BRANCH";
    public static final String GITLAB = "GITLAB_CI";
    static final String GITLAB_PROVIDER_NAME = "gitlab";
    static final String GITLAB_PIPELINE_ID = "CI_PIPELINE_ID";
    static final String GITLAB_PIPELINE_NUMBER = "CI_PIPELINE_IID";
    static final String GITLAB_PIPELINE_URL = "CI_PIPELINE_URL";
    static final String GITLAB_JOB_URL = "CI_JOB_URL";
    static final String GITLAB_WORKSPACE_PATH = "CI_PROJECT_DIR";
    static final String GITLAB_GIT_REPOSITORY_URL = "CI_REPOSITORY_URL";
    static final String GITLAB_GIT_COMMIT = "CI_COMMIT_SHA";
    static final String GITLAB_GIT_BRANCH = "CI_COMMIT_BRANCH";
    static final String GITLAB_GIT_TAG = "CI_COMMIT_TAG";
    private boolean isCI;
    private String ciProviderName;
    private String ciPipelineId;
    private String ciPipelineNumber;
    private String ciPipelineUrl;
    private String ciJobUrl;
    private String ciWorkspacePath;
    private String gitRepositoryUrl;
    private String gitCommit;
    private String gitBranch;
    private String gitTag;

    public TestDecorator() {
        if (System.getenv(JENKINS) != null) {
            this.setJenkinsData();
        } else if (System.getenv(GITLAB) != null) {
            this.setGitLabData();
        }
    }

    protected abstract String testFramework();

    protected String spanKind() {
        return "test";
    }

    @Override
    protected String spanType() {
        return "test";
    }

    @Override
    public AgentSpan afterStart(AgentSpan span) {
        assert (span != null);
        span.setTag("span.kind", this.spanKind());
        span.setTag("span.type", this.spanType());
        span.setTag("test.framework", this.testFramework());
        span.setTag("ci.provider.name", this.ciProviderName);
        span.setTag("ci.pipeline.id", this.ciPipelineId);
        span.setTag("ci.pipeline.number", this.ciPipelineNumber);
        span.setTag("ci.pipeline.url", this.ciPipelineUrl);
        span.setTag("ci.job.url", this.ciJobUrl);
        span.setTag("ci.workspace_path", this.ciWorkspacePath);
        span.setTag("git.repository_url", this.gitRepositoryUrl);
        span.setTag("git.commit_sha", this.gitCommit);
        span.setTag("git.branch", this.normalizeRef(this.gitBranch));
        span.setTag("git.tag", this.normalizeRef(this.gitTag));
        return super.afterStart(span);
    }

    private void setJenkinsData() {
        this.isCI = true;
        this.ciProviderName = JENKINS_PROVIDER_NAME;
        this.ciPipelineId = System.getenv(JENKINS_PIPELINE_ID);
        this.ciPipelineNumber = System.getenv(JENKINS_PIPELINE_NUMBER);
        this.ciPipelineUrl = System.getenv(JENKINS_PIPELINE_URL);
        this.ciJobUrl = System.getenv(JENKINS_JOB_URL);
        this.ciWorkspacePath = System.getenv(JENKINS_WORKSPACE_PATH);
        this.gitRepositoryUrl = System.getenv(JENKINS_GIT_REPOSITORY_URL);
        this.gitCommit = System.getenv(JENKINS_GIT_COMMIT);
        String gitBranchOrTag = System.getenv(JENKINS_GIT_BRANCH);
        if (gitBranchOrTag != null) {
            if (gitBranchOrTag.contains("tags")) {
                this.gitTag = gitBranchOrTag;
            } else {
                this.gitBranch = gitBranchOrTag;
            }
        }
    }

    private void setGitLabData() {
        this.isCI = true;
        this.ciProviderName = GITLAB_PROVIDER_NAME;
        this.ciPipelineId = System.getenv(GITLAB_PIPELINE_ID);
        this.ciPipelineNumber = System.getenv(GITLAB_PIPELINE_NUMBER);
        this.ciPipelineUrl = System.getenv(GITLAB_PIPELINE_URL);
        this.ciJobUrl = System.getenv(GITLAB_JOB_URL);
        this.ciWorkspacePath = System.getenv(GITLAB_WORKSPACE_PATH);
        this.gitRepositoryUrl = System.getenv(GITLAB_GIT_REPOSITORY_URL);
        this.gitCommit = System.getenv(GITLAB_GIT_COMMIT);
        this.gitBranch = System.getenv(GITLAB_GIT_BRANCH);
        this.gitTag = System.getenv(GITLAB_GIT_TAG);
    }

    private String normalizeRef(String rawRef) {
        if (rawRef == null || rawRef.isEmpty()) {
            return rawRef;
        }
        String ref = rawRef;
        if (ref.startsWith("origin")) {
            ref = ref.replace("origin/", "");
        } else if (ref.startsWith("refs/heads")) {
            ref = ref.replace("refs/heads/", "");
        }
        if (ref.startsWith("tags")) {
            return ref.replace("tags/", "");
        }
        return ref;
    }

    public List<String> testNames(Class<?> testClass, Class<? extends Annotation> testAnnotation) {
        Method[] methods;
        ArrayList<String> testNames = new ArrayList<String>();
        for (Method method : methods = testClass.getMethods()) {
            if (method.getAnnotation(testAnnotation) == null) continue;
            testNames.add(method.getName());
        }
        return testNames;
    }

    public boolean isCI() {
        return this.isCI;
    }

    public String getCiProviderName() {
        return this.ciProviderName;
    }

    public String getCiPipelineId() {
        return this.ciPipelineId;
    }

    public String getCiPipelineNumber() {
        return this.ciPipelineNumber;
    }

    public String getCiPipelineUrl() {
        return this.ciPipelineUrl;
    }

    public String getCiJobUrl() {
        return this.ciJobUrl;
    }

    public String getCiWorkspacePath() {
        return this.ciWorkspacePath;
    }

    public String getGitRepositoryUrl() {
        return this.gitRepositoryUrl;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public String getGitTag() {
        return this.gitTag;
    }
}

