/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.WeakMap;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.java.concurrent.CallableWrapper;
import datadog.trace.bootstrap.instrumentation.java.concurrent.RunnableWrapper;
import datadog.trace.bootstrap.instrumentation.java.concurrent.State;
import datadog.trace.context.TraceScope;
import java.util.concurrent.Executor;

public class ExecutorInstrumentationUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorInstrumentationUtils.class);
    private static final WeakMap<Executor, Boolean> EXECUTORS_DISABLED_FOR_WRAPPED_TASKS = WeakMap.Provider.newWeakMap();

    public static boolean shouldAttachStateToTask(Object task, Executor executor) {
        if (task == null) {
            return false;
        }
        TraceScope scope = AgentTracer.activeScope();
        Class<?> enclosingClass = task.getClass().getEnclosingClass();
        return scope != null && scope.isAsyncPropagating() && !ExecutorInstrumentationUtils.isExecutorDisabledForThisTask(executor, task) && (enclosingClass == null || !enclosingClass.getName().equals("io.netty.util.concurrent.SingleThreadEventExecutor"));
    }

    public static <T> State setupState(ContextStore<T, State> contextStore, T task, TraceScope scope) {
        TraceScope.Continuation continuation;
        State state = contextStore.putIfAbsent(task, State.FACTORY);
        if (state.setContinuation(continuation = scope.capture())) {
            if (log.isDebugEnabled()) {
                log.debug("created continuation {} from scope {}, state: {}", continuation, scope, state);
            }
        } else {
            continuation.cancel();
        }
        return state;
    }

    public static void cleanUpOnMethodExit(Executor executor, State state, Throwable throwable) {
        if (null != state && null != throwable) {
            state.closeContinuation();
        }
    }

    public static void disableExecutorForWrappedTasks(Executor executor) {
        log.debug("Disabling Executor tracing for wrapped tasks for instance {}", (Object)executor);
        EXECUTORS_DISABLED_FOR_WRAPPED_TASKS.put(executor, true);
    }

    public static boolean isExecutorDisabledForThisTask(Executor executor, Object task) {
        return (task instanceof RunnableWrapper || task instanceof CallableWrapper) && EXECUTORS_DISABLED_FOR_WRAPPED_TASKS.containsKey(executor);
    }
}

