/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.internal.util.LongStringUtils;

public class DD64bTraceId
extends DDTraceId {
    public static final DD64bTraceId MAX = new DD64bTraceId(-1L, "18446744073709551615");
    private final long id;
    private String str;
    private String hexStr;

    DD64bTraceId(long id, String str) {
        this.id = id;
        this.str = str;
    }

    public static DD64bTraceId from(long id) {
        return DD64bTraceId.create(id, null);
    }

    public static DD64bTraceId from(String s) throws NumberFormatException {
        return DD64bTraceId.create(LongStringUtils.parseUnsignedLong(s), s);
    }

    public static DD64bTraceId fromHex(String s) throws NumberFormatException {
        return DD64bTraceId.create(LongStringUtils.parseUnsignedLongHex(s), null);
    }

    static DD64bTraceId create(long id, String str) {
        if (id == 0L && ZERO != null) {
            return (DD64bTraceId)ZERO;
        }
        if (id == -1L) {
            return MAX;
        }
        return new DD64bTraceId(id, str);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DD64bTraceId)) {
            return false;
        }
        DD64bTraceId ddId = (DD64bTraceId)o;
        return this.id == ddId.id;
    }

    public int hashCode() {
        long id = this.id;
        return (int)(id ^ id >>> 32);
    }

    @Override
    public String toString() {
        String s = this.str;
        if (s == null) {
            this.str = s = Long.toUnsignedString(this.id);
        }
        return s;
    }

    @Override
    public String toHexString() {
        String hexStr = this.hexStr;
        if (hexStr == null) {
            this.hexStr = hexStr = LongStringUtils.toHexStringPadded(this.id, 32);
        }
        return hexStr;
    }

    @Override
    public String toHexStringPadded(int size) {
        if (size > 16) {
            return this.toHexString();
        }
        return LongStringUtils.toHexStringPadded(this.id, size);
    }

    @Override
    public long toLong() {
        return this.id;
    }

    @Override
    public long toHighOrderLong() {
        return 0L;
    }
}

