/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.squareup.moshi;

import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.JsonDataException;
import ddtrot.com.squareup.moshi.JsonReader;
import ddtrot.com.squareup.moshi.JsonWriter;
import ddtrot.com.squareup.moshi.LinkedHashTreeMap;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class MapJsonAdapter<K, V>
extends JsonAdapter<Map<K, V>> {
    public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

        @Override
        @Nullable
        public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
            if (!annotations.isEmpty()) {
                return null;
            }
            Class<?> rawType = Types.getRawType(type);
            if (rawType != Map.class) {
                return null;
            }
            Type[] keyAndValue = Types.mapKeyAndValueTypes(type, rawType);
            return new MapJsonAdapter(moshi, keyAndValue[0], keyAndValue[1]).nullSafe();
        }
    };
    private final JsonAdapter<K> keyAdapter;
    private final JsonAdapter<V> valueAdapter;

    MapJsonAdapter(Moshi moshi, Type keyType, Type valueType) {
        this.keyAdapter = moshi.adapter(keyType);
        this.valueAdapter = moshi.adapter(valueType);
    }

    @Override
    public void toJson(JsonWriter writer, Map<K, V> map) throws IOException {
        writer.beginObject();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new JsonDataException("Map key is null at " + writer.getPath());
            }
            writer.promoteValueToName();
            this.keyAdapter.toJson(writer, entry.getKey());
            this.valueAdapter.toJson(writer, entry.getValue());
        }
        writer.endObject();
    }

    @Override
    public Map<K, V> fromJson(JsonReader reader) throws IOException {
        LinkedHashTreeMap<K, V> result = new LinkedHashTreeMap<K, V>();
        reader.beginObject();
        while (reader.hasNext()) {
            V value;
            reader.promoteNameToValue();
            K name = this.keyAdapter.fromJson(reader);
            Object replaced = result.put(name, value = this.valueAdapter.fromJson(reader));
            if (replaced == null) continue;
            throw new JsonDataException("Map key '" + name + "' has multiple values at path " + reader.getPath() + ": " + replaced + " and " + value);
        }
        reader.endObject();
        return result;
    }

    public String toString() {
        return "JsonAdapter(" + this.keyAdapter + "=" + this.valueAdapter + ")";
    }
}

