/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast;

import ddtrot.dd.trace.api.iast.IastModule;
import ddtrot.dd.trace.api.iast.propagation.CodecModule;
import ddtrot.dd.trace.api.iast.propagation.PropagationModule;
import ddtrot.dd.trace.api.iast.propagation.StringModule;
import ddtrot.dd.trace.api.iast.sink.ApplicationModule;
import ddtrot.dd.trace.api.iast.sink.CommandInjectionModule;
import ddtrot.dd.trace.api.iast.sink.HardcodedSecretModule;
import ddtrot.dd.trace.api.iast.sink.HeaderInjectionModule;
import ddtrot.dd.trace.api.iast.sink.HstsMissingHeaderModule;
import ddtrot.dd.trace.api.iast.sink.HttpResponseHeaderModule;
import ddtrot.dd.trace.api.iast.sink.InsecureAuthProtocolModule;
import ddtrot.dd.trace.api.iast.sink.InsecureCookieModule;
import ddtrot.dd.trace.api.iast.sink.LdapInjectionModule;
import ddtrot.dd.trace.api.iast.sink.NoHttpOnlyCookieModule;
import ddtrot.dd.trace.api.iast.sink.NoSameSiteCookieModule;
import ddtrot.dd.trace.api.iast.sink.PathTraversalModule;
import ddtrot.dd.trace.api.iast.sink.ReflectionInjectionModule;
import ddtrot.dd.trace.api.iast.sink.SqlInjectionModule;
import ddtrot.dd.trace.api.iast.sink.SsrfModule;
import ddtrot.dd.trace.api.iast.sink.StacktraceLeakModule;
import ddtrot.dd.trace.api.iast.sink.TrustBoundaryViolationModule;
import ddtrot.dd.trace.api.iast.sink.UntrustedDeserializationModule;
import ddtrot.dd.trace.api.iast.sink.UnvalidatedRedirectModule;
import ddtrot.dd.trace.api.iast.sink.WeakCipherModule;
import ddtrot.dd.trace.api.iast.sink.WeakHashModule;
import ddtrot.dd.trace.api.iast.sink.WeakRandomnessModule;
import ddtrot.dd.trace.api.iast.sink.XContentTypeModule;
import ddtrot.dd.trace.api.iast.sink.XPathInjectionModule;
import ddtrot.dd.trace.api.iast.sink.XssModule;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class InstrumentationBridge {
    public static StringModule STRING;
    public static CodecModule CODEC;
    public static SqlInjectionModule SQL_INJECTION;
    public static PathTraversalModule PATH_TRAVERSAL;
    public static CommandInjectionModule COMMAND_INJECTION;
    public static WeakCipherModule WEAK_CIPHER;
    public static WeakHashModule WEAK_HASH;
    public static LdapInjectionModule LDAP_INJECTION;
    public static PropagationModule PROPAGATION;
    public static InsecureCookieModule<?> INSECURE_COOKIE;
    public static NoHttpOnlyCookieModule<?> NO_HTTPONLY_COOKIE;
    public static NoSameSiteCookieModule<?> NO_SAMESITE_COOKIE;
    public static SsrfModule SSRF;
    public static UnvalidatedRedirectModule UNVALIDATED_REDIRECT;
    public static WeakRandomnessModule WEAK_RANDOMNESS;
    public static HttpResponseHeaderModule RESPONSE_HEADER_MODULE;
    public static HstsMissingHeaderModule HSTS_MISSING_HEADER_MODULE;
    public static XContentTypeModule X_CONTENT_TYPE_HEADER_MODULE;
    public static TrustBoundaryViolationModule TRUST_BOUNDARY_VIOLATION;
    public static XPathInjectionModule XPATH_INJECTION;
    public static XssModule XSS;
    public static StacktraceLeakModule STACKTRACE_LEAK_MODULE;
    public static HeaderInjectionModule HEADER_INJECTION;
    public static ApplicationModule APPLICATION;
    public static HardcodedSecretModule HARDCODED_SECRET;
    public static InsecureAuthProtocolModule INSECURE_AUTH_PROTOCOL;
    public static ReflectionInjectionModule REFLECTION_INJECTION;
    public static UntrustedDeserializationModule UNTRUSTED_DESERIALIZATION;
    private static final Map<Class<? extends IastModule>, Field> MODULE_MAP;

    private InstrumentationBridge() {
    }

    public static void registerIastModule(IastModule module) {
        Class<? extends IastModule> type = InstrumentationBridge.getType(module.getClass());
        Field field = MODULE_MAP.get(type);
        if (field == null) {
            throw new UnsupportedOperationException("Module not yet supported: " + module.getClass());
        }
        InstrumentationBridge.set(field, module);
    }

    static <M extends IastModule> M getIastModule(Class<M> type) {
        Field field = MODULE_MAP.get(type);
        if (field == null) {
            throw new UnsupportedOperationException("Module not yet supported: " + type);
        }
        return InstrumentationBridge.get(field);
    }

    static void clearIastModules() {
        MODULE_MAP.values().forEach(it -> InstrumentationBridge.set(it, null));
    }

    static Set<Class<? extends IastModule>> getIastModules() {
        return MODULE_MAP.keySet();
    }

    private static Class<? extends IastModule> getType(Class<?> module) {
        if (module == null) {
            return null;
        }
        for (Class<?> ifc : module.getInterfaces()) {
            if (!IastModule.class.isAssignableFrom(ifc)) continue;
            return ifc;
        }
        return InstrumentationBridge.getType(module.getSuperclass());
    }

    private static <M extends IastModule> M get(Field field) {
        try {
            return (M)((IastModule)field.get(null));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void set(Field field, IastModule module) {
        try {
            field.set(null, module);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<Class<? extends IastModule>, Field> buildModuleMap() {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : InstrumentationBridge.class.getDeclaredFields()) {
            Class<?> module = field.getType();
            int modifiers = field.getModifiers();
            if (!module.isInterface() || !Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !IastModule.class.isAssignableFrom(module)) continue;
            fields.add(field);
        }
        HashMap<Class<? extends IastModule>, Field> result = new HashMap<Class<? extends IastModule>, Field>(fields.size());
        for (Field field : fields) {
            field.setAccessible(true);
            result.put(field.getType(), field);
        }
        return result;
    }

    static {
        MODULE_MAP = InstrumentationBridge.buildModuleMap();
    }
}

