/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider;

import datadog.trace.api.ConfigCollector;
import datadog.trace.api.ConfigOrigin;
import ddtrot.dd.trace.bootstrap.config.provider.CapturedEnvironmentConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.ConfigConverter;
import ddtrot.dd.trace.bootstrap.config.provider.EnvironmentConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.OtelEnvironmentConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.PropertiesConfigSource;
import ddtrot.dd.trace.bootstrap.config.provider.SystemPropertiesConfigSource;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfigProvider.class);
    private final boolean collectConfig;
    private final Source[] sources;

    private ConfigProvider(Source ... sources) {
        this(true, sources);
    }

    private ConfigProvider(boolean collectConfig, Source ... sources) {
        this.collectConfig = collectConfig;
        this.sources = sources;
    }

    public String getConfigFileStatus() {
        for (Source source : this.sources) {
            String configFileStatus;
            if (!(source instanceof PropertiesConfigSource) || null == (configFileStatus = ((PropertiesConfigSource)source).getConfigFileStatus())) continue;
            return configFileStatus;
        }
        return "no config file present";
    }

    public String getString(String key) {
        return this.getString(key, null, new String[0]);
    }

    public <T extends Enum<T>> T getEnum(String key, Class<T> enumType, T defaultValue) {
        String value = this.getString(key);
        if (null != value) {
            try {
                return Enum.valueOf(enumType, value);
            }
            catch (Exception ignoreAndUseDefault) {
                log.debug("failed to parse {} for {}, defaulting to {}", new Object[]{value, key, defaultValue});
            }
        }
        if (this.collectConfig) {
            String valueStr = defaultValue == null ? null : defaultValue.name();
            ConfigCollector.get().put(key, valueStr, ConfigOrigin.DEFAULT);
        }
        return defaultValue;
    }

    public String getString(String key, String defaultValue, String ... aliases) {
        for (Source source : this.sources) {
            String value = source.get(key, aliases);
            if (value == null) continue;
            if (this.collectConfig) {
                ConfigCollector.get().put(key, value, source.origin());
            }
            return value;
        }
        if (this.collectConfig) {
            ConfigCollector.get().put(key, defaultValue, ConfigOrigin.DEFAULT);
        }
        return defaultValue;
    }

    public String getStringNotEmpty(String key, String defaultValue, String ... aliases) {
        for (Source source : this.sources) {
            String value = source.get(key, aliases);
            if (value == null || value.trim().isEmpty()) continue;
            if (this.collectConfig) {
                ConfigCollector.get().put(key, value, source.origin());
            }
            return value;
        }
        if (this.collectConfig) {
            ConfigCollector.get().put(key, defaultValue, ConfigOrigin.DEFAULT);
        }
        return defaultValue;
    }

    public String getStringExcludingSource(String key, String defaultValue, Class<? extends Source> excludedSource, String ... aliases) {
        for (Source source : this.sources) {
            String value;
            if (excludedSource.isAssignableFrom(source.getClass()) || (value = source.get(key, aliases)) == null) continue;
            if (this.collectConfig) {
                ConfigCollector.get().put(key, value, source.origin());
            }
            return value;
        }
        if (this.collectConfig) {
            ConfigCollector.get().put(key, defaultValue, ConfigOrigin.DEFAULT);
        }
        return defaultValue;
    }

    public boolean isSet(String key) {
        String value = this.getString(key);
        return value != null && !value.isEmpty();
    }

    public Boolean getBoolean(String key) {
        return this.get(key, null, Boolean.class, new String[0]);
    }

    public Boolean getBoolean(String key, String ... aliases) {
        return this.get(key, null, Boolean.class, aliases);
    }

    public boolean getBoolean(String key, boolean defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Boolean.class, aliases);
    }

    public Integer getInteger(String key) {
        return this.get(key, null, Integer.class, new String[0]);
    }

    public Integer getInteger(String key, String ... aliases) {
        return this.get(key, null, Integer.class, aliases);
    }

    public int getInteger(String key, int defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Integer.class, aliases);
    }

    public Long getLong(String key) {
        return this.get(key, null, Long.class, new String[0]);
    }

    public Long getLong(String key, String ... aliases) {
        return this.get(key, null, Long.class, aliases);
    }

    public long getLong(String key, long defaultValue, String ... aliases) {
        return this.get(key, defaultValue, Long.class, aliases);
    }

    public Float getFloat(String key, String ... aliases) {
        return this.get(key, null, Float.class, aliases);
    }

    public float getFloat(String key, float defaultValue) {
        return this.get(key, Float.valueOf(defaultValue), Float.class, new String[0]).floatValue();
    }

    public Double getDouble(String key) {
        return this.get(key, null, Double.class, new String[0]);
    }

    public double getDouble(String key, double defaultValue) {
        return this.get(key, defaultValue, Double.class, new String[0]);
    }

    private <T> T get(String key, T defaultValue, Class<T> type, String ... aliases) {
        for (Source source : this.sources) {
            try {
                String sourceValue = source.get(key, aliases);
                T value = ConfigConverter.valueOf(sourceValue, type);
                if (value == null) continue;
                if (this.collectConfig) {
                    ConfigCollector.get().put(key, sourceValue, source.origin());
                }
                return value;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.collectConfig) {
            ConfigCollector.get().put(key, defaultValue, ConfigOrigin.DEFAULT);
        }
        return defaultValue;
    }

    public List<String> getList(String key) {
        return ConfigConverter.parseList(this.getString(key));
    }

    public List<String> getList(String key, List<String> defaultValue) {
        String list = this.getString(key);
        if (null == list) {
            if (this.collectConfig) {
                ConfigCollector.get().put(key, defaultValue, ConfigOrigin.DEFAULT);
            }
            return defaultValue;
        }
        return ConfigConverter.parseList(this.getString(key));
    }

    public Set<String> getSet(String key, Set<String> defaultValue) {
        String list = this.getString(key);
        if (null == list) {
            if (this.collectConfig) {
                ConfigCollector.get().put(key, defaultValue, ConfigOrigin.DEFAULT);
            }
            return defaultValue;
        }
        return new HashSet<String>(ConfigConverter.parseList(this.getString(key)));
    }

    public List<String> getSpacedList(String key) {
        return ConfigConverter.parseList(this.getString(key), " ");
    }

    public Map<String, String> getMergedMap(String key, String ... aliases) {
        HashMap<String, String> merged = new HashMap<String, String>();
        ConfigOrigin origin = ConfigOrigin.DEFAULT;
        for (int i = this.sources.length - 1; 0 <= i; --i) {
            String value = this.sources[i].get(key, aliases);
            Map<String, String> parsedMap = ConfigConverter.parseMap(value, key);
            if (!parsedMap.isEmpty()) {
                origin = this.sources[i].origin();
            }
            merged.putAll(parsedMap);
        }
        if (this.collectConfig) {
            ConfigCollector.get().put(key, merged, origin);
        }
        return merged;
    }

    public Map<String, String> getOrderedMap(String key) {
        LinkedHashMap<String, String> merged = new LinkedHashMap<String, String>();
        ConfigOrigin origin = ConfigOrigin.DEFAULT;
        for (int i = this.sources.length - 1; 0 <= i; --i) {
            String value = this.sources[i].get(key);
            Map<String, String> parsedMap = ConfigConverter.parseOrderedMap(value, key);
            if (!parsedMap.isEmpty()) {
                origin = this.sources[i].origin();
            }
            merged.putAll(parsedMap);
        }
        if (this.collectConfig) {
            ConfigCollector.get().put(key, merged, origin);
        }
        return merged;
    }

    public Map<String, String> getMergedMapWithOptionalMappings(String defaultPrefix, boolean lowercaseKeys, String ... keys) {
        HashMap<String, String> merged = new HashMap<String, String>();
        ConfigOrigin origin = ConfigOrigin.DEFAULT;
        for (String key : keys) {
            for (int i = this.sources.length - 1; 0 <= i; --i) {
                String value = this.sources[i].get(key);
                Map<String, String> parsedMap = ConfigConverter.parseMapWithOptionalMappings(value, key, defaultPrefix, lowercaseKeys);
                if (!parsedMap.isEmpty()) {
                    origin = this.sources[i].origin();
                }
                merged.putAll(parsedMap);
            }
            if (!this.collectConfig) continue;
            ConfigCollector.get().put(key, merged, origin);
        }
        return merged;
    }

    public BitSet getIntegerRange(String key, BitSet defaultValue) {
        String value = this.getString(key);
        try {
            if (value != null) {
                return ConfigConverter.parseIntegerRangeSet(value, key);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Invalid configuration for {}", (Object)key, (Object)e);
        }
        if (this.collectConfig) {
            ConfigCollector.get().put(key, defaultValue, ConfigOrigin.DEFAULT);
        }
        return defaultValue;
    }

    public boolean isEnabled(Iterable<String> settingNames, String settingPrefix, String settingSuffix, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : settingNames) {
            String configKey = settingPrefix + name + settingSuffix;
            String fullKey = configKey.startsWith("trace.") ? configKey : "trace." + configKey;
            boolean configEnabled = this.getBoolean(fullKey, defaultEnabled, configKey);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public static ConfigProvider getInstance() {
        return Singleton.INSTANCE;
    }

    public static ConfigProvider createDefault() {
        Properties configProperties = ConfigProvider.loadConfigurationFile(new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource()));
        if (configProperties.isEmpty()) {
            return new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), new OtelEnvironmentConfigSource(), new CapturedEnvironmentConfigSource());
        }
        return new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), new PropertiesConfigSource(configProperties, true), new OtelEnvironmentConfigSource(configProperties), new CapturedEnvironmentConfigSource());
    }

    public static ConfigProvider withoutCollector() {
        Properties configProperties = ConfigProvider.loadConfigurationFile(new ConfigProvider(false, new SystemPropertiesConfigSource(), new EnvironmentConfigSource()));
        if (configProperties.isEmpty()) {
            return new ConfigProvider(false, new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), new OtelEnvironmentConfigSource(), new CapturedEnvironmentConfigSource());
        }
        return new ConfigProvider(false, new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), new PropertiesConfigSource(configProperties, true), new OtelEnvironmentConfigSource(configProperties), new CapturedEnvironmentConfigSource());
    }

    public static ConfigProvider withPropertiesOverride(Properties properties) {
        PropertiesConfigSource providedConfigSource = new PropertiesConfigSource(properties, false);
        Properties configProperties = ConfigProvider.loadConfigurationFile(new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), providedConfigSource));
        if (configProperties.isEmpty()) {
            return new ConfigProvider(new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), providedConfigSource, new OtelEnvironmentConfigSource(), new CapturedEnvironmentConfigSource());
        }
        return new ConfigProvider(providedConfigSource, new SystemPropertiesConfigSource(), new EnvironmentConfigSource(), new PropertiesConfigSource(configProperties, true), new OtelEnvironmentConfigSource(configProperties), new CapturedEnvironmentConfigSource());
    }

    @SuppressForbidden
    private static Properties loadConfigurationFile(ConfigProvider configProvider) {
        Properties properties = new Properties();
        String configurationFilePath = configProvider.getString("trace.config");
        if (null == configurationFilePath) {
            return properties;
        }
        File configurationFile = new File(configurationFilePath = configurationFilePath.replaceFirst("^~", System.getProperty("user.home")));
        if (!configurationFile.exists()) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
            return properties;
        }
        try (FileReader fileReader = new FileReader(configurationFile);){
            properties.load(fileReader);
        }
        catch (FileNotFoundException fnf) {
            log.error("Configuration file '{}' not found.", (Object)configurationFilePath);
        }
        catch (IOException ioe) {
            log.error("Configuration file '{}' cannot be accessed or correctly parsed.", (Object)configurationFilePath);
        }
        properties.setProperty("_dd.config.file.status", configurationFilePath);
        return properties;
    }

    public static abstract class Source {
        public final String get(String key, String ... aliases) {
            String value = this.get(key);
            if (value != null) {
                return value;
            }
            for (String alias : aliases) {
                value = this.get(alias);
                if (value == null) continue;
                return value;
            }
            return null;
        }

        protected abstract String get(String var1);

        public abstract ConfigOrigin origin();
    }

    private static final class Singleton {
        private static final ConfigProvider INSTANCE = ConfigProvider.createDefault();

        private Singleton() {
        }
    }
}

