/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.api;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpanAttributes
implements AgentSpan.Attributes {
    public static final AgentSpan.Attributes EMPTY = new SpanAttributes(Collections.emptyMap());
    private final Map<String, String> attributes;

    protected SpanAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SpanAttributes fromMap(Map<String, String> map) {
        return new SpanAttributes(new HashMap<String, String>(map));
    }

    @Override
    public Map<String, String> asMap() {
        return this.attributes;
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public String toString() {
        return "SpanAttributes{" + this.attributes + '}';
    }

    public static class Builder {
        private final Map<String, String> attributes = new HashMap<String, String>();

        protected Builder() {
        }

        public Builder put(String key, String value) {
            Objects.requireNonNull(key, "key must not be null");
            if (value != null) {
                this.attributes.put(key, value);
            }
            return this;
        }

        public Builder put(String key, boolean value) {
            Objects.requireNonNull(key, "key must not be null");
            this.attributes.put(key, Boolean.toString(value));
            return this;
        }

        public Builder put(String key, long value) {
            Objects.requireNonNull(key, "key must not be null");
            this.attributes.put(key, Long.toString(value));
            return this;
        }

        public Builder put(String key, double value) {
            Objects.requireNonNull(key, "key must not be null");
            this.attributes.put(key, Double.toString(value));
            return this;
        }

        public Builder putStringArray(String key, List<String> array) {
            return this.putArray(key, array);
        }

        public Builder putBooleanArray(String key, List<Boolean> array) {
            return this.putArray(key, array);
        }

        public Builder putLongArray(String key, List<Long> array) {
            return this.putArray(key, array);
        }

        public Builder putDoubleArray(String key, List<Double> array) {
            return this.putArray(key, array);
        }

        protected <T> Builder putArray(String key, List<T> array) {
            Objects.requireNonNull(key, "key must not be null");
            if (array != null) {
                for (int index = 0; index < array.size(); ++index) {
                    T value = array.get(index);
                    if (value == null) continue;
                    this.attributes.put(key + "." + index, value.toString());
                }
            }
            return this;
        }

        public AgentSpan.Attributes build() {
            return new SpanAttributes(this.attributes);
        }
    }
}

