/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.trace.common.writer.DDSpanJsonAdapter;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.core.DDSpan;
import java.lang.reflect.Type;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(LoggingWriter.class);
    private static final JsonAdapter<List<DDSpan>> TRACE_ADAPTER = new Moshi.Builder().add(DDSpanJsonAdapter.buildFactory(false)).build().adapter(Types.newParameterizedType(List.class, new Type[]{DDSpan.class}));

    @Override
    public void write(List<DDSpan> trace) {
        try {
            log.info("write(trace): {}", (Object)TRACE_ADAPTER.toJson(trace));
        }
        catch (Exception e) {
            log.error("error writing(trace): {}", trace, (Object)e);
        }
    }

    @Override
    public void start() {
        log.info("start()");
    }

    @Override
    public boolean flush() {
        log.info("flush()");
        return true;
    }

    @Override
    public void close() {
        log.info("close()");
    }

    @Override
    public void incrementDropCounts(int spanCount) {
    }

    public String toString() {
        return "LoggingWriter { }";
    }
}

