/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.dd.trace.common.writer.DDSpanJsonAdapter;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.okio.BufferedSink;
import ddtrot.okio.Okio;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PrintingWriter
implements Writer {
    private final BufferedSink sink;
    private final JsonAdapter<Map<String, List<List<DDSpan>>>> jsonAdapter;

    public PrintingWriter(OutputStream outputStream, boolean hexIds) {
        this.sink = Okio.buffer(Okio.sink(outputStream));
        this.jsonAdapter = new Moshi.Builder().add(DDSpanJsonAdapter.buildFactory(hexIds)).build().adapter(Types.newParameterizedType(Map.class, new Type[]{String.class, Types.newParameterizedType(List.class, new Type[]{Types.newParameterizedType(List.class, new Type[]{DDSpan.class})})}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(List<DDSpan> trace) {
        List<List<DDSpan>> tracesList = Collections.singletonList(trace);
        try {
            BufferedSink bufferedSink = this.sink;
            synchronized (bufferedSink) {
                this.jsonAdapter.toJson(this.sink, Collections.singletonMap("traces", tracesList));
                this.sink.writeString("\n", StandardCharsets.UTF_8);
                this.sink.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
    }

    @Override
    public boolean flush() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public void incrementDropCounts(int spanCount) {
    }
}

