/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import datadog.trace.api.TraceConfig;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.datastreams.DefaultPathwayContext;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import java.util.function.Supplier;

public class DataStreamContextExtractor
implements HttpCodec.Extractor {
    private final HttpCodec.Extractor delegate;
    private final TimeSource timeSource;
    private final Supplier<TraceConfig> traceConfigSupplier;
    private final long hashOfKnownTags;

    public DataStreamContextExtractor(HttpCodec.Extractor delegate, TimeSource timeSource, Supplier<TraceConfig> traceConfigSupplier, long hashOfKnownTags) {
        this.delegate = delegate;
        this.timeSource = timeSource;
        this.traceConfigSupplier = traceConfigSupplier;
        this.hashOfKnownTags = hashOfKnownTags;
    }

    @Override
    public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        DefaultPathwayContext pathwayContext;
        TagContext extracted = this.delegate.extract(carrier, getter);
        if (extracted != null) {
            boolean shouldExtractPathwayContext;
            boolean bl = shouldExtractPathwayContext = extracted.getTraceConfig() == null ? this.traceConfigSupplier.get().isDataStreamsEnabled() : extracted.getTraceConfig().isDataStreamsEnabled();
            if (shouldExtractPathwayContext) {
                DefaultPathwayContext pathwayContext2 = DefaultPathwayContext.extract(carrier, getter, this.timeSource, this.hashOfKnownTags);
                extracted.withPathwayContext(pathwayContext2);
            }
            return extracted;
        }
        if (this.traceConfigSupplier.get().isDataStreamsEnabled() && (pathwayContext = DefaultPathwayContext.extract(carrier, getter, this.timeSource, this.hashOfKnownTags)) != null) {
            extracted = new TagContext();
            extracted.withPathwayContext(pathwayContext);
            return extracted;
        }
        return null;
    }
}

