/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation.ptags;

import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.api.cache.DDPartialKeyCache;
import ddtrot.dd.trace.core.propagation.ptags.TagElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TagValue
extends TagElement {
    private static final Logger log = LoggerFactory.getLogger(TagValue.class);
    private static final DDPartialKeyCache<CharSequence, TagValue> valueCache = DDCaches.newFixedSizePartialKeyCache(128);
    private static final int DD_SOURCE = TagElement.Encoding.DATADOG.ordinal();
    private final CharSequence[] values = new CharSequence[TagElement.Encoding.getNumValues()];
    private final int source;
    private final int hash;

    static TagValue from(CharSequence s) {
        return TagValue.from(TagElement.Encoding.DATADOG, s);
    }

    static TagValue from(TagElement.Encoding encoding, CharSequence s) {
        return TagValue.from(encoding, s, s == null ? -1 : 0, s == null ? -1 : s.length());
    }

    static TagValue from(TagElement.Encoding encoding, CharSequence s, int start, int end) {
        if (s == null || TagValue.isValueInvalid(s, start, end)) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid header h: {} s: {} b: {} e: {}", new Object[]{encoding, s, start, end});
            }
            return null;
        }
        if (encoding == TagElement.Encoding.W3C) {
            return valueCache.computeIfAbsent(s, start, end, TagValue::hashW3C, TagValue::compareW3C, TagValue::produceW3C);
        }
        return valueCache.computeIfAbsent(s, start, end, TagValue::hashDD, TagValue::compareDD, TagValue::produceDD);
    }

    private static boolean isValueInvalid(CharSequence s, int start, int end) {
        return start < 0 || end <= 0 || s.length() < end;
    }

    private static int hashDD(CharSequence s, int start, int end) {
        return TagValue.hash(TagValue::convertDDtoW3C, s, start, end);
    }

    private static int hashW3C(CharSequence s, int start, int end) {
        return TagValue.hash(TagValue::identity, s, start, end);
    }

    private static int hash(CharConverter converter, CharSequence s, int start, int end) {
        int h = 0;
        end = Integer.min(s.length(), end);
        if (start >= 0 && end > 0) {
            for (int i = start; i < end; ++i) {
                h = 31 * h + converter.convert(s.charAt(i));
            }
        }
        return h;
    }

    private static boolean compareDD(CharSequence s, int start, int end, TagValue tagValue) {
        return TagValue.compare(TagValue::identity, s, start, end, tagValue);
    }

    private static boolean compareW3C(CharSequence s, int start, int end, TagValue tagValue) {
        return TagValue.compare(TagValue::convertW3CtoDD, s, start, end, tagValue);
    }

    private static boolean compare(CharConverter converter, CharSequence s, int start, int end, TagValue tagValue) {
        end = Integer.min(s.length(), end);
        if (start < 0 || end < 0 || end - start != tagValue.length()) {
            return false;
        }
        boolean eq = true;
        int i = start;
        int j = 0;
        while (eq && i < end) {
            eq = converter.convert(s.charAt(i)) == tagValue.charAt(j);
            ++i;
            ++j;
        }
        return eq;
    }

    private static TagValue produceDD(CharSequence s, int hash, int start, int end) {
        return new TagValue(TagElement.Encoding.DATADOG, hash, s, start, end);
    }

    private static TagValue produceW3C(CharSequence s, int hash, int start, int end) {
        return new TagValue(TagElement.Encoding.W3C, hash, s, start, end);
    }

    private static char convertDDtoW3C(char c) {
        if (c == ',' || c == ';' || c == '~') {
            return '_';
        }
        if (c == '=') {
            return '~';
        }
        return c;
    }

    private static char identity(char c) {
        return c;
    }

    private static char convertW3CtoDD(char c) {
        if (c == '~') {
            return '=';
        }
        return c;
    }

    TagValue(TagElement.Encoding encoding, int hash, CharSequence s, int start, int end) {
        this.source = encoding.ordinal();
        this.hash = hash;
        this.values[this.source] = start == 0 && end == s.length() ? s : new StringBuilder(end - start).append(s, start, end).toString();
    }

    @Override
    CharSequence forType(TagElement.Encoding encoding) {
        int ordinal = encoding.ordinal();
        CharSequence cs = this.values[ordinal];
        if (cs == null) {
            CharSequence from = this.values[this.source];
            int len = from.length();
            CharConverter cc = this.source == DD_SOURCE ? TagValue::convertDDtoW3C : TagValue::convertW3CtoDD;
            StringBuilder sb = null;
            for (int i = 0; i < len; ++i) {
                char c = from.charAt(i);
                char tc = cc.convert(c);
                if (tc != c && sb == null) {
                    sb = new StringBuilder(len);
                    sb.append(from, 0, i);
                }
                if (sb == null) continue;
                sb.append(tc);
            }
            this.values[ordinal] = sb == null ? from : sb.toString();
            cs = this.values[ordinal];
        }
        return cs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TagValue ov = (TagValue)o;
        if (this.hash != ov.hash) {
            return false;
        }
        CharSequence cst = this.values[this.source];
        CharSequence cso = ov.values[ov.source];
        int len = cst.length();
        if (len != cso.length()) {
            return false;
        }
        if (this.source == ov.source) {
            for (int i = 0; i < len; ++i) {
                if (cst.charAt(i) == cso.charAt(i)) continue;
                return false;
            }
        } else {
            CharConverter cct = this.source == DD_SOURCE ? TagValue::identity : TagValue::convertW3CtoDD;
            CharConverter cco = ov.source == DD_SOURCE ? TagValue::identity : TagValue::convertW3CtoDD;
            for (int i = 0; i < len; ++i) {
                if (cct.convert(cst.charAt(i)) == cco.convert(cso.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public String toString() {
        return this.values[this.source].toString();
    }

    @Override
    public int length() {
        return this.values[this.source].length();
    }

    @Override
    public char charAt(int index) {
        if (this.source == DD_SOURCE) {
            return this.values[this.source].charAt(index);
        }
        return TagValue.convertW3CtoDD(this.values[this.source].charAt(index));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.values[this.source].subSequence(start, end);
    }

    public int indexOf(char c) {
        c = this.source == DD_SOURCE ? c : TagValue.convertDDtoW3C(c);
        CharSequence cs = this.values[this.source];
        int len = cs.length();
        int index = -1;
        for (int i = 0; i < len; ++i) {
            if (cs.charAt(i) != c) continue;
            index = i;
        }
        return index;
    }

    private static interface CharConverter {
        public char convert(char var1);
    }
}

