/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.scopemanager;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.core.scopemanager.AbstractContinuation;
import ddtrot.dd.trace.core.scopemanager.ContinuableScopeManager;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class SingleContinuation
extends AbstractContinuation {
    private static final AtomicIntegerFieldUpdater<SingleContinuation> USED = AtomicIntegerFieldUpdater.newUpdater(SingleContinuation.class, "used");
    private volatile int used = 0;

    SingleContinuation(ContinuableScopeManager scopeManager, AgentSpan spanUnderScope, byte source) {
        super(scopeManager, spanUnderScope, source);
    }

    @Override
    public AgentScope activate() {
        if (USED.compareAndSet(this, 0, 1)) {
            return this.scopeManager.continueSpan(this, this.spanUnderScope, this.source);
        }
        ContinuableScopeManager.log.debug("Failed to activate continuation. Reusing a continuation not allowed. Spans may be reported separately.");
        return this.scopeManager.continueSpan(null, this.spanUnderScope, this.source);
    }

    public void cancel() {
        if (USED.compareAndSet(this, 0, 1)) {
            this.traceCollector.cancelContinuation(this);
        } else {
            ContinuableScopeManager.log.debug("Failed to close continuation {}. Already used.", (Object)this);
        }
    }

    @Override
    public AgentSpan getSpan() {
        return this.spanUnderScope;
    }

    @Override
    void cancelFromContinuedScopeClose() {
        this.traceCollector.cancelContinuation(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "->" + this.spanUnderScope;
    }
}

