/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import ddtrot.dd.trace.core.util.Matcher;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class BaseMatcher
implements Matcher {
    @Override
    public abstract boolean matches(String var1);

    @Override
    public abstract boolean matches(CharSequence var1);

    @Override
    public final boolean matches(Object value) {
        if (value instanceof String) {
            return this.matches((String)value);
        }
        if (value instanceof CharSequence) {
            return this.matches((CharSequence)value);
        }
        if (value instanceof Boolean) {
            return this.matches((Boolean)value);
        }
        if (value instanceof Byte) {
            return this.matches((Byte)value);
        }
        if (value instanceof Short) {
            return this.matches((Short)value);
        }
        if (value instanceof Integer) {
            return this.matches((Integer)value);
        }
        if (value instanceof Long) {
            return this.matches((Long)value);
        }
        if (value instanceof BigInteger) {
            return this.matches((BigInteger)value);
        }
        if (value instanceof Float) {
            return this.matches(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return this.matches((Double)value);
        }
        if (value instanceof BigDecimal) {
            return this.matches((BigDecimal)value);
        }
        return false;
    }

    @Override
    public boolean matches(boolean value) {
        return this.matches(value ? "true" : "false");
    }

    @Override
    public boolean matches(byte value) {
        return this.matches((int)value);
    }

    @Override
    public boolean matches(short value) {
        return this.matches((int)value);
    }

    @Override
    public boolean matches(int value) {
        return this.matches(Integer.toString(value));
    }

    @Override
    public boolean matches(long value) {
        return this.matches(Long.toString(value));
    }

    @Override
    public boolean matches(BigInteger value) {
        return this.matches(value.toString());
    }

    @Override
    public boolean matches(double value) {
        if (Math.floor(value) == value) {
            return this.matches((int)value);
        }
        return false;
    }

    @Override
    public boolean matches(float value) {
        if (Math.floor(value) == (double)value) {
            return this.matches((int)value);
        }
        return false;
    }

    @Override
    public boolean matches(BigDecimal value) {
        String str = value.toPlainString();
        if (str.indexOf(46) == -1) {
            return this.matches(str);
        }
        return false;
    }
}

