/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.jnr.posix;

import ddtrot.jnr.constants.platform.Confstr;
import ddtrot.jnr.constants.platform.Pathconf;
import ddtrot.jnr.constants.platform.Sysconf;
import ddtrot.jnr.ffi.LibraryLoader;
import ddtrot.jnr.ffi.Memory;
import ddtrot.jnr.ffi.Platform;
import ddtrot.jnr.ffi.Pointer;
import ddtrot.jnr.ffi.mapper.FromNativeContext;
import ddtrot.jnr.posix.BaseNativePOSIX;
import ddtrot.jnr.posix.FileStat;
import ddtrot.jnr.posix.LibCProvider;
import ddtrot.jnr.posix.MacOSFileStat;
import ddtrot.jnr.posix.MacOSFileStat64Inode;
import ddtrot.jnr.posix.MacOSMsgHdr;
import ddtrot.jnr.posix.MacOSPasswd;
import ddtrot.jnr.posix.MacOSSocketMacros;
import ddtrot.jnr.posix.MsgHdr;
import ddtrot.jnr.posix.NSGetEnviron;
import ddtrot.jnr.posix.NativeTimes;
import ddtrot.jnr.posix.POSIXHandler;
import ddtrot.jnr.posix.SocketMacros;
import ddtrot.jnr.posix.Times;
import java.nio.ByteBuffer;

final class MacOSPOSIX
extends BaseNativePOSIX {
    private final NSGetEnviron environ;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new MacOSPasswd((Pointer)arg) : null;
        }
    };

    MacOSPOSIX(LibCProvider libcProvider, POSIXHandler handler) {
        super(libcProvider, handler);
        LibraryLoader<NSGetEnviron> loader = LibraryLoader.create(NSGetEnviron.class);
        loader.library("libSystem.B.dylib");
        this.environ = loader.load();
    }

    @Override
    public FileStat allocateStat() {
        if (Platform.getNativePlatform().getCPU() == Platform.CPU.AARCH64) {
            return new MacOSFileStat64Inode(this);
        }
        return new MacOSFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        return new MacOSMsgHdr(this);
    }

    @Override
    public Pointer allocatePosixSpawnFileActions() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public Pointer allocatePosixSpawnattr() {
        return Memory.allocateDirect(this.getRuntime(), 8);
    }

    @Override
    public SocketMacros socketMacros() {
        return MacOSSocketMacros.INSTANCE;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public int confstr(Confstr name, ByteBuffer buf, int len) {
        return this.libc().confstr(name, buf, len);
    }

    @Override
    public int fpathconf(int fd, Pathconf name) {
        return this.libc().fpathconf(fd, name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer environ() {
        return this.environ._NSGetEnviron().getPointer(0L);
    }
}

