/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.communication.ddagent;

import datadog.trace.api.Config;
import datadog.trace.api.Platform;
import ddtrot.dd.trace.util.ProcessSupervisor;
import java.io.Closeable;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalAgentLauncher
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ExternalAgentLauncher.class);
    private static final ProcessBuilder.Redirect DISCARD = ProcessBuilder.Redirect.to(new File(Platform.isWindows() ? "NUL" : "/dev/null"));
    private ProcessSupervisor traceProcessSupervisor;
    private ProcessSupervisor dogStatsDProcessSupervisor;

    public ExternalAgentLauncher(Config config) {
        if (config.isAzureAppServices()) {
            if (config.getTraceAgentPath() != null) {
                ProcessBuilder traceProcessBuilder = new ProcessBuilder(config.getTraceAgentPath());
                traceProcessBuilder.redirectOutput(DISCARD);
                traceProcessBuilder.redirectError(DISCARD);
                traceProcessBuilder.command().addAll(config.getTraceAgentArgs());
                this.traceProcessSupervisor = new ProcessSupervisor("trace-agent", traceProcessBuilder, ExternalAgentLauncher.healthCheck(config.getAgentNamedPipe()));
            } else {
                log.warn("Trace agent path not set. Will not start trace agent process");
            }
            if (config.getDogStatsDPath() != null) {
                ProcessBuilder dogStatsDProcessBuilder = new ProcessBuilder(config.getDogStatsDPath());
                dogStatsDProcessBuilder.redirectOutput(DISCARD);
                dogStatsDProcessBuilder.redirectError(DISCARD);
                dogStatsDProcessBuilder.command().addAll(config.getDogStatsDArgs());
                this.dogStatsDProcessSupervisor = new ProcessSupervisor("dogstatsd", dogStatsDProcessBuilder, ExternalAgentLauncher.healthCheck(config.getDogStatsDNamedPipe()));
            } else {
                log.warn("DogStatsD path not set. Will not start DogStatsD process");
            }
        }
    }

    @Override
    public void close() {
        if (this.traceProcessSupervisor != null) {
            this.traceProcessSupervisor.close();
        }
        if (this.dogStatsDProcessSupervisor != null) {
            this.dogStatsDProcessSupervisor.close();
        }
    }

    private static ProcessSupervisor.HealthCheck healthCheck(String pipeName) {
        return null != pipeName && !pipeName.trim().isEmpty() ? new NamedPipeHealthCheck(pipeName) : ProcessSupervisor.ALWAYS_READY;
    }

    static final class NamedPipeHealthCheck
    implements ProcessSupervisor.HealthCheck {
        private static final String NAMED_PIPE_PREFIX = "\\\\.\\pipe\\";
        private final File pipe;

        NamedPipeHealthCheck(String pipeName) {
            this.pipe = pipeName.startsWith(NAMED_PIPE_PREFIX) ? new File(pipeName) : new File(NAMED_PIPE_PREFIX + pipeName);
        }

        @Override
        public ProcessSupervisor.Health run(ProcessSupervisor.Health previousHealth) throws InterruptedException {
            if (previousHealth == ProcessSupervisor.Health.NEVER_CHECKED) {
                double delayMillis = 50.0;
                for (int retries = 0; retries < 7; ++retries) {
                    if (!this.pipe.exists()) {
                        return ProcessSupervisor.Health.READY_TO_START;
                    }
                    Thread.sleep((long)delayMillis);
                    delayMillis *= 1.75;
                }
                return ProcessSupervisor.Health.HEALTHY;
            }
            if (this.pipe.exists()) {
                return ProcessSupervisor.Health.HEALTHY;
            }
            return ProcessSupervisor.Health.READY_TO_START;
        }
    }
}

