/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast;

import ddtrot.dd.trace.bootstrap.config.provider.ConfigProvider;
import javax.annotation.Nonnull;

public enum IastDetectionMode {
    FULL{

        @Override
        public int getIastMaxConcurrentRequests(@Nonnull ConfigProvider config) {
            return Integer.MIN_VALUE;
        }

        @Override
        public int getIastVulnerabilitiesPerRequest(@Nonnull ConfigProvider config) {
            return Integer.MIN_VALUE;
        }

        @Override
        public float getIastRequestSampling(@Nonnull ConfigProvider config) {
            return 100.0f;
        }

        @Override
        public boolean isIastDeduplicationEnabled(@Nonnull ConfigProvider config) {
            return false;
        }

        @Override
        public int getIastMaxRangeCount(@Nonnull ConfigProvider config) {
            return Integer.MAX_VALUE;
        }
    }
    ,
    DEFAULT{

        @Override
        public int getIastMaxConcurrentRequests(@Nonnull ConfigProvider config) {
            return config.getInteger("iast.max-concurrent-requests", 4, new String[0]);
        }

        @Override
        public int getIastVulnerabilitiesPerRequest(@Nonnull ConfigProvider config) {
            return config.getInteger("iast.vulnerabilities-per-request", 2, new String[0]);
        }

        @Override
        public float getIastRequestSampling(@Nonnull ConfigProvider config) {
            return config.getFloat("iast.request-sampling", 33.0f);
        }

        @Override
        public boolean isIastDeduplicationEnabled(@Nonnull ConfigProvider config) {
            return config.getBoolean("iast.deduplication.enabled", true, new String[0]);
        }

        @Override
        public int getIastMaxRangeCount(@Nonnull ConfigProvider config) {
            return config.getInteger("iast.max-range-count", 10, new String[0]);
        }
    };

    public static final int UNLIMITED = Integer.MIN_VALUE;

    public abstract int getIastMaxConcurrentRequests(@Nonnull ConfigProvider var1);

    public abstract int getIastVulnerabilitiesPerRequest(@Nonnull ConfigProvider var1);

    public abstract float getIastRequestSampling(@Nonnull ConfigProvider var1);

    public abstract boolean isIastDeduplicationEnabled(@Nonnull ConfigProvider var1);

    public abstract int getIastMaxRangeCount(@Nonnull ConfigProvider var1);
}

