/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.document;

import com.datasonnet.Utils;
import com.datasonnet.document.InvalidMediaTypeException;
import com.datasonnet.document.MediaTypeUtils;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class MediaType
implements Comparable<MediaType>,
Serializable {
    private static final long serialVersionUID = 2069937152339670231L;
    protected static final String WILDCARD_TYPE = "*";
    private static final BitSet TOKEN;
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    @Nullable
    private volatile String toStringValue;
    public static final Comparator<MediaType> QUALITY_VALUE_COMPARATOR;
    public static final Comparator<MediaType> SPECIFICITY_COMPARATOR;

    public MediaType(String type) {
        this(type, WILDCARD_TYPE);
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    public MediaType(String type, String subtype, Charset charset) {
        this(type, subtype, Collections.singletonMap("charset", charset.name()));
    }

    public MediaType(String type, String subtype, double qualityValue) {
        this(type, subtype, Collections.singletonMap("q", Double.toString(qualityValue)));
    }

    public MediaType(MediaType other, Charset charset) {
        this(other.getType(), other.getSubtype(), MediaType.addCharsetParameter(charset, other.getParameters()));
    }

    public MediaType(MediaType other, @Nullable Map<String, String> parameters) {
        this(other.getType(), other.getSubtype(), parameters);
    }

    public MediaType(String type, String subtype, @Nullable Map<String, String> parameters) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("'type' must not be empty");
        }
        if (subtype == null || subtype.isEmpty()) {
            throw new IllegalArgumentException("'subtype' must not be empty");
        }
        MediaType.checkToken(type);
        MediaType.checkToken(subtype);
        this.type = type.toLowerCase(Locale.ENGLISH);
        this.subtype = subtype.toLowerCase(Locale.ENGLISH);
        if (parameters != null && !parameters.isEmpty()) {
            LinkedHashMap map = new LinkedHashMap(parameters.size());
            parameters.forEach((attribute, value) -> map.put(attribute.toLowerCase(Locale.ENGLISH), MediaType.unquote(value)));
            this.parameters = Collections.unmodifiableMap(map);
        } else {
            this.parameters = Collections.emptyMap();
        }
    }

    public MediaType(MediaType other) {
        this.type = other.type;
        this.subtype = other.subtype;
        this.parameters = other.parameters;
        this.toStringValue = other.toStringValue;
    }

    private static void checkToken(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char ch = token.charAt(i);
            if (TOKEN.get(ch)) continue;
            throw new IllegalArgumentException("Invalid token character '" + ch + "' in token \"" + token + "\"");
        }
    }

    private static boolean isQuotedString(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() < 2) {
            return false;
        }
        return s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'");
    }

    protected static String unquote(String s) {
        if (!MediaType.isQuotedString(s)) {
            return s;
        }
        return s.substring(1, s.length() - 1).replaceAll("\\\\(.)", "$1");
    }

    public boolean isWildcardType() {
        return WILDCARD_TYPE.equals(this.getType());
    }

    public boolean isWildcardSubtype() {
        return WILDCARD_TYPE.equals(this.getSubtype()) || this.getSubtype().startsWith("*+");
    }

    public boolean isConcrete() {
        return !this.isWildcardType() && !this.isWildcardSubtype();
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    @Nullable
    public Charset getCharset() {
        String charset = this.getParameter("charset");
        return charset != null ? Charset.forName(MediaType.unquote(charset)) : null;
    }

    @Nullable
    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean equalsTypeAndSubtype(@Nullable MediaType other) {
        if (other == null) {
            return false;
        }
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype);
    }

    public boolean isPresentIn(Collection<? extends MediaType> mimeTypes) {
        for (MediaType mediaType : mimeTypes) {
            if (!mediaType.equalsTypeAndSubtype(this)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaType)) {
            return false;
        }
        MediaType otherType = (MediaType)other;
        return this.type.equalsIgnoreCase(otherType.type) && this.subtype.equalsIgnoreCase(otherType.subtype) && this.parametersAreEqual(otherType);
    }

    private boolean parametersAreEqual(MediaType other) {
        if (this.parameters.size() != other.parameters.size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            if (!other.parameters.containsKey(key)) {
                return false;
            }
            if (!("charset".equals(key) ? !Utils.nullSafeEquals(this.getCharset(), other.getCharset()) : !Utils.nullSafeEquals(entry.getValue(), other.parameters.get(key)))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        String value = this.toStringValue;
        if (value == null) {
            StringBuilder builder = new StringBuilder();
            this.appendTo(builder);
            this.toStringValue = value = builder.toString();
        }
        return value;
    }

    protected void appendTo(StringBuilder builder) {
        builder.append(this.type);
        builder.append('/');
        builder.append(this.subtype);
        this.appendTo(this.parameters, builder);
    }

    private void appendTo(Map<String, String> map, StringBuilder builder) {
        map.forEach((key, val) -> {
            builder.append(';');
            builder.append((String)key);
            builder.append('=');
            builder.append((String)val);
        });
    }

    @Override
    public int compareTo(MediaType other) {
        int comp = this.getType().compareToIgnoreCase(other.getType());
        if (comp != 0) {
            return comp;
        }
        comp = this.getSubtype().compareToIgnoreCase(other.getSubtype());
        if (comp != 0) {
            return comp;
        }
        comp = this.getParameters().size() - other.getParameters().size();
        if (comp != 0) {
            return comp;
        }
        TreeSet<String> thisAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        thisAttributes.addAll(this.getParameters().keySet());
        TreeSet<String> otherAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        otherAttributes.addAll(other.getParameters().keySet());
        Iterator thisAttributesIterator = thisAttributes.iterator();
        Iterator otherAttributesIterator = otherAttributes.iterator();
        while (thisAttributesIterator.hasNext()) {
            String otherAttribute;
            String thisAttribute = (String)thisAttributesIterator.next();
            comp = thisAttribute.compareToIgnoreCase(otherAttribute = (String)otherAttributesIterator.next());
            if (comp != 0) {
                return comp;
            }
            if ("charset".equals(thisAttribute)) {
                Charset otherCharset;
                Charset thisCharset = this.getCharset();
                if (thisCharset == (otherCharset = other.getCharset())) continue;
                if (thisCharset == null) {
                    return -1;
                }
                if (otherCharset == null) {
                    return 1;
                }
                comp = thisCharset.compareTo(otherCharset);
                if (comp == 0) continue;
                return comp;
            }
            String thisValue = this.getParameters().get(thisAttribute);
            String otherValue = other.getParameters().get(otherAttribute);
            if (otherValue == null) {
                otherValue = "";
            }
            if ((comp = thisValue.compareTo(otherValue)) == 0) continue;
            return comp;
        }
        return 0;
    }

    private static Map<String, String> addCharsetParameter(Charset charset, Map<String, String> parameters) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(parameters);
        map.put("charset", charset.name());
        return map;
    }

    protected static void checkParameters(String attribute, String value) {
        double d;
        if (attribute == null || attribute.isEmpty()) {
            throw new IllegalArgumentException("'attribute' must not be empty");
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("'value' must not be empty");
        }
        MediaType.checkToken(attribute);
        if ("charset".equals(attribute)) {
            value = MediaType.unquote(value);
            Charset.forName(value);
        } else if (!MediaType.isQuotedString(value)) {
            MediaType.checkToken(value);
        }
        if (!(!"q".equals(attribute) || (d = Double.parseDouble(value = MediaType.unquote(value))) >= 0.0 && d <= 1.0)) {
            throw new IllegalArgumentException("Invalid quality value \"" + value + "\": should be between 0.0 and 1.0");
        }
    }

    public double getQualityValue() {
        String qualityFactor = this.getParameter("q");
        return qualityFactor != null ? Double.parseDouble(MediaType.unquote(qualityFactor)) : 1.0;
    }

    public boolean includes(@Nullable MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType()) {
            return true;
        }
        if (this.getType().equals(other.getType())) {
            if (this.getSubtype().equals(other.getSubtype())) {
                return true;
            }
            if (this.isWildcardSubtype()) {
                int thisPlusIdx = this.getSubtype().lastIndexOf(43);
                if (thisPlusIdx == -1) {
                    return true;
                }
                int otherPlusIdx = other.getSubtype().lastIndexOf(43);
                if (otherPlusIdx != -1) {
                    String otherSubtypeSuffix;
                    String thisSubtypeNoSuffix = this.getSubtype().substring(0, thisPlusIdx);
                    String thisSubtypeSuffix = this.getSubtype().substring(thisPlusIdx + 1);
                    return thisSubtypeSuffix.equals(otherSubtypeSuffix = other.getSubtype().substring(otherPlusIdx + 1)) && WILDCARD_TYPE.equals(thisSubtypeNoSuffix);
                }
            }
        }
        return false;
    }

    public boolean isCompatibleWith(@Nullable MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType() || other.isWildcardType()) {
            return true;
        }
        if (this.getType().equals(other.getType())) {
            if (this.getSubtype().equals(other.getSubtype())) {
                return true;
            }
            if (this.isWildcardSubtype() || other.isWildcardSubtype()) {
                int thisPlusIdx = this.getSubtype().lastIndexOf(43);
                int otherPlusIdx = other.getSubtype().lastIndexOf(43);
                if (thisPlusIdx == -1 && otherPlusIdx == -1) {
                    return true;
                }
                if (thisPlusIdx != -1 && otherPlusIdx != -1) {
                    String otherSubtypeSuffix;
                    String thisSubtypeNoSuffix = this.getSubtype().substring(0, thisPlusIdx);
                    String otherSubtypeNoSuffix = other.getSubtype().substring(0, otherPlusIdx);
                    String thisSubtypeSuffix = this.getSubtype().substring(thisPlusIdx + 1);
                    return thisSubtypeSuffix.equals(otherSubtypeSuffix = other.getSubtype().substring(otherPlusIdx + 1)) && (WILDCARD_TYPE.equals(thisSubtypeNoSuffix) || WILDCARD_TYPE.equals(otherSubtypeNoSuffix));
                }
            }
        }
        return false;
    }

    public MediaType copyQualityValue(MediaType mediaType) {
        if (!mediaType.getParameters().containsKey("q")) {
            return this;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.getParameters());
        params.put("q", mediaType.getParameters().get("q"));
        return new MediaType(this, params);
    }

    public MediaType removeQualityValue() {
        if (!this.getParameters().containsKey("q")) {
            return this;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.getParameters());
        params.remove("q");
        return new MediaType(this, params);
    }

    public static MediaType valueOf(String value) {
        return MediaType.parseMediaType(value);
    }

    public static MediaType parseMediaType(String mediaType) {
        try {
            return MediaTypeUtils.parseMediaType(mediaType);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidMediaTypeException(mediaType, ex.getMessage());
        }
    }

    public static List<MediaType> parseMediaTypes(@Nullable String mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> tokenizedTypes = MediaTypeUtils.tokenize(mediaTypes);
        ArrayList<MediaType> result = new ArrayList<MediaType>(tokenizedTypes.size());
        for (String type : tokenizedTypes) {
            if (!Utils.hasText(type)) continue;
            result.add(MediaType.parseMediaType(type));
        }
        return result;
    }

    public static List<MediaType> parseMediaTypes(@Nullable List<String> mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            return Collections.emptyList();
        }
        if (mediaTypes.size() == 1) {
            return MediaType.parseMediaTypes(mediaTypes.get(0));
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(8);
        for (String mediaType : mediaTypes) {
            result.addAll(MediaType.parseMediaTypes(mediaType));
        }
        return result;
    }

    public static String toString(Collection<MediaType> mediaTypes) {
        return MediaTypeUtils.toString(mediaTypes);
    }

    public static void sortBySpecificity(List<MediaType> mediaTypes) {
        Objects.requireNonNull(mediaTypes, "'mediaTypes' must not be null");
        if (mediaTypes.size() > 1) {
            mediaTypes.sort(SPECIFICITY_COMPARATOR);
        }
    }

    public static void sortByQualityValue(List<MediaType> mediaTypes) {
        Objects.requireNonNull(mediaTypes, "'mediaTypes' must not be null");
        if (mediaTypes.size() > 1) {
            mediaTypes.sort(QUALITY_VALUE_COMPARATOR);
        }
    }

    public static void sortBySpecificityAndQuality(List<MediaType> mediaTypes) {
        Objects.requireNonNull(mediaTypes, "'mediaTypes' must not be null");
        if (mediaTypes.size() > 1) {
            mediaTypes.sort(SPECIFICITY_COMPARATOR.thenComparing(QUALITY_VALUE_COMPARATOR));
        }
    }

    static {
        BitSet ctl = new BitSet(128);
        for (int i = 0; i <= 31; ++i) {
            ctl.set(i);
        }
        ctl.set(127);
        BitSet separators = new BitSet(128);
        separators.set(40);
        separators.set(41);
        separators.set(60);
        separators.set(62);
        separators.set(64);
        separators.set(44);
        separators.set(59);
        separators.set(58);
        separators.set(92);
        separators.set(34);
        separators.set(47);
        separators.set(91);
        separators.set(93);
        separators.set(63);
        separators.set(61);
        separators.set(123);
        separators.set(125);
        separators.set(32);
        separators.set(9);
        TOKEN = new BitSet(128);
        TOKEN.set(0, 128);
        TOKEN.andNot(ctl);
        TOKEN.andNot(separators);
        QUALITY_VALUE_COMPARATOR = (mediaType1, mediaType2) -> {
            double quality1 = mediaType1.getQualityValue();
            double quality2 = mediaType2.getQualityValue();
            int qualityComparison = Double.compare(quality2, quality1);
            if (qualityComparison != 0) {
                return qualityComparison;
            }
            if (mediaType1.isWildcardType() && !mediaType2.isWildcardType()) {
                return 1;
            }
            if (mediaType2.isWildcardType() && !mediaType1.isWildcardType()) {
                return -1;
            }
            if (!mediaType1.getType().equals(mediaType2.getType())) {
                return 0;
            }
            if (mediaType1.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
                return 1;
            }
            if (mediaType2.isWildcardSubtype() && !mediaType1.isWildcardSubtype()) {
                return -1;
            }
            if (!mediaType1.getSubtype().equals(mediaType2.getSubtype())) {
                return 0;
            }
            int paramsSize1 = mediaType1.getParameters().size();
            int paramsSize2 = mediaType2.getParameters().size();
            return Integer.compare(paramsSize2, paramsSize1);
        };
        SPECIFICITY_COMPARATOR = new SpecificityComparator<MediaType>(){

            @Override
            protected int compareParameters(MediaType mediaType1, MediaType mediaType2) {
                double quality1 = mediaType1.getQualityValue();
                double quality2 = mediaType2.getQualityValue();
                int qualityComparison = Double.compare(quality2, quality1);
                if (qualityComparison != 0) {
                    return qualityComparison;
                }
                return super.compareParameters(mediaType1, mediaType2);
            }
        };
    }

    public static class SpecificityComparator<T extends MediaType>
    implements Comparator<T> {
        @Override
        public int compare(T mimeType1, T mimeType2) {
            if (((MediaType)mimeType1).isWildcardType() && !((MediaType)mimeType2).isWildcardType()) {
                return 1;
            }
            if (((MediaType)mimeType2).isWildcardType() && !((MediaType)mimeType1).isWildcardType()) {
                return -1;
            }
            if (!((MediaType)mimeType1).getType().equals(((MediaType)mimeType2).getType())) {
                return 0;
            }
            if (((MediaType)mimeType1).isWildcardSubtype() && !((MediaType)mimeType2).isWildcardSubtype()) {
                return 1;
            }
            if (((MediaType)mimeType2).isWildcardSubtype() && !((MediaType)mimeType1).isWildcardSubtype()) {
                return -1;
            }
            if (!((MediaType)mimeType1).getSubtype().equals(((MediaType)mimeType2).getSubtype())) {
                return 0;
            }
            return this.compareParameters(mimeType1, mimeType2);
        }

        protected int compareParameters(T mimeType1, T mimeType2) {
            int paramsSize1 = ((MediaType)mimeType1).getParameters().size();
            int paramsSize2 = ((MediaType)mimeType2).getParameters().size();
            return Integer.compare(paramsSize2, paramsSize1);
        }
    }
}

