/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.plugins;

import com.datasonnet.RecentsMap;
import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.plugins.BaseJacksonDataFormatPlugin;
import com.datasonnet.plugins.jackson.JAXBElementMixIn;
import com.datasonnet.plugins.jackson.JAXBElementSerializer;
import com.datasonnet.spi.PluginException;
import com.datasonnet.spi.ujsonUtils;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ujson.Null$;
import ujson.Value;

public class DefaultJavaFormatPlugin
extends BaseJacksonDataFormatPlugin {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    public static final String DEFAULT_DS_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String DS_PARAM_DATE_FORMAT = "dateformat";
    public static final String DS_PARAM_TYPE = "type";
    public static final String DS_PARAM_OUTPUT_CLASS = "outputclass";
    private static final Map<Integer, ObjectMapper> MAPPER_CACHE = new RecentsMap<Integer, ObjectMapper>(64);

    @NotNull
    private static DateFormat makeDateFormat(String defaultDsDateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(defaultDsDateFormat);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public DefaultJavaFormatPlugin() {
        this.supportedTypes.add(MediaTypes.APPLICATION_JAVA);
        this.supportedTypes.add(MediaType.parseMediaType("application/java"));
        this.readerParams.add(DS_PARAM_DATE_FORMAT);
        this.readerParams.add(DS_PARAM_TYPE);
        this.readerParams.add(DS_PARAM_OUTPUT_CLASS);
        this.writerParams.addAll(this.readerParams);
    }

    @Override
    protected boolean canReadClass(Class<?> cls) {
        return true;
    }

    @Override
    protected boolean canWriteClass(Class<?> clazz) {
        return true;
    }

    @Override
    public Value read(Document<?> doc) throws PluginException {
        if (doc.getContent() == null) {
            return Null$.MODULE$;
        }
        ObjectMapper mapper = this.getObjectMapper(doc.getMediaType());
        JsonNode inputAsNode = mapper.valueToTree(doc.getContent());
        return this.ujsonFrom(inputAsNode);
    }

    @Override
    public <T> Document<T> write(Value input, MediaType mediaType, Class<T> targetType) throws PluginException {
        T converted = this.writeValue(input, mediaType, targetType);
        return new DefaultDocument<T>(converted, mediaType);
    }

    @Nullable
    private <T> T writeValue(Value input, MediaType mediaType, Class<T> targetType) throws PluginException {
        ObjectMapper mapper = this.getObjectMapper(mediaType);
        try {
            JavaType javaType;
            String typeName;
            Object inputAsJava = ujsonUtils.javaObjectFrom(input);
            if ((mediaType.getParameters().containsKey(DS_PARAM_TYPE) || mediaType.getParameters().containsKey(DS_PARAM_OUTPUT_CLASS)) && !"".equals(typeName = this.getJavaType(mediaType)) && (javaType = mapper.getTypeFactory().constructFromCanonical(typeName)).isTypeOrSubTypeOf(targetType)) {
                if (javaType.isTypeOrSuperTypeOf(inputAsJava.getClass())) {
                    return (T)inputAsJava;
                }
                return (T)mapper.convertValue(inputAsJava, javaType);
            }
            if (targetType.isAssignableFrom(inputAsJava.getClass())) {
                return (T)inputAsJava;
            }
            return (T)mapper.convertValue(inputAsJava, targetType);
        }
        catch (IllegalArgumentException e) {
            throw new PluginException("Unable to convert to target type", e);
        }
    }

    private ObjectMapper getObjectMapper(MediaType mediaType) {
        ObjectMapper mapper = DEFAULT_OBJECT_MAPPER;
        if (mediaType.getParameters().containsKey(DS_PARAM_DATE_FORMAT)) {
            String dateFormat = mediaType.getParameter(DS_PARAM_DATE_FORMAT);
            int cacheKey = dateFormat.hashCode();
            mapper = MAPPER_CACHE.computeIfAbsent(cacheKey, integer -> new ObjectMapper().setDateFormat(DefaultJavaFormatPlugin.makeDateFormat(dateFormat)));
        }
        return mapper;
    }

    private String getJavaType(MediaType mediaType) {
        if (mediaType.getParameters().containsKey(DS_PARAM_TYPE)) {
            return mediaType.getParameter(DS_PARAM_TYPE);
        }
        return mediaType.getParameter(DS_PARAM_OUTPUT_CLASS);
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addSerializer(JAXBElement.class, (JsonSerializer)new JAXBElementSerializer());
        DEFAULT_OBJECT_MAPPER.registerModule((Module)module);
        DEFAULT_OBJECT_MAPPER.addMixIn(JAXBElement.class, JAXBElementMixIn.class);
        DEFAULT_OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        DEFAULT_OBJECT_MAPPER.setDateFormat(DefaultJavaFormatPlugin.makeDateFormat(DEFAULT_DS_DATE_FORMAT));
    }
}

