/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractReconnectionHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReconnectionHandler.class);
    private final ScheduledExecutorService executor;
    private final ReconnectionPolicy.ReconnectionSchedule schedule;
    private final AtomicReference<ListenableFuture<?>> currentAttempt;
    private final HandlerFuture handlerFuture = new HandlerFuture();
    private final long initialDelayMs;
    private final CountDownLatch ready = new CountDownLatch(1);

    public AbstractReconnectionHandler(ScheduledExecutorService executor, ReconnectionPolicy.ReconnectionSchedule schedule, AtomicReference<ListenableFuture<?>> currentAttempt) {
        this(executor, schedule, currentAttempt, -1L);
    }

    public AbstractReconnectionHandler(ScheduledExecutorService executor, ReconnectionPolicy.ReconnectionSchedule schedule, AtomicReference<ListenableFuture<?>> currentAttempt, long initialDelayMs) {
        this.executor = executor;
        this.schedule = schedule;
        this.currentAttempt = currentAttempt;
        this.initialDelayMs = initialDelayMs;
    }

    protected abstract Connection tryReconnect() throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException;

    protected abstract void onReconnection(Connection var1);

    protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
        return true;
    }

    protected boolean onUnknownException(Exception e, long nextDelayMs) {
        return true;
    }

    protected boolean onAuthenticationException(AuthenticationException e, long nextDelayMs) {
        return true;
    }

    protected boolean onUnsupportedProtocolVersionException(UnsupportedProtocolVersionException e, long nextDelayMs) {
        return false;
    }

    protected boolean onClusterNameMismatchException(ClusterNameMismatchException e, long nextDelayMs) {
        return false;
    }

    public void start() {
        long firstDelay = this.initialDelayMs >= 0L ? this.initialDelayMs : this.schedule.nextDelayMs();
        logger.debug("First reconnection scheduled in {}ms", (Object)firstDelay);
        try {
            block3: {
                ListenableFuture<?> previous;
                this.handlerFuture.nextTry = this.executor.schedule(this, firstDelay, TimeUnit.MILLISECONDS);
                do {
                    if ((previous = this.currentAttempt.get()) == null || previous.isCancelled()) continue;
                    logger.debug("Found another already active handler, cancelling");
                    this.handlerFuture.cancel(false);
                    break block3;
                } while (!this.currentAttempt.compareAndSet(previous, (ListenableFuture<?>)this.handlerFuture));
                logger.debug("Becoming the active handler");
            }
            this.ready.countDown();
        }
        catch (RejectedExecutionException e) {
            logger.debug("Aborting reconnection handling since the cluster is shutting down");
        }
    }

    @Override
    public void run() {
        try {
            this.ready.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (this.handlerFuture.isCancelled()) {
            logger.debug("Got cancelled, stopping");
            this.currentAttempt.compareAndSet((ListenableFuture<?>)this.handlerFuture, (ListenableFuture<?>)null);
            return;
        }
        try {
            this.onReconnection(this.tryReconnect());
            this.handlerFuture.markAsDone();
            this.currentAttempt.compareAndSet((ListenableFuture<?>)this.handlerFuture, (ListenableFuture<?>)null);
            logger.debug("Reconnection successful, cleared the future");
        }
        catch (ConnectionException e) {
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onConnectionException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                this.currentAttempt.compareAndSet((ListenableFuture<?>)this.handlerFuture, (ListenableFuture<?>)null);
            }
        }
        catch (AuthenticationException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onAuthenticationException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retry against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.getHost());
                this.currentAttempt.compareAndSet((ListenableFuture<?>)this.handlerFuture, (ListenableFuture<?>)null);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.reschedule(this.schedule.nextDelayMs());
        }
        catch (UnsupportedProtocolVersionException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onUnsupportedProtocolVersionException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retry against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.address);
                this.currentAttempt.compareAndSet((ListenableFuture<?>)this.handlerFuture, (ListenableFuture<?>)null);
            }
        }
        catch (ClusterNameMismatchException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onClusterNameMismatchException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retry against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.address);
                this.currentAttempt.compareAndSet((ListenableFuture<?>)this.handlerFuture, (ListenableFuture<?>)null);
            }
        }
        catch (Exception e) {
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onUnknownException(e, nextDelay)) {
                this.reschedule(nextDelay);
            }
            this.currentAttempt.compareAndSet((ListenableFuture<?>)this.handlerFuture, (ListenableFuture<?>)null);
        }
    }

    private void reschedule(long nextDelay) {
        if (this.handlerFuture.isCancelled()) {
            this.currentAttempt.compareAndSet((ListenableFuture<?>)this.handlerFuture, (ListenableFuture<?>)null);
            return;
        }
        this.handlerFuture.nextTry = this.executor.schedule(this, nextDelay, TimeUnit.MILLISECONDS);
    }

    private static class HandlerFuture
    extends AbstractFuture<Void> {
        volatile ScheduledFuture<?> nextTry;

        private HandlerFuture() {
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.nextTry != null) {
                this.nextTry.cancel(mayInterruptIfRunning);
            }
            return super.cancel(mayInterruptIfRunning);
        }

        void markAsDone() {
            super.set(null);
        }
    }
}

