/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BytesToSegmentDecoder;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.Frame;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.MessageToSegmentEncoder;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SegmentCodec;
import com.datastax.driver.core.SegmentToBytesEncoder;
import com.datastax.driver.core.SegmentToFrameDecoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

public class FramingFormatHandler
extends MessageToMessageDecoder<Frame> {
    private final Connection.Factory factory;

    FramingFormatHandler(Connection.Factory factory) {
        this.factory = factory;
    }

    protected void decode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
        boolean handshakeSuccessful;
        boolean bl = handshakeSuccessful = frame.header.opcode == Message.Response.Type.READY.opcode || frame.header.opcode == Message.Response.Type.AUTHENTICATE.opcode;
        if (handshakeSuccessful) {
            if (frame.header.version.compareTo(ProtocolVersion.V5) >= 0) {
                this.switchToModernFraming(ctx);
            }
            ctx.pipeline().remove("framingFormatHandler");
        }
        out.add(frame);
    }

    private void switchToModernFraming(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        SegmentCodec segmentCodec = new SegmentCodec(ctx.channel().alloc(), this.factory.configuration.getProtocolOptions().getCompression());
        Message.ProtocolEncoder requestEncoder = (Message.ProtocolEncoder)pipeline.get("messageEncoder");
        pipeline.replace("messageEncoder", "messageToSegmentEncoder", (ChannelHandler)new MessageToSegmentEncoder(ctx.channel().alloc(), requestEncoder));
        pipeline.replace("frameEncoder", "segmentToBytesEncoder", (ChannelHandler)new SegmentToBytesEncoder(segmentCodec));
        pipeline.replace("frameDecoder", "bytesToSegmentDecoder", (ChannelHandler)new BytesToSegmentDecoder(segmentCodec));
        pipeline.addAfter("bytesToSegmentDecoder", "segmentToFrameDecoder", (ChannelHandler)new SegmentToFrameDecoder());
    }
}

