/*
 * Copyright (C) 2012-2017 DataStax Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.datastax.driver.core.exceptions;

/**
 * Thrown when a {@link com.datastax.driver.core.TypeCodec}
 * is unable to perform the requested operation (serialization,
 * deserialization, parsing or formatting) because the
 * object or the byte buffer content being processed does not
 * comply with the expected Java and/or CQL type.
 */
public class InvalidTypeException extends DriverException {

    private static final long serialVersionUID = 0;

    public InvalidTypeException(String msg) {
        super(msg);
    }

    public InvalidTypeException(String msg, Throwable cause) {
        super(msg, cause);
    }

    @Override
    public InvalidTypeException copy() {
        return new InvalidTypeException(getMessage(), this);
    }
}
