/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.ThreadingOptions;
import com.datastax.driver.core.policies.Policies;

public class Configuration {
    private final Policies policies;
    private final ProtocolOptions protocolOptions;
    private final PoolingOptions poolingOptions;
    private final SocketOptions socketOptions;
    private final MetricsOptions metricsOptions;
    private final QueryOptions queryOptions;
    private final ThreadingOptions threadingOptions;
    private final NettyOptions nettyOptions;
    private final CodecRegistry codecRegistry;

    public static Builder builder() {
        return new Builder();
    }

    private Configuration(Policies policies, ProtocolOptions protocolOptions, PoolingOptions poolingOptions, SocketOptions socketOptions, MetricsOptions metricsOptions, QueryOptions queryOptions, ThreadingOptions threadingOptions, NettyOptions nettyOptions, CodecRegistry codecRegistry) {
        this.policies = policies;
        this.protocolOptions = protocolOptions;
        this.poolingOptions = poolingOptions;
        this.socketOptions = socketOptions;
        this.metricsOptions = metricsOptions;
        this.queryOptions = queryOptions;
        this.threadingOptions = threadingOptions;
        this.nettyOptions = nettyOptions;
        this.codecRegistry = codecRegistry;
    }

    protected Configuration(Configuration toCopy) {
        this(toCopy.getPolicies(), toCopy.getProtocolOptions(), toCopy.getPoolingOptions(), toCopy.getSocketOptions(), toCopy.getMetricsOptions(), toCopy.getQueryOptions(), toCopy.getThreadingOptions(), toCopy.getNettyOptions(), toCopy.getCodecRegistry());
    }

    void register(Cluster.Manager manager) {
        this.protocolOptions.register(manager);
        this.poolingOptions.register(manager);
        this.queryOptions.register(manager);
    }

    public Policies getPolicies() {
        return this.policies;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ProtocolOptions getProtocolOptions() {
        return this.protocolOptions;
    }

    public PoolingOptions getPoolingOptions() {
        return this.poolingOptions;
    }

    public MetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public ThreadingOptions getThreadingOptions() {
        return this.threadingOptions;
    }

    public NettyOptions getNettyOptions() {
        return this.nettyOptions;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public static class Builder {
        private Policies policies;
        private ProtocolOptions protocolOptions;
        private PoolingOptions poolingOptions;
        private SocketOptions socketOptions;
        private MetricsOptions metricsOptions;
        private QueryOptions queryOptions;
        private ThreadingOptions threadingOptions;
        private NettyOptions nettyOptions;
        private CodecRegistry codecRegistry;

        public Builder withPolicies(Policies policies) {
            this.policies = policies;
            return this;
        }

        public Builder withProtocolOptions(ProtocolOptions protocolOptions) {
            this.protocolOptions = protocolOptions;
            return this;
        }

        public Builder withPoolingOptions(PoolingOptions poolingOptions) {
            this.poolingOptions = poolingOptions;
            return this;
        }

        public Builder withSocketOptions(SocketOptions socketOptions) {
            this.socketOptions = socketOptions;
            return this;
        }

        public Builder withMetricsOptions(MetricsOptions metricsOptions) {
            this.metricsOptions = metricsOptions;
            return this;
        }

        public Builder withQueryOptions(QueryOptions queryOptions) {
            this.queryOptions = queryOptions;
            return this;
        }

        public Builder withThreadingOptions(ThreadingOptions threadingOptions) {
            this.threadingOptions = threadingOptions;
            return this;
        }

        public Builder withNettyOptions(NettyOptions nettyOptions) {
            this.nettyOptions = nettyOptions;
            return this;
        }

        public Builder withCodecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = codecRegistry;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.policies != null ? this.policies : Policies.builder().build(), this.protocolOptions != null ? this.protocolOptions : new ProtocolOptions(), this.poolingOptions != null ? this.poolingOptions : new PoolingOptions(), this.socketOptions != null ? this.socketOptions : new SocketOptions(), this.metricsOptions != null ? this.metricsOptions : new MetricsOptions(), this.queryOptions != null ? this.queryOptions : new QueryOptions(), this.threadingOptions != null ? this.threadingOptions : new ThreadingOptions(), this.nettyOptions != null ? this.nettyOptions : NettyOptions.DEFAULT_INSTANCE, this.codecRegistry != null ? this.codecRegistry : CodecRegistry.DEFAULT_INSTANCE);
        }
    }
}

