/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractReconnectionHandler;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.EventDebouncer;
import com.datastax.driver.core.ExceptionCatchingRunnable;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolEvent;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.SystemProperties;
import com.datastax.driver.core.ThreadingOptions;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.BusyConnectionException;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.UnsupportedProtocolVersionException;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.utils.MoreFutures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Cluster.class);
    @VisibleForTesting
    static final int NEW_NODE_DELAY_SECONDS;
    private static final ResourceBundle driverProperties;
    private static final AtomicInteger CLUSTER_ID;
    private static final int NOTIF_LOCK_TIMEOUT_SECONDS;
    final Manager manager;

    protected Cluster(String name, List<InetSocketAddress> contactPoints, Configuration configuration) {
        this(name, contactPoints, configuration, Collections.emptySet());
    }

    protected Cluster(Initializer initializer) {
        this(initializer.getClusterName(), Cluster.checkNotEmpty(initializer.getContactPoints()), initializer.getConfiguration(), initializer.getInitialListeners());
    }

    private static List<InetSocketAddress> checkNotEmpty(List<InetSocketAddress> contactPoints) {
        if (contactPoints.isEmpty()) {
            throw new IllegalArgumentException("Cannot build a cluster without contact points");
        }
        return contactPoints;
    }

    private Cluster(String name, List<InetSocketAddress> contactPoints, Configuration configuration, Collection<Host.StateListener> listeners) {
        this.manager = new Manager(name, contactPoints, configuration, listeners);
    }

    public Cluster init() {
        this.manager.init();
        return this;
    }

    public static Cluster buildFrom(Initializer initializer) {
        return new Cluster(initializer);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String getDriverVersion() {
        return driverProperties.getString("driver.version");
    }

    public Session newSession() {
        Cluster.checkNotClosed(this.manager);
        return this.manager.newSession();
    }

    public Session connect() {
        try {
            return (Session)Uninterruptibles.getUninterruptibly(this.connectAsync());
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public Session connect(String keyspace) {
        try {
            return (Session)Uninterruptibles.getUninterruptibly(this.connectAsync(keyspace));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<Session> connectAsync() {
        return this.connectAsync(null);
    }

    public ListenableFuture<Session> connectAsync(String keyspace) {
        Cluster.checkNotClosed(this.manager);
        this.init();
        final Session session = this.manager.newSession();
        ListenableFuture<Session> sessionInitialized = session.initAsync();
        if (keyspace == null) {
            return sessionInitialized;
        }
        final String useQuery = "USE " + keyspace;
        ListenableFuture<ResultSet> keyspaceSet = GuavaCompatibility.INSTANCE.transformAsync(sessionInitialized, new AsyncFunction<Session, ResultSet>(){

            public ListenableFuture<ResultSet> apply(Session session) throws Exception {
                return session.executeAsync(useQuery);
            }
        });
        ListenableFuture<ResultSet> withErrorHandling = GuavaCompatibility.INSTANCE.withFallback(keyspaceSet, new AsyncFunction<Throwable, ResultSet>(){

            public ListenableFuture<ResultSet> apply(Throwable t) throws Exception {
                session.closeAsync();
                if (t instanceof SyntaxError) {
                    SyntaxError e = (SyntaxError)t;
                    t = new SyntaxError(e.getAddress(), String.format("Error executing \"%s\" (%s). Check that your keyspace name is valid", useQuery, e.getMessage()));
                }
                throw Throwables.propagate((Throwable)t);
            }
        });
        return Futures.transform(withErrorHandling, (Function)Functions.constant((Object)session));
    }

    public String getClusterName() {
        return this.manager.clusterName;
    }

    public Metadata getMetadata() {
        this.manager.init();
        return this.manager.metadata;
    }

    public Configuration getConfiguration() {
        return this.manager.configuration;
    }

    public Metrics getMetrics() {
        Cluster.checkNotClosed(this.manager);
        return this.manager.metrics;
    }

    public Cluster register(Host.StateListener listener) {
        Cluster.checkNotClosed(this.manager);
        boolean added = this.manager.listeners.add(listener);
        if (added) {
            listener.onRegister(this);
        }
        return this;
    }

    public Cluster unregister(Host.StateListener listener) {
        Cluster.checkNotClosed(this.manager);
        boolean removed = this.manager.listeners.remove(listener);
        if (removed) {
            listener.onUnregister(this);
        }
        return this;
    }

    public Cluster register(LatencyTracker tracker) {
        Cluster.checkNotClosed(this.manager);
        boolean added = this.manager.latencyTrackers.add(tracker);
        if (added) {
            tracker.onRegister(this);
        }
        return this;
    }

    public Cluster unregister(LatencyTracker tracker) {
        Cluster.checkNotClosed(this.manager);
        boolean removed = this.manager.latencyTrackers.remove(tracker);
        if (removed) {
            tracker.onUnregister(this);
        }
        return this;
    }

    public Cluster register(SchemaChangeListener listener) {
        Cluster.checkNotClosed(this.manager);
        boolean added = this.manager.schemaChangeListeners.add(listener);
        if (added) {
            listener.onRegister(this);
        }
        return this;
    }

    public Cluster unregister(SchemaChangeListener listener) {
        Cluster.checkNotClosed(this.manager);
        boolean removed = this.manager.schemaChangeListeners.remove(listener);
        if (removed) {
            listener.onUnregister(this);
        }
        return this;
    }

    public CloseFuture closeAsync() {
        return this.manager.close();
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isClosed() {
        return this.manager.closeFuture.get() != null;
    }

    private static void checkNotClosed(Manager manager) {
        if (manager.isClosed()) {
            throw new IllegalStateException("Can't use this cluster instance because it was previously closed");
        }
    }

    static long timeSince(long startNanos, TimeUnit destUnit) {
        return destUnit.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
    }

    private static String generateClusterName() {
        return "cluster" + CLUSTER_ID.incrementAndGet();
    }

    static {
        GuavaCompatibility.init();
        NEW_NODE_DELAY_SECONDS = SystemProperties.getInt("com.datastax.driver.NEW_NODE_DELAY_SECONDS", 1);
        driverProperties = ResourceBundle.getBundle("com.datastax.driver.core.Driver");
        CLUSTER_ID = new AtomicInteger(0);
        NOTIF_LOCK_TIMEOUT_SECONDS = SystemProperties.getInt("com.datastax.driver.NOTIF_LOCK_TIMEOUT_SECONDS", 60);
    }

    static class ConnectionReaper {
        private static final int INTERVAL_MS = 15000;
        private final ScheduledExecutorService executor;
        @VisibleForTesting
        final Map<Connection, Long> connections = new ConcurrentHashMap<Connection, Long>();
        private volatile boolean shutdown;
        private final Runnable reaperTask = new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<Connection, Long>> iterator = ConnectionReaper.this.connections.entrySet().iterator();
                while (iterator.hasNext()) {
                    boolean terminated;
                    Map.Entry<Connection, Long> entry = iterator.next();
                    Connection connection = entry.getKey();
                    Long terminateTime = entry.getValue();
                    if (terminateTime > now || !(terminated = connection.tryTerminate(true))) continue;
                    iterator.remove();
                }
            }
        };

        ConnectionReaper(ScheduledExecutorService executor) {
            this.executor = executor;
            this.executor.scheduleWithFixedDelay(this.reaperTask, 15000L, 15000L, TimeUnit.MILLISECONDS);
        }

        void register(Connection connection, long terminateTime) {
            if (this.shutdown) {
                logger.warn("Connection registered after reaper shutdown: {}", (Object)connection);
                connection.tryTerminate(true);
            } else {
                this.connections.put(connection, terminateTime);
            }
        }

        void shutdown() {
            this.shutdown = true;
            this.executor.shutdownNow();
            this.reaperTask.run();
        }
    }

    private static enum HostEvent {
        UP,
        DOWN,
        ADDED,
        REMOVED;

    }

    class Manager
    implements Connection.DefaultResponseHandler {
        final String clusterName;
        private boolean isInit;
        private volatile boolean isFullyInit;
        final List<InetSocketAddress> contactPoints;
        final Set<SessionManager> sessions = new CopyOnWriteArraySet<SessionManager>();
        Metadata metadata;
        final Configuration configuration;
        Metrics metrics;
        Connection.Factory connectionFactory;
        ControlConnection controlConnection;
        final ConvictionPolicy.Factory convictionPolicyFactory = new ConvictionPolicy.DefaultConvictionPolicy.Factory();
        ListeningExecutorService executor;
        ListeningExecutorService blockingExecutor;
        ScheduledExecutorService reconnectionExecutor;
        ScheduledExecutorService scheduledTasksExecutor;
        BlockingQueue<Runnable> executorQueue;
        BlockingQueue<Runnable> blockingExecutorQueue;
        BlockingQueue<Runnable> reconnectionExecutorQueue;
        BlockingQueue<Runnable> scheduledTasksExecutorQueue;
        ConnectionReaper reaper;
        final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
        ConcurrentMap<MD5Digest, PreparedStatement> preparedQueries;
        final Set<Host.StateListener> listeners;
        final Set<LatencyTracker> latencyTrackers = new CopyOnWriteArraySet<LatencyTracker>();
        final Set<SchemaChangeListener> schemaChangeListeners = new CopyOnWriteArraySet<SchemaChangeListener>();
        EventDebouncer<NodeListRefreshRequest> nodeListRefreshRequestDebouncer;
        EventDebouncer<NodeRefreshRequest> nodeRefreshRequestDebouncer;
        EventDebouncer<SchemaRefreshRequest> schemaRefreshRequestDebouncer;

        private Manager(String clusterName, List<InetSocketAddress> contactPoints, Configuration configuration, Collection<Host.StateListener> listeners) {
            this.clusterName = clusterName == null ? Cluster.generateClusterName() : clusterName;
            this.configuration = configuration;
            this.contactPoints = contactPoints;
            this.listeners = new CopyOnWriteArraySet<Host.StateListener>(listeners);
        }

        synchronized void init() {
            Cluster.checkNotClosed(this);
            if (this.isInit) {
                return;
            }
            this.isInit = true;
            logger.debug("Starting new cluster with contact points " + this.contactPoints);
            this.configuration.register(this);
            ThreadingOptions threadingOptions = this.configuration.getThreadingOptions();
            ExecutorService tmpExecutor = threadingOptions.createExecutor(this.clusterName);
            this.executorQueue = tmpExecutor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)tmpExecutor).getQueue() : null;
            this.executor = MoreExecutors.listeningDecorator((ExecutorService)tmpExecutor);
            ExecutorService tmpBlockingExecutor = threadingOptions.createBlockingExecutor(this.clusterName);
            this.blockingExecutorQueue = tmpBlockingExecutor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)tmpBlockingExecutor).getQueue() : null;
            this.blockingExecutor = MoreExecutors.listeningDecorator((ExecutorService)tmpBlockingExecutor);
            this.reconnectionExecutor = threadingOptions.createReconnectionExecutor(this.clusterName);
            this.reconnectionExecutorQueue = this.reconnectionExecutor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)((Object)this.reconnectionExecutor)).getQueue() : null;
            this.scheduledTasksExecutor = threadingOptions.createScheduledTasksExecutor(this.clusterName);
            this.scheduledTasksExecutorQueue = this.scheduledTasksExecutor instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)((Object)this.scheduledTasksExecutor)).getQueue() : null;
            this.reaper = new ConnectionReaper(threadingOptions.createReaperExecutor(this.clusterName));
            this.metadata = new Metadata(this);
            this.connectionFactory = new Connection.Factory(this, this.configuration);
            this.controlConnection = new ControlConnection(this);
            this.metrics = this.configuration.getMetricsOptions().isEnabled() ? new Metrics(this) : null;
            this.preparedQueries = new MapMaker().weakValues().makeMap();
            QueryOptions queryOptions = this.configuration.getQueryOptions();
            this.nodeListRefreshRequestDebouncer = new EventDebouncer<NodeListRefreshRequest>("Node list refresh", this.scheduledTasksExecutor, (EventDebouncer.DeliveryCallback)new NodeListRefreshRequestDeliveryCallback()){

                @Override
                int maxPendingEvents() {
                    return Manager.this.configuration.getQueryOptions().getMaxPendingRefreshNodeListRequests();
                }

                @Override
                long delayMs() {
                    return Manager.this.configuration.getQueryOptions().getRefreshNodeListIntervalMillis();
                }
            };
            this.nodeRefreshRequestDebouncer = new EventDebouncer<NodeRefreshRequest>("Node refresh", this.scheduledTasksExecutor, (EventDebouncer.DeliveryCallback)new NodeRefreshRequestDeliveryCallback()){

                @Override
                int maxPendingEvents() {
                    return Manager.this.configuration.getQueryOptions().getMaxPendingRefreshNodeRequests();
                }

                @Override
                long delayMs() {
                    return Manager.this.configuration.getQueryOptions().getRefreshNodeIntervalMillis();
                }
            };
            this.schemaRefreshRequestDebouncer = new EventDebouncer<SchemaRefreshRequest>("Schema refresh", this.scheduledTasksExecutor, (EventDebouncer.DeliveryCallback)new SchemaRefreshRequestDeliveryCallback()){

                @Override
                int maxPendingEvents() {
                    return Manager.this.configuration.getQueryOptions().getMaxPendingRefreshSchemaRequests();
                }

                @Override
                long delayMs() {
                    return Manager.this.configuration.getQueryOptions().getRefreshSchemaIntervalMillis();
                }
            };
            this.scheduledTasksExecutor.scheduleWithFixedDelay(new CleanupIdleConnectionsTask(), 10L, 10L, TimeUnit.SECONDS);
            for (InetSocketAddress address : this.contactPoints) {
                this.metadata.add(address);
            }
            Collection<Host> allHosts = this.metadata.allHosts();
            HashSet contactPointHosts = Sets.newHashSet(allHosts);
            try {
                this.negotiateProtocolVersionAndConnect();
                HashSet downContactPointHosts = Sets.newHashSet();
                HashSet removedContactPointHosts = Sets.newHashSet();
                for (Host host : contactPointHosts) {
                    if (!allHosts.contains(host)) {
                        removedContactPointHosts.add(host);
                        continue;
                    }
                    if (host.state != Host.State.DOWN) continue;
                    downContactPointHosts.add(host);
                }
                contactPointHosts.removeAll(removedContactPointHosts);
                contactPointHosts.removeAll(downContactPointHosts);
                this.loadBalancingPolicy().init(Cluster.this, contactPointHosts);
                this.speculativeExecutionPolicy().init(Cluster.this);
                this.configuration.getPolicies().getRetryPolicy().init(Cluster.this);
                this.reconnectionPolicy().init(Cluster.this);
                this.configuration.getPolicies().getAddressTranslator().init(Cluster.this);
                for (LatencyTracker tracker : this.latencyTrackers) {
                    tracker.onRegister(Cluster.this);
                }
                for (Host.StateListener listener : this.listeners) {
                    listener.onRegister(Cluster.this);
                }
                for (Host host : removedContactPointHosts) {
                    this.loadBalancingPolicy().onRemove(host);
                    for (Host.StateListener listener : this.listeners) {
                        listener.onRemove(host);
                    }
                }
                for (Host host : downContactPointHosts) {
                    this.loadBalancingPolicy().onDown(host);
                    for (Host.StateListener listener : this.listeners) {
                        listener.onDown(host);
                    }
                    this.startPeriodicReconnectionAttempt(host, true);
                }
                this.configuration.getPoolingOptions().setProtocolVersion(this.protocolVersion());
                for (Host host : allHosts) {
                    if (host.state == Host.State.DOWN) continue;
                    logger.info("New Cassandra host {} added", (Object)host);
                    if (!host.supports(this.connectionFactory.protocolVersion)) {
                        this.logUnsupportedVersionProtocol(host, this.connectionFactory.protocolVersion);
                        continue;
                    }
                    if (!contactPointHosts.contains(host)) {
                        this.loadBalancingPolicy().onAdd(host);
                    }
                    host.setUp();
                    for (Host.StateListener listener : this.listeners) {
                        listener.onAdd(host);
                    }
                }
                this.nodeListRefreshRequestDebouncer.start();
                this.schemaRefreshRequestDebouncer.start();
                this.nodeRefreshRequestDebouncer.start();
                this.isFullyInit = true;
            }
            catch (NoHostAvailableException e) {
                this.close();
                throw e;
            }
        }

        private void negotiateProtocolVersionAndConnect() {
            boolean shouldNegotiate = this.configuration.getProtocolOptions().initialProtocolVersion == null;
            while (true) {
                try {
                    this.controlConnection.connect();
                    return;
                }
                catch (UnsupportedProtocolVersionException e) {
                    if (!shouldNegotiate) {
                        throw e;
                    }
                    ProtocolVersion attemptedVersion = e.getUnsupportedVersion();
                    ProtocolVersion retryVersion = attemptedVersion.getLowerSupported();
                    if (retryVersion == null) {
                        throw e;
                    }
                    logger.info("Cannot connect with protocol version {}, trying with {}", (Object)attemptedVersion, (Object)retryVersion);
                    this.connectionFactory.protocolVersion = retryVersion;
                    continue;
                }
                break;
            }
        }

        ProtocolVersion protocolVersion() {
            return this.connectionFactory.protocolVersion;
        }

        Cluster getCluster() {
            return Cluster.this;
        }

        LoadBalancingPolicy loadBalancingPolicy() {
            return this.configuration.getPolicies().getLoadBalancingPolicy();
        }

        SpeculativeExecutionPolicy speculativeExecutionPolicy() {
            return this.configuration.getPolicies().getSpeculativeExecutionPolicy();
        }

        ReconnectionPolicy reconnectionPolicy() {
            return this.configuration.getPolicies().getReconnectionPolicy();
        }

        InetSocketAddress translateAddress(InetAddress address) {
            InetSocketAddress sa = new InetSocketAddress(address, this.connectionFactory.getPort());
            InetSocketAddress translated = this.configuration.getPolicies().getAddressTranslator().translate(sa);
            return translated == null ? sa : translated;
        }

        private Session newSession() {
            SessionManager session = new SessionManager(Cluster.this);
            this.sessions.add(session);
            return session;
        }

        boolean removeSession(Session session) {
            return this.sessions.remove(session);
        }

        void reportQuery(Host host, Statement statement, Exception exception, long latencyNanos) {
            for (LatencyTracker tracker : this.latencyTrackers) {
                tracker.update(host, statement, exception, latencyNanos);
            }
        }

        boolean isClosed() {
            return this.closeFuture.get() != null;
        }

        private CloseFuture close() {
            CloseFuture future = this.closeFuture.get();
            if (future != null) {
                return future;
            }
            if (this.isInit) {
                logger.debug("Shutting down");
                this.nodeListRefreshRequestDebouncer.stop();
                this.nodeRefreshRequestDebouncer.stop();
                this.schemaRefreshRequestDebouncer.stop();
                this.shutdownNow(this.reconnectionExecutor);
                this.shutdownNow(this.scheduledTasksExecutor);
                this.shutdownNow((ExecutorService)this.blockingExecutor);
                this.executor.shutdown();
                if (this.metrics != null) {
                    this.metrics.shutdown();
                }
                this.loadBalancingPolicy().close();
                this.speculativeExecutionPolicy().close();
                this.configuration.getPolicies().getRetryPolicy().close();
                this.reconnectionPolicy().close();
                this.configuration.getPolicies().getAddressTranslator().close();
                for (LatencyTracker latencyTracker : this.latencyTrackers) {
                    latencyTracker.onUnregister(Cluster.this);
                }
                for (Host.StateListener stateListener : this.listeners) {
                    stateListener.onUnregister(Cluster.this);
                }
                for (SchemaChangeListener schemaChangeListener : this.schemaChangeListeners) {
                    schemaChangeListener.onUnregister(Cluster.this);
                }
                ArrayList<CloseFuture> futures = new ArrayList<CloseFuture>(this.sessions.size() + 1);
                futures.add(this.controlConnection.closeAsync());
                for (Session session : this.sessions) {
                    futures.add(session.closeAsync());
                }
                future = new ClusterCloseFuture(futures);
            } else {
                future = CloseFuture.immediateFuture();
            }
            return this.closeFuture.compareAndSet(null, future) ? future : this.closeFuture.get();
        }

        private void shutdownNow(ExecutorService executor) {
            List<Runnable> pendingTasks = executor.shutdownNow();
            for (Runnable pendingTask : pendingTasks) {
                if (!(pendingTask instanceof FutureTask)) continue;
                ((FutureTask)pendingTask).cancel(false);
            }
        }

        void logUnsupportedVersionProtocol(Host host, ProtocolVersion version) {
            logger.warn("Detected added or restarted Cassandra host {} but ignoring it since it does not support the version {} of the native protocol which is currently in use. If you want to force the use of a particular version of the native protocol, use Cluster.Builder#usingProtocolVersion() when creating the Cluster instance.", (Object)host, (Object)version);
        }

        void logClusterNameMismatch(Host host, String expectedClusterName, String actualClusterName) {
            logger.warn("Detected added or restarted Cassandra host {} but ignoring it since its cluster name '{}' does not match the one currently known ({})", new Object[]{host, actualClusterName, expectedClusterName});
        }

        public ListenableFuture<?> triggerOnUp(final Host host) {
            if (!this.isClosed()) {
                return this.executor.submit((Runnable)new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.onUp(host, null);
                    }
                });
            }
            return MoreFutures.VOID_SUCCESS;
        }

        /*
         * Exception decompiling
         */
        private void onUp(Host host, Connection reusedConnection) throws InterruptedException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public ListenableFuture<?> triggerOnDown(Host host, boolean startReconnection) {
            return this.triggerOnDown(host, false, startReconnection);
        }

        public ListenableFuture<?> triggerOnDown(final Host host, final boolean isHostAddition, final boolean startReconnection) {
            if (!this.isClosed()) {
                return this.executor.submit((Runnable)new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.onDown(host, isHostAddition, startReconnection);
                    }
                });
            }
            return MoreFutures.VOID_SUCCESS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDown(Host host, boolean isHostAddition, boolean startReconnection) throws InterruptedException, ExecutionException {
            if (this.isClosed()) {
                return;
            }
            boolean locked = host.notificationsLock.tryLock(NOTIF_LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            if (!locked) {
                logger.warn("Could not acquire notifications lock within {} seconds, ignoring DOWN notification for {}", (Object)NOTIF_LOCK_TIMEOUT_SECONDS, (Object)host);
                return;
            }
            try {
                if (host.reconnectionAttempt.get() != null) {
                    logger.debug("Aborting onDown because a reconnection is running on DOWN host {}", (Object)host);
                    return;
                }
                Host.statesLogger.debug("[{}] marking host DOWN", (Object)host);
                HostDistance distance = this.loadBalancingPolicy().distance(host);
                boolean wasUp = host.isUp();
                host.setDown();
                this.loadBalancingPolicy().onDown(host);
                this.controlConnection.onDown(host);
                for (SessionManager s : this.sessions) {
                    s.onDown(host);
                }
                if (wasUp) {
                    for (Host.StateListener listener : this.listeners) {
                        listener.onDown(host);
                    }
                }
                if (distance == HostDistance.IGNORED || !startReconnection) {
                    return;
                }
                this.startPeriodicReconnectionAttempt(host, isHostAddition);
            }
            finally {
                host.notificationsLock.unlock();
            }
        }

        void startPeriodicReconnectionAttempt(final Host host, final boolean isHostAddition) {
            new AbstractReconnectionHandler(host.toString(), this.reconnectionExecutor, this.reconnectionPolicy().newSchedule(), host.reconnectionAttempt){

                @Override
                protected Connection tryReconnect() throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
                    return Manager.this.connectionFactory.open(host);
                }

                @Override
                protected void onReconnection(Connection connection) {
                    block6: {
                        if (Manager.this.controlConnection.refreshNodeInfo(host)) {
                            logger.debug("Successful reconnection to {}, setting host UP", (Object)host);
                            try {
                                if (isHostAddition) {
                                    Manager.this.onAdd(host, connection);
                                    Manager.this.submitNodeListRefresh();
                                    break block6;
                                }
                                Manager.this.onUp(host, connection);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (Exception e) {
                                logger.error("Unexpected error while setting node up", (Throwable)e);
                            }
                        } else {
                            logger.debug("Not enough info for {}, ignoring host", (Object)host);
                            connection.closeAsync();
                        }
                    }
                }

                @Override
                protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed reconnection to {} ({}), scheduling retry in {} milliseconds", new Object[]{host, e.getMessage(), nextDelayMs});
                    }
                    return true;
                }

                @Override
                protected boolean onUnknownException(Exception e, long nextDelayMs) {
                    logger.error(String.format("Unknown error during reconnection to %s, scheduling retry in %d milliseconds", host, nextDelayMs), (Throwable)e);
                    return true;
                }

                @Override
                protected boolean onAuthenticationException(AuthenticationException e, long nextDelayMs) {
                    logger.error(String.format("Authentication error during reconnection to %s, scheduling retry in %d milliseconds", host, nextDelayMs), (Throwable)e);
                    return true;
                }
            }.start();
        }

        void startSingleReconnectionAttempt(final Host host) {
            if (this.isClosed() || host.isUp()) {
                return;
            }
            logger.debug("Scheduling one-time reconnection to {}", (Object)host);
            new AbstractReconnectionHandler(host.toString(), this.reconnectionExecutor, this.reconnectionPolicy().newSchedule(), host.reconnectionAttempt, 0L){

                @Override
                protected Connection tryReconnect() throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
                    return Manager.this.connectionFactory.open(host);
                }

                @Override
                protected void onReconnection(Connection connection) {
                    if (Manager.this.controlConnection.refreshNodeInfo(host)) {
                        logger.debug("Successful reconnection to {}, setting host UP", (Object)host);
                        try {
                            Manager.this.onUp(host, connection);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            logger.error("Unexpected error while setting node up", (Throwable)e);
                        }
                    } else {
                        logger.debug("Not enough info for {}, ignoring host", (Object)host);
                        connection.closeAsync();
                    }
                }

                @Override
                protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed one-time reconnection to {} ({})", (Object)host, (Object)e.getMessage());
                    }
                    return false;
                }

                @Override
                protected boolean onUnknownException(Exception e, long nextDelayMs) {
                    logger.error(String.format("Unknown error during one-time reconnection to %s", host), (Throwable)e);
                    return false;
                }

                @Override
                protected boolean onAuthenticationException(AuthenticationException e, long nextDelayMs) {
                    logger.error(String.format("Authentication error during one-time reconnection to %s", host), (Throwable)e);
                    return false;
                }
            }.start();
        }

        public ListenableFuture<?> triggerOnAdd(final Host host) {
            if (!this.isClosed()) {
                return this.executor.submit((Runnable)new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.onAdd(host, null);
                    }
                });
            }
            return MoreFutures.VOID_SUCCESS;
        }

        /*
         * Exception decompiling
         */
        private void onAdd(Host host, Connection reusedConnection) throws InterruptedException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public ListenableFuture<?> triggerOnRemove(final Host host) {
            if (!this.isClosed()) {
                return this.executor.submit((Runnable)new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.onRemove(host);
                    }
                });
            }
            return MoreFutures.VOID_SUCCESS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRemove(Host host) throws InterruptedException, ExecutionException {
            if (this.isClosed()) {
                return;
            }
            boolean locked = host.notificationsLock.tryLock(NOTIF_LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            if (!locked) {
                logger.warn("Could not acquire notifications lock within {} seconds, ignoring REMOVE notification for {}", (Object)NOTIF_LOCK_TIMEOUT_SECONDS, (Object)host);
                return;
            }
            try {
                host.setDown();
                Host.statesLogger.debug("[{}] removing host", (Object)host);
                this.loadBalancingPolicy().onRemove(host);
                this.controlConnection.onRemove(host);
                for (SessionManager s : this.sessions) {
                    s.onRemove(host);
                }
                for (Host.StateListener listener : this.listeners) {
                    listener.onRemove(host);
                }
            }
            finally {
                host.notificationsLock.unlock();
            }
        }

        public void signalHostDown(Host host, boolean isHostAddition) {
            if (!this.isFullyInit || this.isClosed()) {
                return;
            }
            this.triggerOnDown(host, isHostAddition, true);
        }

        public void removeHost(Host host, boolean isInitialConnection) {
            if (host == null) {
                return;
            }
            if (this.metadata.remove(host)) {
                if (isInitialConnection) {
                    logger.warn("You listed {} in your contact points, but it wasn't found in the control host's system.peers at startup", (Object)host);
                } else {
                    logger.info("Cassandra host {} removed", (Object)host);
                    this.triggerOnRemove(host);
                }
            }
        }

        public void ensurePoolsSizing() {
            if (this.protocolVersion().compareTo(ProtocolVersion.V3) >= 0) {
                return;
            }
            for (SessionManager session : this.sessions) {
                for (HostConnectionPool pool : session.pools.values()) {
                    pool.ensureCoreConnections();
                }
            }
        }

        public PreparedStatement addPrepared(PreparedStatement stmt) {
            PreparedStatement previous = this.preparedQueries.putIfAbsent(stmt.getPreparedId().id, stmt);
            if (previous != null) {
                logger.warn("Re-preparing already prepared query {}. Please note that preparing the same query more than once is generally an anti-pattern and will likely affect performance. Consider preparing the statement only once.", (Object)stmt.getQueryString());
                return previous;
            }
            return stmt;
        }

        private Connection prepareAllQueries(Host host, Connection reusedConnection) throws InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
            if (this.preparedQueries.isEmpty()) {
                return reusedConnection;
            }
            logger.debug("Preparing {} prepared queries on newly up node {}", (Object)this.preparedQueries.size(), (Object)host);
            Connection connection = null;
            try {
                connection = reusedConnection == null ? this.connectionFactory.open(host) : reusedConnection;
                try {
                    ControlConnection.waitForSchemaAgreement(connection, this);
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                HashMultimap perKeyspace = HashMultimap.create();
                for (PreparedStatement ps : this.preparedQueries.values()) {
                    String keyspace = ps.getQueryKeyspace() == null ? "" : ps.getQueryKeyspace();
                    perKeyspace.put((Object)keyspace, (Object)ps.getQueryString());
                }
                for (String keyspace : perKeyspace.keySet()) {
                    if (!keyspace.isEmpty()) {
                        connection.setKeyspace(keyspace);
                    }
                    ArrayList<Connection.Future> futures = new ArrayList<Connection.Future>(this.preparedQueries.size());
                    for (String query : perKeyspace.get((Object)keyspace)) {
                        futures.add(connection.write(new Requests.Prepare(query)));
                    }
                    for (Connection.Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (ExecutionException e) {
                            logger.debug("Unexpected error while preparing queries on new/newly up host", (Throwable)e);
                        }
                    }
                }
                return connection;
            }
            catch (ConnectionException e) {
                if (connection != null) {
                    connection.closeAsync();
                }
                return null;
            }
            catch (AuthenticationException e) {
                if (connection != null) {
                    connection.closeAsync();
                }
                return null;
            }
            catch (BusyConnectionException e) {
                if (connection != null) {
                    connection.closeAsync();
                }
                return null;
            }
        }

        ListenableFuture<Void> submitSchemaRefresh(SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature) {
            SchemaRefreshRequest request = new SchemaRefreshRequest(targetType, targetKeyspace, targetName, targetSignature);
            logger.trace("Submitting schema refresh: {}", (Object)request);
            return this.schemaRefreshRequestDebouncer.eventReceived(request);
        }

        ListenableFuture<Void> submitNodeListRefresh() {
            logger.trace("Submitting node list and token map refresh");
            return this.nodeListRefreshRequestDebouncer.eventReceived(new NodeListRefreshRequest());
        }

        ListenableFuture<Void> submitNodeRefresh(InetSocketAddress address, HostEvent eventType) {
            NodeRefreshRequest request = new NodeRefreshRequest(address, eventType);
            logger.trace("Submitting node refresh: {}", (Object)request);
            return this.nodeRefreshRequestDebouncer.eventReceived(request);
        }

        public void refreshSchemaAndSignal(Connection connection, DefaultResultSetFuture future, ResultSet rs, SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature) {
            if (logger.isDebugEnabled()) {
                logger.debug("Refreshing schema for {}{}", (Object)(targetType == null ? "everything" : targetKeyspace), (Object)(targetType == SchemaElement.KEYSPACE ? "" : "." + targetName + " (" + (Object)((Object)targetType) + ")"));
            }
            this.maybeRefreshSchemaAndSignal(connection, future, rs, targetType, targetKeyspace, targetName, targetSignature);
        }

        public void waitForSchemaAgreementAndSignal(Connection connection, DefaultResultSetFuture future, ResultSet rs) {
            this.maybeRefreshSchemaAndSignal(connection, future, rs, null, null, null, null);
        }

        private void maybeRefreshSchemaAndSignal(final Connection connection, final DefaultResultSetFuture future, final ResultSet rs, final SchemaElement targetType, final String targetKeyspace, final String targetName, final List<String> targetSignature) {
            final boolean refreshSchema = targetKeyspace != null;
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    boolean schemaInAgreement = false;
                    try {
                        ListenableFuture<Void> schemaReady;
                        schemaInAgreement = ControlConnection.waitForSchemaAgreement(connection, Manager.this);
                        if (!schemaInAgreement) {
                            logger.warn("No schema agreement from live replicas after {} s. The schema may not be up to date on some nodes.", (Object)Manager.this.configuration.getProtocolOptions().getMaxSchemaAgreementWaitSeconds());
                        }
                        if (refreshSchema) {
                            schemaReady = Manager.this.submitSchemaRefresh(targetType, targetKeyspace, targetName, targetSignature);
                            if (!schemaReady.isDone()) {
                                Manager.this.schemaRefreshRequestDebouncer.scheduleImmediateDelivery();
                            }
                        } else {
                            schemaReady = MoreFutures.VOID_SUCCESS;
                        }
                        final boolean finalSchemaInAgreement = schemaInAgreement;
                        schemaReady.addListener(new Runnable(){

                            @Override
                            public void run() {
                                rs.getExecutionInfo().setSchemaInAgreement(finalSchemaInAgreement);
                                future.setResult(rs);
                            }
                        }, GuavaCompatibility.INSTANCE.sameThreadExecutor());
                    }
                    catch (Exception e) {
                        logger.warn("Error while waiting for schema agreement", (Throwable)e);
                        rs.getExecutionInfo().setSchemaInAgreement(schemaInAgreement);
                        future.setResult(rs);
                    }
                }
            });
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void handle(Message.Response response) {
            block29: {
                if (!(response instanceof Responses.Event)) {
                    Cluster.access$500().error("Received an unexpected message from the server: {}", (Object)response);
                    return;
                }
                event = ((Responses.Event)response).event;
                Cluster.access$500().debug("Received event {}, scheduling delivery", (Object)response);
                block0 : switch (3.$SwitchMap$com$datastax$driver$core$ProtocolEvent$Type[event.type.ordinal()]) {
                    case 1: {
                        tpc = (ProtocolEvent.TopologyChange)event;
                        tpAddr = this.translateAddress(tpc.node.getAddress());
                        Host.statesLogger.debug("[{}] received event {}", (Object)tpAddr, (Object)tpc.change);
                        switch (3.$SwitchMap$com$datastax$driver$core$ProtocolEvent$TopologyChange$Change[tpc.change.ordinal()]) {
                            case 1: {
                                this.submitNodeRefresh(tpAddr, HostEvent.ADDED);
                                break;
                            }
                            case 2: {
                                this.submitNodeRefresh(tpAddr, HostEvent.REMOVED);
                                break;
                            }
                            case 3: {
                                this.submitNodeListRefresh();
                            }
                        }
                        break;
                    }
                    case 2: {
                        stc = (ProtocolEvent.StatusChange)event;
                        stAddr = this.translateAddress(stc.node.getAddress());
                        Host.statesLogger.debug("[{}] received event {}", (Object)stAddr, (Object)stc.status);
                        switch (3.$SwitchMap$com$datastax$driver$core$ProtocolEvent$StatusChange$Status[stc.status.ordinal()]) {
                            case 1: {
                                this.submitNodeRefresh(stAddr, HostEvent.UP);
                                break;
                            }
                            case 2: {
                                this.submitNodeRefresh(stAddr, HostEvent.DOWN);
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!this.configuration.getQueryOptions().isMetadataEnabled()) {
                            return;
                        }
                        scc = (ProtocolEvent.SchemaChange)event;
                        switch (3.$SwitchMap$com$datastax$driver$core$ProtocolEvent$SchemaChange$Change[scc.change.ordinal()]) {
                            case 1: 
                            case 2: {
                                this.submitSchemaRefresh(scc.targetType, scc.targetKeyspace, scc.targetName, scc.targetSignature);
                                break block0;
                            }
                            case 3: {
                                if (scc.targetType != SchemaElement.KEYSPACE) ** GOTO lbl56
                                removedKeyspace = Cluster.this.manager.metadata.removeKeyspace(scc.targetKeyspace);
                                if (removedKeyspace != null) {
                                    this.executor.submit(new Runnable(){

                                        @Override
                                        public void run() {
                                            Cluster.this.manager.metadata.triggerOnKeyspaceRemoved(removedKeyspace);
                                        }
                                    });
                                    break block0;
                                }
                                break block29;
lbl56:
                                // 1 sources

                                keyspace = (KeyspaceMetadata)Cluster.this.manager.metadata.keyspaces.get(scc.targetKeyspace);
                                if (keyspace == null) {
                                    Cluster.access$500().warn("Received a DROPPED notification for {} {}.{}, but this keyspace is unknown in our metadata", new Object[]{scc.targetType, scc.targetKeyspace, scc.targetName});
                                    break block0;
                                }
                                switch (3.$SwitchMap$com$datastax$driver$core$SchemaElement[scc.targetType.ordinal()]) {
                                    case 1: {
                                        removedTable = keyspace.removeTable(scc.targetName);
                                        if (removedTable != null) {
                                            this.executor.submit(new Runnable(){

                                                @Override
                                                public void run() {
                                                    Cluster.this.manager.metadata.triggerOnTableRemoved(removedTable);
                                                }
                                            });
                                            break block0;
                                        }
                                        removedView = keyspace.removeMaterializedView(scc.targetName);
                                        if (removedView == null) break block0;
                                        this.executor.submit(new Runnable(){

                                            @Override
                                            public void run() {
                                                Cluster.this.manager.metadata.triggerOnMaterializedViewRemoved(removedView);
                                            }
                                        });
                                        break block0;
                                    }
                                    case 2: {
                                        removedType = keyspace.removeUserType(scc.targetName);
                                        if (removedType == null) break block0;
                                        this.executor.submit(new Runnable(){

                                            @Override
                                            public void run() {
                                                Cluster.this.manager.metadata.triggerOnUserTypeRemoved(removedType);
                                            }
                                        });
                                        break block0;
                                    }
                                    case 3: {
                                        removedFunction = keyspace.removeFunction(Metadata.fullFunctionName(scc.targetName, scc.targetSignature));
                                        if (removedFunction == null) break block0;
                                        this.executor.submit(new Runnable(){

                                            @Override
                                            public void run() {
                                                Cluster.this.manager.metadata.triggerOnFunctionRemoved(removedFunction);
                                            }
                                        });
                                        break block0;
                                    }
                                    case 4: {
                                        removedAggregate = keyspace.removeAggregate(Metadata.fullFunctionName(scc.targetName, scc.targetSignature));
                                        if (removedAggregate == null) break block0;
                                        this.executor.submit(new Runnable(){

                                            @Override
                                            public void run() {
                                                Cluster.this.manager.metadata.triggerOnAggregateRemoved(removedAggregate);
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        void refreshConnectedHosts() {
            Host ccHost = this.controlConnection.connectedHost();
            if (ccHost == null || this.loadBalancingPolicy().distance(ccHost) != HostDistance.LOCAL) {
                this.controlConnection.triggerReconnect();
            }
            try {
                for (SessionManager s : this.sessions) {
                    Uninterruptibles.getUninterruptibly(s.updateCreatedPools());
                }
            }
            catch (ExecutionException e) {
                throw DriverThrowables.propagateCause(e);
            }
        }

        void refreshConnectedHost(Host host) {
            Host ccHost = this.controlConnection.connectedHost();
            if (ccHost == null || ccHost.equals(host) && this.loadBalancingPolicy().distance(ccHost) != HostDistance.LOCAL) {
                this.controlConnection.triggerReconnect();
            }
            for (SessionManager s : this.sessions) {
                s.updateCreatedPools(host);
            }
        }

        private class NodeListRefreshRequestDeliveryCallback
        implements EventDebouncer.DeliveryCallback<NodeListRefreshRequest> {
            private NodeListRefreshRequestDeliveryCallback() {
            }

            @Override
            public ListenableFuture<?> deliver(List<NodeListRefreshRequest> events) {
                return Manager.this.executor.submit((Runnable)new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.controlConnection.refreshNodeListAndTokenMap();
                    }
                });
            }
        }

        private class NodeListRefreshRequest {
            private NodeListRefreshRequest() {
            }

            public String toString() {
                return "Refresh node list and token map";
            }
        }

        private class NodeRefreshRequestDeliveryCallback
        implements EventDebouncer.DeliveryCallback<NodeRefreshRequest> {
            private NodeRefreshRequestDeliveryCallback() {
            }

            @Override
            public ListenableFuture<?> deliver(List<NodeRefreshRequest> events) {
                HashMap<InetSocketAddress, HostEvent> hosts = new HashMap<InetSocketAddress, HostEvent>();
                for (NodeRefreshRequest req : events) {
                    hosts.put(req.address, req.eventType);
                }
                ArrayList futures = new ArrayList(hosts.size());
                for (Map.Entry entry : hosts.entrySet()) {
                    InetSocketAddress address = (InetSocketAddress)entry.getKey();
                    HostEvent eventType = (HostEvent)((Object)entry.getValue());
                    switch (eventType) {
                        case UP: {
                            Host upHost = Manager.this.metadata.getHost(address);
                            if (upHost == null) {
                                upHost = Manager.this.metadata.add(address);
                                if (upHost == null) break;
                                futures.add(this.schedule(this.hostAdded(upHost)));
                                break;
                            }
                            futures.add(this.schedule(this.hostUp(upHost)));
                            break;
                        }
                        case ADDED: {
                            Host newHost = Manager.this.metadata.add(address);
                            if (newHost != null) {
                                futures.add(this.schedule(this.hostAdded(newHost)));
                                break;
                            }
                            Host existingHost = Manager.this.metadata.getHost(address);
                            if (existingHost.isUp()) break;
                            futures.add(this.schedule(this.hostUp(existingHost)));
                            break;
                        }
                        case DOWN: {
                            Host downHost = Manager.this.metadata.getHost(address);
                            if (downHost == null) break;
                            if (downHost.convictionPolicy.hasActiveConnections()) {
                                logger.debug("Ignoring down event on {} because it still has active connections", (Object)downHost);
                                break;
                            }
                            futures.add(this.execute(this.hostDown(downHost)));
                            break;
                        }
                        case REMOVED: {
                            Host removedHost = Manager.this.metadata.getHost(address);
                            if (removedHost == null) break;
                            futures.add(this.execute(this.hostRemoved(removedHost)));
                        }
                    }
                }
                return Futures.allAsList(futures);
            }

            private ListenableFuture<?> execute(ExceptionCatchingRunnable task) {
                return Manager.this.executor.submit((Runnable)task);
            }

            private ListenableFuture<?> schedule(final ExceptionCatchingRunnable task) {
                if (Manager.this.protocolVersion().compareTo(ProtocolVersion.V4) < 0) {
                    final SettableFuture future = SettableFuture.create();
                    Manager.this.scheduledTasksExecutor.schedule(new ExceptionCatchingRunnable(){

                        @Override
                        public void runMayThrow() throws Exception {
                            ListenableFuture f = NodeRefreshRequestDeliveryCallback.this.execute(task);
                            Futures.addCallback((ListenableFuture)f, (FutureCallback)new FutureCallback<Object>(){

                                public void onSuccess(Object result) {
                                    future.set(null);
                                }

                                public void onFailure(Throwable t) {
                                    future.setException(t);
                                }
                            });
                        }
                    }, (long)NEW_NODE_DELAY_SECONDS, TimeUnit.SECONDS);
                    return future;
                }
                return this.execute(task);
            }

            private ExceptionCatchingRunnable hostAdded(final Host host) {
                return new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        if (Manager.this.controlConnection.refreshNodeInfo(host)) {
                            Manager.this.onAdd(host, null);
                            Manager.this.submitNodeListRefresh();
                        } else {
                            logger.debug("Not enough info for {}, ignoring host", (Object)host);
                        }
                    }
                };
            }

            private ExceptionCatchingRunnable hostUp(final Host host) {
                return new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        if (Manager.this.controlConnection.refreshNodeInfo(host)) {
                            Manager.this.onUp(host, null);
                        } else {
                            logger.debug("Not enough info for {}, ignoring host", (Object)host);
                        }
                    }
                };
            }

            private ExceptionCatchingRunnable hostDown(final Host host) {
                return new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        Manager.this.onDown(host, false, true);
                    }
                };
            }

            private ExceptionCatchingRunnable hostRemoved(final Host host) {
                return new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        if (Manager.this.metadata.remove(host)) {
                            logger.info("Cassandra host {} removed", (Object)host);
                            Manager.this.onRemove(host);
                            Manager.this.submitNodeListRefresh();
                        }
                    }
                };
            }
        }

        private class NodeRefreshRequest {
            private final InetSocketAddress address;
            private final HostEvent eventType;

            private NodeRefreshRequest(InetSocketAddress address, HostEvent eventType) {
                this.address = address;
                this.eventType = eventType;
            }

            public String toString() {
                return this.address + " " + (Object)((Object)this.eventType);
            }
        }

        private class SchemaRefreshRequestDeliveryCallback
        implements EventDebouncer.DeliveryCallback<SchemaRefreshRequest> {
            private SchemaRefreshRequestDeliveryCallback() {
            }

            @Override
            public ListenableFuture<?> deliver(final List<SchemaRefreshRequest> events) {
                return Manager.this.executor.submit((Runnable)new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        SchemaRefreshRequest coalesced = null;
                        for (SchemaRefreshRequest request : events) {
                            coalesced = coalesced == null ? request : coalesced.coalesce(request);
                        }
                        assert (coalesced != null);
                        logger.trace("Coalesced schema refresh request: {}", coalesced);
                        Manager.this.controlConnection.refreshSchema(coalesced.targetType, coalesced.targetKeyspace, coalesced.targetName, coalesced.targetSignature);
                    }
                });
            }
        }

        private class SchemaRefreshRequest {
            private final SchemaElement targetType;
            private final String targetKeyspace;
            private final String targetName;
            private final List<String> targetSignature;

            public SchemaRefreshRequest(SchemaElement targetType, String targetKeyspace, String targetName, List<String> targetSignature) {
                this.targetType = targetType;
                this.targetKeyspace = Strings.emptyToNull((String)targetKeyspace);
                this.targetName = Strings.emptyToNull((String)targetName);
                this.targetSignature = targetSignature;
            }

            SchemaRefreshRequest coalesce(SchemaRefreshRequest that) {
                if (this.targetType == null || that.targetType == null) {
                    return new SchemaRefreshRequest(null, null, null, null);
                }
                if (!this.targetKeyspace.equals(that.targetKeyspace)) {
                    return new SchemaRefreshRequest(null, null, null, null);
                }
                if (this.targetName == null || that.targetName == null) {
                    return new SchemaRefreshRequest(SchemaElement.KEYSPACE, this.targetKeyspace, null, null);
                }
                if (!this.targetName.equals(that.targetName)) {
                    return new SchemaRefreshRequest(SchemaElement.KEYSPACE, this.targetKeyspace, null, null);
                }
                return this;
            }

            public String toString() {
                if (this.targetType == null) {
                    return "Refresh ALL";
                }
                if (this.targetName == null) {
                    return "Refresh keyspace " + this.targetKeyspace;
                }
                return String.format("Refresh %s %s.%s", new Object[]{this.targetType, this.targetKeyspace, this.targetName});
            }
        }

        private class CleanupIdleConnectionsTask
        implements Runnable {
            private CleanupIdleConnectionsTask() {
            }

            @Override
            public void run() {
                try {
                    long now = System.currentTimeMillis();
                    for (SessionManager session : Manager.this.sessions) {
                        session.cleanupIdleConnections(now);
                    }
                }
                catch (Exception e) {
                    logger.warn("Error while trashing idle connections", (Throwable)e);
                }
            }
        }

        private class ClusterCloseFuture
        extends CloseFuture.Forwarding {
            ClusterCloseFuture(List<CloseFuture> futures) {
                super(futures);
            }

            @Override
            public CloseFuture force() {
                Manager.this.shutdownNow((ExecutorService)Manager.this.executor);
                return super.force();
            }

            @Override
            protected void onFuturesDone() {
                new Thread("Shutdown-checker"){

                    @Override
                    public void run() {
                        try {
                            Manager.this.reconnectionExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            Manager.this.scheduledTasksExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            Manager.this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            Manager.this.blockingExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            Manager.this.connectionFactory.shutdown();
                            Manager.this.reaper.shutdown();
                            ClusterCloseFuture.this.set(null);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            ClusterCloseFuture.this.setException(e);
                        }
                    }
                }.start();
            }
        }
    }

    public static class Builder
    implements Initializer {
        private String clusterName;
        private final List<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        private final List<InetAddress> rawAddresses = new ArrayList<InetAddress>();
        private int port = 9042;
        private int maxSchemaAgreementWaitSeconds = 10;
        private ProtocolVersion protocolVersion;
        private AuthProvider authProvider = AuthProvider.NONE;
        private final Policies.Builder policiesBuilder = Policies.builder();
        private final Configuration.Builder configurationBuilder = Configuration.builder();
        private ProtocolOptions.Compression compression = ProtocolOptions.Compression.NONE;
        private SSLOptions sslOptions = null;
        private boolean metricsEnabled = true;
        private boolean jmxEnabled = true;
        private boolean allowBetaProtocolVersion = false;
        private Collection<Host.StateListener> listeners;

        @Override
        public String getClusterName() {
            return this.clusterName;
        }

        @Override
        public List<InetSocketAddress> getContactPoints() {
            if (this.rawAddresses.isEmpty()) {
                return this.addresses;
            }
            ArrayList<InetSocketAddress> allAddresses = new ArrayList<InetSocketAddress>(this.addresses);
            for (InetAddress address : this.rawAddresses) {
                allAddresses.add(new InetSocketAddress(address, this.port));
            }
            return allAddresses;
        }

        public Builder withClusterName(String name) {
            this.clusterName = name;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder allowBetaProtocolVersion() {
            if (this.protocolVersion != null) {
                throw new IllegalArgumentException("Can't use beta flag with initial protocol version of " + (Object)((Object)this.protocolVersion));
            }
            this.allowBetaProtocolVersion = true;
            this.protocolVersion = ProtocolVersion.NEWEST_BETA;
            return this;
        }

        public Builder withMaxSchemaAgreementWaitSeconds(int maxSchemaAgreementWaitSeconds) {
            if (maxSchemaAgreementWaitSeconds <= 0) {
                throw new IllegalArgumentException("Max schema agreement wait must be greater than zero");
            }
            this.maxSchemaAgreementWaitSeconds = maxSchemaAgreementWaitSeconds;
            return this;
        }

        public Builder withProtocolVersion(ProtocolVersion version) {
            if (this.allowBetaProtocolVersion) {
                throw new IllegalStateException("Can not set the version explicitly if `allowBetaProtocolVersion` was used.");
            }
            if (version.compareTo(ProtocolVersion.NEWEST_SUPPORTED) > 0) {
                throw new IllegalArgumentException("Can not use " + (Object)((Object)version) + " protocol version. Newest supported protocol version is: " + (Object)((Object)ProtocolVersion.NEWEST_SUPPORTED) + ". For beta versions, use `allowBetaProtocolVersion` instead");
            }
            this.protocolVersion = version;
            return this;
        }

        public Builder addContactPoint(String address) {
            if (address == null) {
                throw new NullPointerException();
            }
            try {
                this.addContactPoints(InetAddress.getAllByName(address));
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder addContactPoints(String ... addresses) {
            for (String address : addresses) {
                this.addContactPoint(address);
            }
            return this;
        }

        public Builder addContactPoints(InetAddress ... addresses) {
            Collections.addAll(this.rawAddresses, addresses);
            return this;
        }

        public Builder addContactPoints(Collection<InetAddress> addresses) {
            this.rawAddresses.addAll(addresses);
            return this;
        }

        public Builder addContactPointsWithPorts(InetSocketAddress ... addresses) {
            Collections.addAll(this.addresses, addresses);
            return this;
        }

        public Builder addContactPointsWithPorts(Collection<InetSocketAddress> addresses) {
            this.addresses.addAll(addresses);
            return this;
        }

        public Builder withLoadBalancingPolicy(LoadBalancingPolicy policy) {
            this.policiesBuilder.withLoadBalancingPolicy(policy);
            return this;
        }

        public Builder withReconnectionPolicy(ReconnectionPolicy policy) {
            this.policiesBuilder.withReconnectionPolicy(policy);
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy policy) {
            this.policiesBuilder.withRetryPolicy(policy);
            return this;
        }

        public Builder withAddressTranslator(AddressTranslator translator) {
            this.policiesBuilder.withAddressTranslator(translator);
            return this;
        }

        public Builder withTimestampGenerator(TimestampGenerator timestampGenerator) {
            this.policiesBuilder.withTimestampGenerator(timestampGenerator);
            return this;
        }

        public Builder withSpeculativeExecutionPolicy(SpeculativeExecutionPolicy policy) {
            this.policiesBuilder.withSpeculativeExecutionPolicy(policy);
            return this;
        }

        public Builder withCodecRegistry(CodecRegistry codecRegistry) {
            this.configurationBuilder.withCodecRegistry(codecRegistry);
            return this;
        }

        public Builder withCredentials(String username, String password) {
            this.authProvider = new PlainTextAuthProvider(username, password);
            return this;
        }

        public Builder withAuthProvider(AuthProvider authProvider) {
            this.authProvider = authProvider;
            return this;
        }

        public Builder withCompression(ProtocolOptions.Compression compression) {
            this.compression = compression;
            return this;
        }

        public Builder withoutMetrics() {
            this.metricsEnabled = false;
            return this;
        }

        public Builder withSSL() {
            this.sslOptions = RemoteEndpointAwareJdkSSLOptions.builder().build();
            return this;
        }

        public Builder withSSL(SSLOptions sslOptions) {
            this.sslOptions = sslOptions;
            return this;
        }

        public Builder withInitialListeners(Collection<Host.StateListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder withoutJMXReporting() {
            this.jmxEnabled = false;
            return this;
        }

        public Builder withPoolingOptions(PoolingOptions options) {
            this.configurationBuilder.withPoolingOptions(options);
            return this;
        }

        public Builder withSocketOptions(SocketOptions options) {
            this.configurationBuilder.withSocketOptions(options);
            return this;
        }

        public Builder withQueryOptions(QueryOptions options) {
            this.configurationBuilder.withQueryOptions(options);
            return this;
        }

        public Builder withThreadingOptions(ThreadingOptions options) {
            this.configurationBuilder.withThreadingOptions(options);
            return this;
        }

        public Builder withNettyOptions(NettyOptions nettyOptions) {
            this.configurationBuilder.withNettyOptions(nettyOptions);
            return this;
        }

        @Override
        public Configuration getConfiguration() {
            ProtocolOptions protocolOptions = new ProtocolOptions(this.port, this.protocolVersion, this.maxSchemaAgreementWaitSeconds, this.sslOptions, this.authProvider).setCompression(this.compression);
            MetricsOptions metricsOptions = new MetricsOptions(this.metricsEnabled, this.jmxEnabled);
            return this.configurationBuilder.withProtocolOptions(protocolOptions).withMetricsOptions(metricsOptions).withPolicies(this.policiesBuilder.build()).build();
        }

        @Override
        public Collection<Host.StateListener> getInitialListeners() {
            return this.listeners == null ? Collections.emptySet() : this.listeners;
        }

        public Cluster build() {
            return Cluster.buildFrom(this);
        }
    }

    public static interface Initializer {
        public String getClusterName();

        public List<InetSocketAddress> getContactPoints();

        public Configuration getConfiguration();

        public Collection<Host.StateListener> getInitialListeners();
    }
}

