/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.shaded.esri.MultiPath;
import com.datastax.shaded.esri.ogc.OGCGeometry;
import com.datastax.shaded.esri.ogc.OGCPoint;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Distance
extends Geometry {
    private static final Pattern WKT_PATTERN = Pattern.compile("distance *\\( *\\( *([\\d\\.-]+) *([\\d+\\.-]+) *\\) *([\\d+\\.-]+) *\\)", 2);
    private final Point center;
    private final double radius;

    public static Distance fromWellKnownText(String source) {
        Matcher matcher = WKT_PATTERN.matcher(source.trim());
        if (matcher.matches() && matcher.groupCount() == 3) {
            try {
                return new Distance(new Point(Double.parseDouble(matcher.group(1)), Double.parseDouble(matcher.group(2))), Double.parseDouble(matcher.group(3)));
            }
            catch (NumberFormatException var3) {
                throw new InvalidTypeException(String.format("Unable to parse %s", source));
            }
        }
        throw new InvalidTypeException(String.format("Unable to parse %s", source));
    }

    public Distance(Point center, double radius) {
        super(center.getOgcGeometry());
        Preconditions.checkNotNull((Object)center);
        Preconditions.checkNotNull((Object)radius);
        this.center = center;
        this.radius = radius;
    }

    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public String asWellKnownText() {
        return String.format("DISTANCE((%s %s) %s)", this.center.X(), this.center.Y(), this.radius);
    }

    @Override
    OGCGeometry getOgcGeometry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer asWellKnownBinary() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String asGeoJson() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            Distance distance = (Distance)o;
            return Double.compare(distance.radius, this.radius) == 0 && this.center.equals(distance.center);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = this.center.hashCode();
        long temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean contains(Geometry geometry) {
        return geometry instanceof Distance ? this.containsDistance((Distance)geometry) : (geometry instanceof Point ? this.containsPoint((Point)geometry) : (geometry instanceof LineString ? this.containsLineString((LineString)geometry) : (geometry instanceof Polygon ? this.containsPolygon((Polygon)geometry) : false)));
    }

    private boolean containsDistance(Distance distance) {
        return this.center.getOgcGeometry().distance(distance.center.getOgcGeometry()) + distance.radius <= this.radius;
    }

    private boolean containsPoint(Point point) {
        return this.containsOGCPoint(point.getOgcGeometry());
    }

    private boolean containsLineString(LineString lineString) {
        MultiPath multiPath = (MultiPath)lineString.getOgcGeometry().getEsriGeometry();
        return this.containsMultiPath(multiPath);
    }

    private boolean containsPolygon(Polygon polygon) {
        com.datastax.shaded.esri.Polygon multiPath = (com.datastax.shaded.esri.Polygon)polygon.getOgcGeometry().getEsriGeometry();
        return this.containsMultiPath(multiPath);
    }

    private boolean containsMultiPath(MultiPath multiPath) {
        int numPoints = multiPath.getPointCount();
        for (int i = 0; i < numPoints; ++i) {
            OGCPoint point = new OGCPoint(multiPath.getPoint(i), Geometry.SPATIAL_REFERENCE_4326);
            if (this.containsOGCPoint(point)) continue;
            return false;
        }
        return true;
    }

    private boolean containsOGCPoint(OGCPoint point) {
        return this.center.getOgcGeometry().distance(point) <= this.radius;
    }
}

